/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zählstelle zur Erfassung von Verkehrsdaten allgemein. Bei der konkreten Ausprägung kann es sich sowohl um eine TLS-Streckenstation, Langzeitzählstellen zur Verkehrsdatenerfassung, manuelle Zählstellen o.ä. handeln. Der Typ fasst alle allgemeingültigen Eigenschaften zusammen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class LangZeitZaehlstelleImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.LangZeitZaehlstelle { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public LangZeitZaehlstelleImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public LangZeitZaehlstelleImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Langzeitzählstelle.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt> auswerteQuerschnitte;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt> getAuswerteQuerschnitte() {
		if (auswerteQuerschnitte == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("AuswerteQuerschnitte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("AuswerteQuerschnitte").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt) getObjektFactory().getModellobjekt(so));
			}
			auswerteQuerschnitte = Collections.unmodifiableCollection(menge);
		}
		return auswerteQuerschnitte;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenFahrzeugAnzahl getOdLangZeitDatenFahrzeugAnzahl() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenFahrzeugAnzahl.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK130 getOdLangZeitDatenVK130() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK130.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.konfigurationsdaten.KdLangZeitZaehlstelle getKdLangZeitZaehlstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.konfigurationsdaten.KdLangZeitZaehlstelle.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK160 getOdLangZeitDatenVK160() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK160.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenStunde getOdLangZeitDatenSpitzenStunde() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenStunde.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenGeschwindigkeit getOdLangZeitDatenGeschwindigkeit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenGeschwindigkeit.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV50 getOdLangZeitDatenV50() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV50.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenDTV getOdLangZeitDatenDTV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenDTV.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV15 getOdLangZeitDatenV15() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV15.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenTag getOdLangZeitDatenSpitzenTag() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenTag.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV85 getOdLangZeitDatenV85() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV85.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitMSV getOdVerkehrsDatenLangZeitMSV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitMSV.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
