/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Langzeitdaten der Datenart Fahrzeuganzahl in [Fz].
<p>
&lt;sektion&gt;
						&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuganzahl&lt;&#47;titel&gt;
						&lt;absatz&gt;Langzeitdaten der Datenart Fahrzeuganzahl sind im Erfassungsintervall erfasste Zählwerte bzw. je Aggregationsintervall aufsummierte Zählwerte. Sie werden als absoluter Wert mit der Einheit "Fahrzeuge" angegeben.&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class OdLangZeitDatenFahrzeugAnzahl extends AbstractOnlineDatensatz<OdLangZeitDatenFahrzeugAnzahl.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AggregationsIntervall15Minuten,
					Aspekte.AggregationsIntervallTag,
					Aspekte.AggregationsIntervallStunde,
					Aspekte.AggregationsIntervallJahr,
					Aspekte.AggregationsIntervallMonat,
				};
			}
	
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 15 Minuten zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervall15Minuten = new Aspekte("AggregationsIntervall15Minuten", "asp.aggregationsIntervall15Minuten");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Tag (24 Stunden) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallTag = new Aspekte("AggregationsIntervallTag", "asp.aggregationsIntervallTag");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Stunde (60 Minuten) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallStunde = new Aspekte("AggregationsIntervallStunde", "asp.aggregationsIntervallStunde");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Jahr zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallJahr = new Aspekte("AggregationsIntervallJahr", "asp.aggregationsIntervallJahr");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Monat zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallMonat = new Aspekte("AggregationsIntervallMonat", "asp.aggregationsIntervallMonat");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _kfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _pkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _lkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _kfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _pkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _pkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _krad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _lfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _pkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _lkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _bus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _lkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _lkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _sattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Kfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getKfz() {
				return _kfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@param _kfz der neue Wert von Kfz.
			*/
			public void setKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _kfz) {
				this._kfz = _kfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getPkwAe() {
				return _pkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkwAe der neue Wert von PkwAe.
			*/
			public void setPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _pkwAe) {
				this._pkwAe = _pkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getLkwAe() {
				return _lkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkwAe der neue Wert von LkwAe.
			*/
			public void setLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _lkwAe) {
				this._lkwAe = _lkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von KfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getKfzNk() {
				return _kfzNk;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _kfzNk der neue Wert von KfzNk.
			*/
			public void setKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _kfzNk) {
				this._kfzNk = _kfzNk;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getPkwG() {
				return _pkwG;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkwG der neue Wert von PkwG.
			*/
			public void setPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _pkwG) {
				this._pkwG = _pkwG;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Pkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getPkw() {
				return _pkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkw der neue Wert von Pkw.
			*/
			public void setPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _pkw) {
				this._pkw = _pkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Krad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getKrad() {
				return _krad;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@param _krad der neue Wert von Krad.
			*/
			public void setKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _krad) {
				this._krad = _krad;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Lfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getLfw() {
				return _lfw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lfw der neue Wert von Lfw.
			*/
			public void setLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _lfw) {
				this._lfw = _lfw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getPkwA() {
				return _pkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkwA der neue Wert von PkwA.
			*/
			public void setPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _pkwA) {
				this._pkwA = _pkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Lkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getLkw() {
				return _lkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkw der neue Wert von Lkw.
			*/
			public void setLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _lkw) {
				this._lkw = _lkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Bus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getBus() {
				return _bus;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@param _bus der neue Wert von Bus.
			*/
			public void setBus(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _bus) {
				this._bus = _bus;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getLkwK() {
				return _lkwK;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkwK der neue Wert von LkwK.
			*/
			public void setLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _lkwK) {
				this._lkwK = _lkwK;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getLkwA() {
				return _lkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkwA der neue Wert von LkwA.
			*/
			public void setLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _lkwA) {
				this._lkwA = _lkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von SattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getSattelKfz() {
				return _sattelKfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _sattelKfz der neue Wert von SattelKfz.
			*/
			public void setSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _sattelKfz) {
				this._sattelKfz = _sattelKfz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getKfz().bean2Atl(datum.getItem("Kfz"), factory);
					// AttributListenDefinition
						getPkwAe().bean2Atl(datum.getItem("PkwÄ"), factory);
					// AttributListenDefinition
						getLkwAe().bean2Atl(datum.getItem("LkwÄ"), factory);
					// AttributListenDefinition
						getKfzNk().bean2Atl(datum.getItem("KfzNk"), factory);
					// AttributListenDefinition
						getPkwG().bean2Atl(datum.getItem("PkwG"), factory);
					// AttributListenDefinition
						getPkw().bean2Atl(datum.getItem("Pkw"), factory);
					// AttributListenDefinition
						getKrad().bean2Atl(datum.getItem("Krad"), factory);
					// AttributListenDefinition
						getLfw().bean2Atl(datum.getItem("Lfw"), factory);
					// AttributListenDefinition
						getPkwA().bean2Atl(datum.getItem("PkwA"), factory);
					// AttributListenDefinition
						getLkw().bean2Atl(datum.getItem("Lkw"), factory);
					// AttributListenDefinition
						getBus().bean2Atl(datum.getItem("Bus"), factory);
					// AttributListenDefinition
						getLkwK().bean2Atl(datum.getItem("LkwK"), factory);
					// AttributListenDefinition
						getLkwA().bean2Atl(datum.getItem("LkwA"), factory);
					// AttributListenDefinition
						getSattelKfz().bean2Atl(datum.getItem("SattelKfz"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getKfz().atl2Bean(daten.getItem("Kfz"), factory);
					// AttributListenDefinition
						getPkwAe().atl2Bean(daten.getItem("PkwÄ"), factory);
					// AttributListenDefinition
						getLkwAe().atl2Bean(daten.getItem("LkwÄ"), factory);
					// AttributListenDefinition
						getKfzNk().atl2Bean(daten.getItem("KfzNk"), factory);
					// AttributListenDefinition
						getPkwG().atl2Bean(daten.getItem("PkwG"), factory);
					// AttributListenDefinition
						getPkw().atl2Bean(daten.getItem("Pkw"), factory);
					// AttributListenDefinition
						getKrad().atl2Bean(daten.getItem("Krad"), factory);
					// AttributListenDefinition
						getLfw().atl2Bean(daten.getItem("Lfw"), factory);
					// AttributListenDefinition
						getPkwA().atl2Bean(daten.getItem("PkwA"), factory);
					// AttributListenDefinition
						getLkw().atl2Bean(daten.getItem("Lkw"), factory);
					// AttributListenDefinition
						getBus().atl2Bean(daten.getItem("Bus"), factory);
					// AttributListenDefinition
						getLkwK().atl2Bean(daten.getItem("LkwK"), factory);
					// AttributListenDefinition
						getLkwA().atl2Bean(daten.getItem("LkwA"), factory);
					// AttributListenDefinition
						getSattelKfz().atl2Bean(daten.getItem("SattelKfz"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._kfz = getKfz().clone();
							klon._pkwAe = getPkwAe().clone();
							klon._lkwAe = getLkwAe().clone();
							klon._kfzNk = getKfzNk().clone();
							klon._pkwG = getPkwG().clone();
							klon._pkw = getPkw().clone();
							klon._krad = getKrad().clone();
							klon._lfw = getLfw().clone();
							klon._pkwA = getPkwA().clone();
							klon._lkw = getLkw().clone();
							klon._bus = getBus().clone();
							klon._lkwK = getLkwK().clone();
							klon._lkwA = getLkwA().clone();
							klon._sattelKfz = getSattelKfz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.langZeitDatenFahrzeugAnzahl";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdLangZeitDatenFahrzeugAnzahl(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
