/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Spitzenstunde gibt die Stunde mit der höchsten Verkehsbelastung an.
<p>
&lt;sektion&gt;
						&lt;titel&gt;Spitzenstunde (Stunde mit der höchsten Verkehsbelastung)&lt;&#47;titel&gt;
						&lt;absatz&gt;Die Spitzenstunde gibt die Stunde mit der höchsten Verkehsbelastung im zugrundeliegenden Intervall an. Die Spitzenstunde wird ab dem Aggregationsintervall Tag bestimmt und als Zeiteinheit angegeben.&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class OdLangZeitDatenSpitzenStunde extends AbstractOnlineDatensatz<OdLangZeitDatenSpitzenStunde.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AggregationsIntervall15Minuten,
					Aspekte.AggregationsIntervallTag,
					Aspekte.AggregationsIntervallStunde,
					Aspekte.AggregationsIntervallJahr,
					Aspekte.AggregationsIntervallMonat,
				};
			}
	
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 15 Minuten zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervall15Minuten = new Aspekte("AggregationsIntervall15Minuten", "asp.aggregationsIntervall15Minuten");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Tag (24 Stunden) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallTag = new Aspekte("AggregationsIntervallTag", "asp.aggregationsIntervallTag");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Stunde (60 Minuten) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallStunde = new Aspekte("AggregationsIntervallStunde", "asp.aggregationsIntervallStunde");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Jahr zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallJahr = new Aspekte("AggregationsIntervallJahr", "asp.aggregationsIntervallJahr");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Monat zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallMonat = new Aspekte("AggregationsIntervallMonat", "asp.aggregationsIntervallMonat");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _kfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _pkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _lkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _kfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _pkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _pkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _krad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _lfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _pkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _lkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _bus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _lkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _lkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 _sattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qPkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qLkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qKfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qKrad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qLfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qPkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qBus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qLkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qLkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 _qSattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				()
				;
		
			/**
			Spitzenstunde für die Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Kfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getKfz() {
				return _kfz;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@param _kfz der neue Wert von Kfz.
			*/
			public void setKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _kfz) {
				this._kfz = _kfz;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getPkwAe() {
				return _pkwAe;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkwAe der neue Wert von PkwAe.
			*/
			public void setPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _pkwAe) {
				this._pkwAe = _pkwAe;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getLkwAe() {
				return _lkwAe;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkwAe der neue Wert von LkwAe.
			*/
			public void setLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _lkwAe) {
				this._lkwAe = _lkwAe;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von KfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getKfzNk() {
				return _kfzNk;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _kfzNk der neue Wert von KfzNk.
			*/
			public void setKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _kfzNk) {
				this._kfzNk = _kfzNk;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getPkwG() {
				return _pkwG;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkwG der neue Wert von PkwG.
			*/
			public void setPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _pkwG) {
				this._pkwG = _pkwG;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Pkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getPkw() {
				return _pkw;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkw der neue Wert von Pkw.
			*/
			public void setPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _pkw) {
				this._pkw = _pkw;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Krad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getKrad() {
				return _krad;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@param _krad der neue Wert von Krad.
			*/
			public void setKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _krad) {
				this._krad = _krad;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Lfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getLfw() {
				return _lfw;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lfw der neue Wert von Lfw.
			*/
			public void setLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _lfw) {
				this._lfw = _lfw;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getPkwA() {
				return _pkwA;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@param _pkwA der neue Wert von PkwA.
			*/
			public void setPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _pkwA) {
				this._pkwA = _pkwA;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Lkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getLkw() {
				return _lkw;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkw der neue Wert von Lkw.
			*/
			public void setLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _lkw) {
				this._lkw = _lkw;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Bus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getBus() {
				return _bus;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@param _bus der neue Wert von Bus.
			*/
			public void setBus(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _bus) {
				this._bus = _bus;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getLkwK() {
				return _lkwK;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkwK der neue Wert von LkwK.
			*/
			public void setLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _lkwK) {
				this._lkwK = _lkwK;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getLkwA() {
				return _lkwA;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@param _lkwA der neue Wert von LkwA.
			*/
			public void setLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _lkwA) {
				this._lkwA = _lkwA;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von SattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
				 getSattelKfz() {
				return _sattelKfz;
			}
		
			/**
			Spitzenstunde für die Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _sattelKfz der neue Wert von SattelKfz.
			*/
			public void setSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenSpitzenZeit
			 _sattelKfz) {
				this._sattelKfz = _sattelKfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQPkwAe() {
				return _qPkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qPkwAe der neue Wert von QPkwAe.
			*/
			public void setQPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qPkwAe) {
				this._qPkwAe = _qPkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQLkwAe() {
				return _qLkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qLkwAe der neue Wert von QLkwAe.
			*/
			public void setQLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qLkwAe) {
				this._qLkwAe = _qLkwAe;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQKfzNk() {
				return _qKfzNk;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qKfzNk der neue Wert von QKfzNk.
			*/
			public void setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qKfzNk) {
				this._qKfzNk = _qKfzNk;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQPkwG() {
				return _qPkwG;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qPkwG der neue Wert von QPkwG.
			*/
			public void setQPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qPkwG) {
				this._qPkwG = _qPkwG;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQKrad() {
				return _qKrad;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qKrad der neue Wert von QKrad.
			*/
			public void setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qKrad) {
				this._qKrad = _qKrad;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQLfw() {
				return _qLfw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qLfw der neue Wert von QLfw.
			*/
			public void setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qLfw) {
				this._qLfw = _qLfw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQPkwA() {
				return _qPkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qPkwA der neue Wert von QPkwA.
			*/
			public void setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qPkwA) {
				this._qPkwA = _qPkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQBus() {
				return _qBus;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qBus der neue Wert von QBus.
			*/
			public void setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qBus) {
				this._qBus = _qBus;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQLkwK() {
				return _qLkwK;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qLkwK der neue Wert von QLkwK.
			*/
			public void setQLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qLkwK) {
				this._qLkwK = _qLkwK;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQLkwA() {
				return _qLkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qLkwA der neue Wert von QLkwA.
			*/
			public void setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qLkwA) {
				this._qLkwA = _qLkwA;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				 getQSattelKfz() {
				return _qSattelKfz;
			}
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@param _qSattelKfz der neue Wert von QSattelKfz.
			*/
			public void setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
			 _qSattelKfz) {
				this._qSattelKfz = _qSattelKfz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getKfz().bean2Atl(datum.getItem("Kfz"), factory);
					// AttributListenDefinition
						getPkwAe().bean2Atl(datum.getItem("PkwÄ"), factory);
					// AttributListenDefinition
						getLkwAe().bean2Atl(datum.getItem("LkwÄ"), factory);
					// AttributListenDefinition
						getKfzNk().bean2Atl(datum.getItem("KfzNk"), factory);
					// AttributListenDefinition
						getPkwG().bean2Atl(datum.getItem("PkwG"), factory);
					// AttributListenDefinition
						getPkw().bean2Atl(datum.getItem("Pkw"), factory);
					// AttributListenDefinition
						getKrad().bean2Atl(datum.getItem("Krad"), factory);
					// AttributListenDefinition
						getLfw().bean2Atl(datum.getItem("Lfw"), factory);
					// AttributListenDefinition
						getPkwA().bean2Atl(datum.getItem("PkwA"), factory);
					// AttributListenDefinition
						getLkw().bean2Atl(datum.getItem("Lkw"), factory);
					// AttributListenDefinition
						getBus().bean2Atl(datum.getItem("Bus"), factory);
					// AttributListenDefinition
						getLkwK().bean2Atl(datum.getItem("LkwK"), factory);
					// AttributListenDefinition
						getLkwA().bean2Atl(datum.getItem("LkwA"), factory);
					// AttributListenDefinition
						getSattelKfz().bean2Atl(datum.getItem("SattelKfz"), factory);
					// AttributListenDefinition
						getQKfz().bean2Atl(datum.getItem("qKfz"), factory);
					// AttributListenDefinition
						getQPkwAe().bean2Atl(datum.getItem("qPkwÄ"), factory);
					// AttributListenDefinition
						getQLkwAe().bean2Atl(datum.getItem("qLkwÄ"), factory);
					// AttributListenDefinition
						getQKfzNk().bean2Atl(datum.getItem("qKfzNk"), factory);
					// AttributListenDefinition
						getQPkwG().bean2Atl(datum.getItem("qPkwG"), factory);
					// AttributListenDefinition
						getQPkw().bean2Atl(datum.getItem("qPkw"), factory);
					// AttributListenDefinition
						getQKrad().bean2Atl(datum.getItem("qKrad"), factory);
					// AttributListenDefinition
						getQLfw().bean2Atl(datum.getItem("qLfw"), factory);
					// AttributListenDefinition
						getQPkwA().bean2Atl(datum.getItem("qPkwA"), factory);
					// AttributListenDefinition
						getQLkw().bean2Atl(datum.getItem("qLkw"), factory);
					// AttributListenDefinition
						getQBus().bean2Atl(datum.getItem("qBus"), factory);
					// AttributListenDefinition
						getQLkwK().bean2Atl(datum.getItem("qLkwK"), factory);
					// AttributListenDefinition
						getQLkwA().bean2Atl(datum.getItem("qLkwA"), factory);
					// AttributListenDefinition
						getQSattelKfz().bean2Atl(datum.getItem("qSattelKfz"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getKfz().atl2Bean(daten.getItem("Kfz"), factory);
					// AttributListenDefinition
						getPkwAe().atl2Bean(daten.getItem("PkwÄ"), factory);
					// AttributListenDefinition
						getLkwAe().atl2Bean(daten.getItem("LkwÄ"), factory);
					// AttributListenDefinition
						getKfzNk().atl2Bean(daten.getItem("KfzNk"), factory);
					// AttributListenDefinition
						getPkwG().atl2Bean(daten.getItem("PkwG"), factory);
					// AttributListenDefinition
						getPkw().atl2Bean(daten.getItem("Pkw"), factory);
					// AttributListenDefinition
						getKrad().atl2Bean(daten.getItem("Krad"), factory);
					// AttributListenDefinition
						getLfw().atl2Bean(daten.getItem("Lfw"), factory);
					// AttributListenDefinition
						getPkwA().atl2Bean(daten.getItem("PkwA"), factory);
					// AttributListenDefinition
						getLkw().atl2Bean(daten.getItem("Lkw"), factory);
					// AttributListenDefinition
						getBus().atl2Bean(daten.getItem("Bus"), factory);
					// AttributListenDefinition
						getLkwK().atl2Bean(daten.getItem("LkwK"), factory);
					// AttributListenDefinition
						getLkwA().atl2Bean(daten.getItem("LkwA"), factory);
					// AttributListenDefinition
						getSattelKfz().atl2Bean(daten.getItem("SattelKfz"), factory);
					// AttributListenDefinition
						getQKfz().atl2Bean(daten.getItem("qKfz"), factory);
					// AttributListenDefinition
						getQPkwAe().atl2Bean(daten.getItem("qPkwÄ"), factory);
					// AttributListenDefinition
						getQLkwAe().atl2Bean(daten.getItem("qLkwÄ"), factory);
					// AttributListenDefinition
						getQKfzNk().atl2Bean(daten.getItem("qKfzNk"), factory);
					// AttributListenDefinition
						getQPkwG().atl2Bean(daten.getItem("qPkwG"), factory);
					// AttributListenDefinition
						getQPkw().atl2Bean(daten.getItem("qPkw"), factory);
					// AttributListenDefinition
						getQKrad().atl2Bean(daten.getItem("qKrad"), factory);
					// AttributListenDefinition
						getQLfw().atl2Bean(daten.getItem("qLfw"), factory);
					// AttributListenDefinition
						getQPkwA().atl2Bean(daten.getItem("qPkwA"), factory);
					// AttributListenDefinition
						getQLkw().atl2Bean(daten.getItem("qLkw"), factory);
					// AttributListenDefinition
						getQBus().atl2Bean(daten.getItem("qBus"), factory);
					// AttributListenDefinition
						getQLkwK().atl2Bean(daten.getItem("qLkwK"), factory);
					// AttributListenDefinition
						getQLkwA().atl2Bean(daten.getItem("qLkwA"), factory);
					// AttributListenDefinition
						getQSattelKfz().atl2Bean(daten.getItem("qSattelKfz"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._kfz = getKfz().clone();
							klon._pkwAe = getPkwAe().clone();
							klon._lkwAe = getLkwAe().clone();
							klon._kfzNk = getKfzNk().clone();
							klon._pkwG = getPkwG().clone();
							klon._pkw = getPkw().clone();
							klon._krad = getKrad().clone();
							klon._lfw = getLfw().clone();
							klon._pkwA = getPkwA().clone();
							klon._lkw = getLkw().clone();
							klon._bus = getBus().clone();
							klon._lkwK = getLkwK().clone();
							klon._lkwA = getLkwA().clone();
							klon._sattelKfz = getSattelKfz().clone();
							klon._qKfz = getQKfz().clone();
							klon._qPkwAe = getQPkwAe().clone();
							klon._qLkwAe = getQLkwAe().clone();
							klon._qKfzNk = getQKfzNk().clone();
							klon._qPkwG = getQPkwG().clone();
							klon._qPkw = getQPkw().clone();
							klon._qKrad = getQKrad().clone();
							klon._qLfw = getQLfw().clone();
							klon._qPkwA = getQPkwA().clone();
							klon._qLkw = getQLkw().clone();
							klon._qBus = getQBus().clone();
							klon._qLkwK = getQLkwK().clone();
							klon._qLkwA = getQLkwA().clone();
							klon._qSattelKfz = getQSattelKfz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.langZeitDatenSpitzenStunde";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdLangZeitDatenSpitzenStunde(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
