/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Geschwindigkeitsklassifizierung entsprechend Geschwindigkeitsraster VK130 (0-50 km&#47;h, 50-60 km&#47;h, ... , 120-130 km&#47;h, 130- km&#47;h).
<p>
&lt;sektion&gt;
						&lt;titel&gt;Fahrzeuganzahl in den Geschwindigkeitsklassen&lt;&#47;titel&gt;
						&lt;absatz&gt;Langzeitdaten für die Geschwindigkeitsklassen, der Wert gibt die absolute Fahrzeuganzahl im Erfassungsintervall bzw. Aggregationsintervall an. Die Angabe erfolgt mit der Einheit "Fahrzeuge". Folgendes festes Geschwindigkeitsraster mit 10 Klassen wird verwendet: (0-50 km&#47;h, 50-60 km&#47;h, ... , 120-130 km&#47;h, 130- km&#47;h)&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class OdLangZeitDatenVK130 extends AbstractOnlineDatensatz<OdLangZeitDatenVK130.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AggregationsIntervall15Minuten,
					Aspekte.AggregationsIntervallTag,
					Aspekte.AggregationsIntervallStunde,
					Aspekte.AggregationsIntervallJahr,
					Aspekte.AggregationsIntervallMonat,
				};
			}
	
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 15 Minuten zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervall15Minuten = new Aspekte("AggregationsIntervall15Minuten", "asp.aggregationsIntervall15Minuten");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Tag (24 Stunden) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallTag = new Aspekte("AggregationsIntervallTag", "asp.aggregationsIntervallTag");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Stunde (60 Minuten) zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallStunde = new Aspekte("AggregationsIntervallStunde", "asp.aggregationsIntervallStunde");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Jahr zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallJahr = new Aspekte("AggregationsIntervallJahr", "asp.aggregationsIntervallJahr");
			
			/**
			 * Der Aspekt kennzeichnet Daten, denen das Erfassungs bzw. Aggregationsintervall 1 Monat zugrundeliegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AggregationsIntervallMonat = new Aspekte("AggregationsIntervallMonat", "asp.aggregationsIntervallMonat");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _kfz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _pkwAe = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _lkwAe = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _kfzNk = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _pkwG = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _pkw = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _krad = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _lfw = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _pkwA = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _lkw = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _bus = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _lkwK = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _lkwA = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> _sattelKfz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				>(16, true);
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Kfz.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getKfz() {
				return _kfz;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwAe.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getPkwAe() {
				return _pkwAe;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lkw ähnliche Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwAe.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getLkwAe() {
				return _lkwAe;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "nicht klassifizierbare Fahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von KfzNk.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getKfzNk() {
				return _kfzNk;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Pkw Grundklasse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwG.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getPkwG() {
				return _pkwG;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Pkw.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getPkw() {
				return _pkw;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Kraftrad" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Krad.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getKrad() {
				return _krad;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lieferfahrzeug" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Lfw.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getLfw() {
				return _lfw;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Personenkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von PkwA.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getPkwA() {
				return _pkwA;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Lkw.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getLkw() {
				return _lkw;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Busse" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von Bus.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getBus() {
				return _bus;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen Kombination" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwK.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getLkwK() {
				return _lkwK;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Lastkraftwagen mit Anhänger" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von LkwA.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getLkwA() {
				return _lkwA;
			}
		
		
			/**
			Fahrzeuganzahl der Fahrzeugart "Sattel-Kraftfahrzeuge" entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von SattelKfz.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
				> getSattelKfz() {
				return _sattelKfz;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayKfz = datum.getArray("Kfz");
						arrayKfz.setLength(getKfz().size());
						for (int i = 0; i < arrayKfz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getKfz().get(i);
							atl.bean2Atl(arrayKfz.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayPkwAe = datum.getArray("PkwÄ");
						arrayPkwAe.setLength(getPkwAe().size());
						for (int i = 0; i < arrayPkwAe.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getPkwAe().get(i);
							atl.bean2Atl(arrayPkwAe.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayLkwAe = datum.getArray("LkwÄ");
						arrayLkwAe.setLength(getLkwAe().size());
						for (int i = 0; i < arrayLkwAe.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getLkwAe().get(i);
							atl.bean2Atl(arrayLkwAe.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKfzNk = datum.getArray("KfzNk");
						arrayKfzNk.setLength(getKfzNk().size());
						for (int i = 0; i < arrayKfzNk.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getKfzNk().get(i);
							atl.bean2Atl(arrayKfzNk.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayPkwG = datum.getArray("PkwG");
						arrayPkwG.setLength(getPkwG().size());
						for (int i = 0; i < arrayPkwG.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getPkwG().get(i);
							atl.bean2Atl(arrayPkwG.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayPkw = datum.getArray("Pkw");
						arrayPkw.setLength(getPkw().size());
						for (int i = 0; i < arrayPkw.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getPkw().get(i);
							atl.bean2Atl(arrayPkw.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKrad = datum.getArray("Krad");
						arrayKrad.setLength(getKrad().size());
						for (int i = 0; i < arrayKrad.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getKrad().get(i);
							atl.bean2Atl(arrayKrad.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayLfw = datum.getArray("Lfw");
						arrayLfw.setLength(getLfw().size());
						for (int i = 0; i < arrayLfw.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getLfw().get(i);
							atl.bean2Atl(arrayLfw.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayPkwA = datum.getArray("PkwA");
						arrayPkwA.setLength(getPkwA().size());
						for (int i = 0; i < arrayPkwA.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getPkwA().get(i);
							atl.bean2Atl(arrayPkwA.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayLkw = datum.getArray("Lkw");
						arrayLkw.setLength(getLkw().size());
						for (int i = 0; i < arrayLkw.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getLkw().get(i);
							atl.bean2Atl(arrayLkw.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayBus = datum.getArray("Bus");
						arrayBus.setLength(getBus().size());
						for (int i = 0; i < arrayBus.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getBus().get(i);
							atl.bean2Atl(arrayBus.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayLkwK = datum.getArray("LkwK");
						arrayLkwK.setLength(getLkwK().size());
						for (int i = 0; i < arrayLkwK.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getLkwK().get(i);
							atl.bean2Atl(arrayLkwK.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayLkwA = datum.getArray("LkwA");
						arrayLkwA.setLength(getLkwA().size());
						for (int i = 0; i < arrayLkwA.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getLkwA().get(i);
							atl.bean2Atl(arrayLkwA.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arraySattelKfz = datum.getArray("SattelKfz");
						arraySattelKfz.setLength(getSattelKfz().size());
						for (int i = 0; i < arraySattelKfz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = getSattelKfz().get(i);
							atl.bean2Atl(arraySattelKfz.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayKfz = daten.getArray("Kfz");
						for (int i = 0; i < arrayKfz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayKfz.getItem(i), factory);
							getKfz().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayPkwAe = daten.getArray("PkwÄ");
						for (int i = 0; i < arrayPkwAe.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayPkwAe.getItem(i), factory);
							getPkwAe().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayLkwAe = daten.getArray("LkwÄ");
						for (int i = 0; i < arrayLkwAe.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayLkwAe.getItem(i), factory);
							getLkwAe().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKfzNk = daten.getArray("KfzNk");
						for (int i = 0; i < arrayKfzNk.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayKfzNk.getItem(i), factory);
							getKfzNk().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayPkwG = daten.getArray("PkwG");
						for (int i = 0; i < arrayPkwG.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayPkwG.getItem(i), factory);
							getPkwG().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayPkw = daten.getArray("Pkw");
						for (int i = 0; i < arrayPkw.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayPkw.getItem(i), factory);
							getPkw().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKrad = daten.getArray("Krad");
						for (int i = 0; i < arrayKrad.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayKrad.getItem(i), factory);
							getKrad().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayLfw = daten.getArray("Lfw");
						for (int i = 0; i < arrayLfw.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayLfw.getItem(i), factory);
							getLfw().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayPkwA = daten.getArray("PkwA");
						for (int i = 0; i < arrayPkwA.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayPkwA.getItem(i), factory);
							getPkwA().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayLkw = daten.getArray("Lkw");
						for (int i = 0; i < arrayLkw.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayLkw.getItem(i), factory);
							getLkw().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayBus = daten.getArray("Bus");
						for (int i = 0; i < arrayBus.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayBus.getItem(i), factory);
							getBus().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayLkwK = daten.getArray("LkwK");
						for (int i = 0; i < arrayLkwK.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayLkwK.getItem(i), factory);
							getLkwK().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayLkwA = daten.getArray("LkwA");
						for (int i = 0; i < arrayLkwA.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arrayLkwA.getItem(i), factory);
							getLkwA().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arraySattelKfz = daten.getArray("SattelKfz");
						for (int i = 0; i < arraySattelKfz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenFahrzeugAnzahl
							 ();
							atl.atl2Bean(arraySattelKfz.getItem(i), factory);
							getSattelKfz().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._kfz = getKfz().clone();
						klon._pkwAe = getPkwAe().clone();
						klon._lkwAe = getLkwAe().clone();
						klon._kfzNk = getKfzNk().clone();
						klon._pkwG = getPkwG().clone();
						klon._pkw = getPkw().clone();
						klon._krad = getKrad().clone();
						klon._lfw = getLfw().clone();
						klon._pkwA = getPkwA().clone();
						klon._lkw = getLkw().clone();
						klon._bus = getBus().clone();
						klon._lkwK = getLkwK().clone();
						klon._lkwA = getLkwA().clone();
						klon._sattelKfz = getSattelKfz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.langZeitDatenVK130";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdLangZeitDatenVK130(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
