/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Plausibilitätsprüfung Formal der Verkehrsdaten (Langzeit) mit Intervallwerten (nicht normiert auf Stundenwerte).
<p>
Die Parameter legen fest, wie im Falle von Bereichunterschreitungen bzw. Überschreitungen vorzugehen ist und wie die jeweiligen zulässigen Wertebereiche aussehen. Da die Anzahl der Geschwindigkeitsklassen variabel ist und das zugrundeliegende Geschwindigkeitsraster erst zur Laufzeit bekannt ist, gilt der Parameter für alle vorgefundenen Feldelemente.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungFormal extends AbstractParameterDatensatz<PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungFormal.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttOptionenPlausibilitaetsPruefungFormal
				 _optionen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKfzNkBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwGBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKradBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLfwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qBusBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwKBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qSattelKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vPkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vKfzNkBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vPkwGBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vPkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vKradBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vLfwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vLkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vPkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vLkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vBusBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vLkwKBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vLkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _vSattelKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sPkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sKfzNkBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sPkwGBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sPkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sKradBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sLfwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sLkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sPkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sLkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sBusBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sLkwKBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sLkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _sSattelKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85KfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85PkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85KfzNkBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85PkwGBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85PkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85KradBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85LfwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85LkwAeBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85PkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85LkwBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85BusBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85LkwKBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85LkwABereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 _v85SattelKfzBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKfzGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwAeGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKfzNkGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwGGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qKradGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLfwGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwAeGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qPkwAGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qBusGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwKGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qLkwAGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 _qSattelKfzGeschwKlasseBereich
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Optionen für die Art und Weise der Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@return der Wert von Optionen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttOptionenPlausibilitaetsPruefungFormal
				 getOptionen() {
				return _optionen;
			}
		
			/**
			Optionen für die Art und Weise der Plausibilitätsprüfung.
			<p>
			
			</p>
			
			@param _optionen der neue Wert von Optionen.
			*/
			public void setOptionen(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttOptionenPlausibilitaetsPruefungFormal
			 _optionen) {
				this._optionen = _optionen;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKfzBereich() {
				return _qKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Kfz.
			<p>
			
			</p>
			
			@param _qKfzBereich der neue Wert von QKfzBereich.
			*/
			public void setQKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKfzBereich) {
				this._qKfzBereich = _qKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QPkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwAeBereich() {
				return _qPkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw ähnliche.
			<p>
			
			</p>
			
			@param _qPkwAeBereich der neue Wert von QPkwAeBereich.
			*/
			public void setQPkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwAeBereich) {
				this._qPkwAeBereich = _qPkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNkBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKfzNkBereich() {
				return _qKfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _qKfzNkBereich der neue Wert von QKfzNkBereich.
			*/
			public void setQKfzNkBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKfzNkBereich) {
				this._qKfzNkBereich = _qKfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von QPkwGBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwGBereich() {
				return _qPkwGBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _qPkwGBereich der neue Wert von QPkwGBereich.
			*/
			public void setQPkwGBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwGBereich) {
				this._qPkwGBereich = _qPkwGBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwBereich() {
				return _qPkwBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@param _qPkwBereich der neue Wert von QPkwBereich.
			*/
			public void setQPkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwBereich) {
				this._qPkwBereich = _qPkwBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@return der Wert von QKradBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKradBereich() {
				return _qKradBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@param _qKradBereich der neue Wert von QKradBereich.
			*/
			public void setQKradBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKradBereich) {
				this._qKradBereich = _qKradBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLfwBereich() {
				return _qLfwBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfwBereich der neue Wert von QLfwBereich.
			*/
			public void setQLfwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLfwBereich) {
				this._qLfwBereich = _qLfwBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QLkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwAeBereich() {
				return _qLkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw ähnliche.
			<p>
			
			</p>
			
			@param _qLkwAeBereich der neue Wert von QLkwAeBereich.
			*/
			public void setQLkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwAeBereich) {
				this._qLkwAeBereich = _qLkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwABereich() {
				return _qPkwABereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qPkwABereich der neue Wert von QPkwABereich.
			*/
			public void setQPkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwABereich) {
				this._qPkwABereich = _qPkwABereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwBereich() {
				return _qLkwBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@param _qLkwBereich der neue Wert von QLkwBereich.
			*/
			public void setQLkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwBereich) {
				this._qLkwBereich = _qLkwBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@return der Wert von QBusBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQBusBereich() {
				return _qBusBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@param _qBusBereich der neue Wert von QBusBereich.
			*/
			public void setQBusBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qBusBereich) {
				this._qBusBereich = _qBusBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QLkwKBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwKBereich() {
				return _qLkwKBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qLkwKBereich der neue Wert von QLkwKBereich.
			*/
			public void setQLkwKBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwKBereich) {
				this._qLkwKBereich = _qLkwKBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwABereich() {
				return _qLkwABereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qLkwABereich der neue Wert von QLkwABereich.
			*/
			public void setQLkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwABereich) {
				this._qLkwABereich = _qLkwABereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQSattelKfzBereich() {
				return _qSattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qSattelKfzBereich der neue Wert von QSattelKfzBereich.
			*/
			public void setQSattelKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qSattelKfzBereich) {
				this._qSattelKfzBereich = _qSattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVKfzBereich() {
				return _vKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _vKfzBereich der neue Wert von VKfzBereich.
			*/
			public void setVKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vKfzBereich) {
				this._vKfzBereich = _vKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von VPkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVPkwAeBereich() {
				return _vPkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _vPkwAeBereich der neue Wert von VPkwAeBereich.
			*/
			public void setVPkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vPkwAeBereich) {
				this._vPkwAeBereich = _vPkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von VKfzNkBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVKfzNkBereich() {
				return _vKfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _vKfzNkBereich der neue Wert von VKfzNkBereich.
			*/
			public void setVKfzNkBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vKfzNkBereich) {
				this._vKfzNkBereich = _vKfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von VPkwGBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVPkwGBereich() {
				return _vPkwGBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _vPkwGBereich der neue Wert von VPkwGBereich.
			*/
			public void setVPkwGBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vPkwGBereich) {
				this._vPkwGBereich = _vPkwGBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVPkwBereich() {
				return _vPkwBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _vPkwBereich der neue Wert von VPkwBereich.
			*/
			public void setVPkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vPkwBereich) {
				this._vPkwBereich = _vPkwBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von VKradBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVKradBereich() {
				return _vKradBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _vKradBereich der neue Wert von VKradBereich.
			*/
			public void setVKradBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vKradBereich) {
				this._vKradBereich = _vKradBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von VLfwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVLfwBereich() {
				return _vLfwBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _vLfwBereich der neue Wert von VLfwBereich.
			*/
			public void setVLfwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vLfwBereich) {
				this._vLfwBereich = _vLfwBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von VLkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVLkwAeBereich() {
				return _vLkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _vLkwAeBereich der neue Wert von VLkwAeBereich.
			*/
			public void setVLkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vLkwAeBereich) {
				this._vLkwAeBereich = _vLkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VPkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVPkwABereich() {
				return _vPkwABereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vPkwABereich der neue Wert von VPkwABereich.
			*/
			public void setVPkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vPkwABereich) {
				this._vPkwABereich = _vPkwABereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVLkwBereich() {
				return _vLkwBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _vLkwBereich der neue Wert von VLkwBereich.
			*/
			public void setVLkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vLkwBereich) {
				this._vLkwBereich = _vLkwBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von VBusBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVBusBereich() {
				return _vBusBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _vBusBereich der neue Wert von VBusBereich.
			*/
			public void setVBusBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vBusBereich) {
				this._vBusBereich = _vBusBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von VLkwKBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVLkwKBereich() {
				return _vLkwKBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _vLkwKBereich der neue Wert von VLkwKBereich.
			*/
			public void setVLkwKBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vLkwKBereich) {
				this._vLkwKBereich = _vLkwKBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VLkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVLkwABereich() {
				return _vLkwABereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vLkwABereich der neue Wert von VLkwABereich.
			*/
			public void setVLkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vLkwABereich) {
				this._vLkwABereich = _vLkwABereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von VSattelKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getVSattelKfzBereich() {
				return _vSattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _vSattelKfzBereich der neue Wert von VSattelKfzBereich.
			*/
			public void setVSattelKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _vSattelKfzBereich) {
				this._vSattelKfzBereich = _vSattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von SKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSKfzBereich() {
				return _sKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _sKfzBereich der neue Wert von SKfzBereich.
			*/
			public void setSKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sKfzBereich) {
				this._sKfzBereich = _sKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von SPkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSPkwAeBereich() {
				return _sPkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _sPkwAeBereich der neue Wert von SPkwAeBereich.
			*/
			public void setSPkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sPkwAeBereich) {
				this._sPkwAeBereich = _sPkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von SKfzNkBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSKfzNkBereich() {
				return _sKfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _sKfzNkBereich der neue Wert von SKfzNkBereich.
			*/
			public void setSKfzNkBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sKfzNkBereich) {
				this._sKfzNkBereich = _sKfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von SPkwGBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSPkwGBereich() {
				return _sPkwGBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _sPkwGBereich der neue Wert von SPkwGBereich.
			*/
			public void setSPkwGBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sPkwGBereich) {
				this._sPkwGBereich = _sPkwGBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von SPkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSPkwBereich() {
				return _sPkwBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _sPkwBereich der neue Wert von SPkwBereich.
			*/
			public void setSPkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sPkwBereich) {
				this._sPkwBereich = _sPkwBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von SKradBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSKradBereich() {
				return _sKradBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _sKradBereich der neue Wert von SKradBereich.
			*/
			public void setSKradBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sKradBereich) {
				this._sKradBereich = _sKradBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von SLfwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSLfwBereich() {
				return _sLfwBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _sLfwBereich der neue Wert von SLfwBereich.
			*/
			public void setSLfwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sLfwBereich) {
				this._sLfwBereich = _sLfwBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von SLkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSLkwAeBereich() {
				return _sLkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _sLkwAeBereich der neue Wert von SLkwAeBereich.
			*/
			public void setSLkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sLkwAeBereich) {
				this._sLkwAeBereich = _sLkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SPkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSPkwABereich() {
				return _sPkwABereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _sPkwABereich der neue Wert von SPkwABereich.
			*/
			public void setSPkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sPkwABereich) {
				this._sPkwABereich = _sPkwABereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von SLkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSLkwBereich() {
				return _sLkwBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _sLkwBereich der neue Wert von SLkwBereich.
			*/
			public void setSLkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sLkwBereich) {
				this._sLkwBereich = _sLkwBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von SBusBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSBusBereich() {
				return _sBusBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _sBusBereich der neue Wert von SBusBereich.
			*/
			public void setSBusBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sBusBereich) {
				this._sBusBereich = _sBusBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von SLkwKBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSLkwKBereich() {
				return _sLkwKBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _sLkwKBereich der neue Wert von SLkwKBereich.
			*/
			public void setSLkwKBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sLkwKBereich) {
				this._sLkwKBereich = _sLkwKBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SLkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSLkwABereich() {
				return _sLkwABereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _sLkwABereich der neue Wert von SLkwABereich.
			*/
			public void setSLkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sLkwABereich) {
				this._sLkwABereich = _sLkwABereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von SSattelKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getSSattelKfzBereich() {
				return _sSattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Standardabweichung der Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _sSattelKfzBereich der neue Wert von SSattelKfzBereich.
			*/
			public void setSSattelKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _sSattelKfzBereich) {
				this._sSattelKfzBereich = _sSattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85KfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85KfzBereich() {
				return _v85KfzBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _v85KfzBereich der neue Wert von V85KfzBereich.
			*/
			public void setV85KfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85KfzBereich) {
				this._v85KfzBereich = _v85KfzBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von V85PkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85PkwAeBereich() {
				return _v85PkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _v85PkwAeBereich der neue Wert von V85PkwAeBereich.
			*/
			public void setV85PkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85PkwAeBereich) {
				this._v85PkwAeBereich = _v85PkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von V85KfzNkBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85KfzNkBereich() {
				return _v85KfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _v85KfzNkBereich der neue Wert von V85KfzNkBereich.
			*/
			public void setV85KfzNkBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85KfzNkBereich) {
				this._v85KfzNkBereich = _v85KfzNkBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von V85PkwGBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85PkwGBereich() {
				return _v85PkwGBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _v85PkwGBereich der neue Wert von V85PkwGBereich.
			*/
			public void setV85PkwGBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85PkwGBereich) {
				this._v85PkwGBereich = _v85PkwGBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von V85PkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85PkwBereich() {
				return _v85PkwBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _v85PkwBereich der neue Wert von V85PkwBereich.
			*/
			public void setV85PkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85PkwBereich) {
				this._v85PkwBereich = _v85PkwBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von V85KradBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85KradBereich() {
				return _v85KradBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _v85KradBereich der neue Wert von V85KradBereich.
			*/
			public void setV85KradBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85KradBereich) {
				this._v85KradBereich = _v85KradBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von V85LfwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85LfwBereich() {
				return _v85LfwBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _v85LfwBereich der neue Wert von V85LfwBereich.
			*/
			public void setV85LfwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85LfwBereich) {
				this._v85LfwBereich = _v85LfwBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von V85LkwAeBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85LkwAeBereich() {
				return _v85LkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _v85LkwAeBereich der neue Wert von V85LkwAeBereich.
			*/
			public void setV85LkwAeBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85LkwAeBereich) {
				this._v85LkwAeBereich = _v85LkwAeBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85PkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85PkwABereich() {
				return _v85PkwABereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85PkwABereich der neue Wert von V85PkwABereich.
			*/
			public void setV85PkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85PkwABereich) {
				this._v85PkwABereich = _v85PkwABereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von V85LkwBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85LkwBereich() {
				return _v85LkwBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _v85LkwBereich der neue Wert von V85LkwBereich.
			*/
			public void setV85LkwBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85LkwBereich) {
				this._v85LkwBereich = _v85LkwBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von V85BusBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85BusBereich() {
				return _v85BusBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _v85BusBereich der neue Wert von V85BusBereich.
			*/
			public void setV85BusBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85BusBereich) {
				this._v85BusBereich = _v85BusBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85LkwKBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85LkwKBereich() {
				return _v85LkwKBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _v85LkwKBereich der neue Wert von V85LkwKBereich.
			*/
			public void setV85LkwKBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85LkwKBereich) {
				this._v85LkwKBereich = _v85LkwKBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85LkwABereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85LkwABereich() {
				return _v85LkwABereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85LkwABereich der neue Wert von V85LkwABereich.
			*/
			public void setV85LkwABereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85LkwABereich) {
				this._v85LkwABereich = _v85LkwABereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85SattelKfzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
				 getV85SattelKfzBereich() {
				return _v85SattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die v85-Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _v85SattelKfzBereich der neue Wert von V85SattelKfzBereich.
			*/
			public void setV85SattelKfzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxGeschwindigkeit
			 _v85SattelKfzBereich) {
				this._v85SattelKfzBereich = _v85SattelKfzBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfzGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKfzGeschwKlasseBereich() {
				return _qKfzGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz.
			<p>
			
			</p>
			
			@param _qKfzGeschwKlasseBereich der neue Wert von QKfzGeschwKlasseBereich.
			*/
			public void setQKfzGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKfzGeschwKlasseBereich) {
				this._qKfzGeschwKlasseBereich = _qKfzGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QPkwAeGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwAeGeschwKlasseBereich() {
				return _qPkwAeGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw ähnliche.
			<p>
			
			</p>
			
			@param _qPkwAeGeschwKlasseBereich der neue Wert von QPkwAeGeschwKlasseBereich.
			*/
			public void setQPkwAeGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwAeGeschwKlasseBereich) {
				this._qPkwAeGeschwKlasseBereich = _qPkwAeGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNkGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKfzNkGeschwKlasseBereich() {
				return _qKfzNkGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _qKfzNkGeschwKlasseBereich der neue Wert von QKfzNkGeschwKlasseBereich.
			*/
			public void setQKfzNkGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKfzNkGeschwKlasseBereich) {
				this._qKfzNkGeschwKlasseBereich = _qKfzNkGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von QPkwGGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwGGeschwKlasseBereich() {
				return _qPkwGGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _qPkwGGeschwKlasseBereich der neue Wert von QPkwGGeschwKlasseBereich.
			*/
			public void setQPkwGGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwGGeschwKlasseBereich) {
				this._qPkwGGeschwKlasseBereich = _qPkwGGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkwGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwGeschwKlasseBereich() {
				return _qPkwGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw.
			<p>
			
			</p>
			
			@param _qPkwGeschwKlasseBereich der neue Wert von QPkwGeschwKlasseBereich.
			*/
			public void setQPkwGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwGeschwKlasseBereich) {
				this._qPkwGeschwKlasseBereich = _qPkwGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Krad.
			<p>
			
			</p>
			
			@return der Wert von QKradGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQKradGeschwKlasseBereich() {
				return _qKradGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Krad.
			<p>
			
			</p>
			
			@param _qKradGeschwKlasseBereich der neue Wert von QKradGeschwKlasseBereich.
			*/
			public void setQKradGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qKradGeschwKlasseBereich) {
				this._qKradGeschwKlasseBereich = _qKradGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfwGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLfwGeschwKlasseBereich() {
				return _qLfwGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfwGeschwKlasseBereich der neue Wert von QLfwGeschwKlasseBereich.
			*/
			public void setQLfwGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLfwGeschwKlasseBereich) {
				this._qLfwGeschwKlasseBereich = _qLfwGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QLkwAeGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwAeGeschwKlasseBereich() {
				return _qLkwAeGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw ähnliche.
			<p>
			
			</p>
			
			@param _qLkwAeGeschwKlasseBereich der neue Wert von QLkwAeGeschwKlasseBereich.
			*/
			public void setQLkwAeGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwAeGeschwKlasseBereich) {
				this._qLkwAeGeschwKlasseBereich = _qLkwAeGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwAGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQPkwAGeschwKlasseBereich() {
				return _qPkwAGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qPkwAGeschwKlasseBereich der neue Wert von QPkwAGeschwKlasseBereich.
			*/
			public void setQPkwAGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qPkwAGeschwKlasseBereich) {
				this._qPkwAGeschwKlasseBereich = _qPkwAGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkwGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwGeschwKlasseBereich() {
				return _qLkwGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw.
			<p>
			
			</p>
			
			@param _qLkwGeschwKlasseBereich der neue Wert von QLkwGeschwKlasseBereich.
			*/
			public void setQLkwGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwGeschwKlasseBereich) {
				this._qLkwGeschwKlasseBereich = _qLkwGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Busse.
			<p>
			
			</p>
			
			@return der Wert von QBusGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQBusGeschwKlasseBereich() {
				return _qBusGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Busse.
			<p>
			
			</p>
			
			@param _qBusGeschwKlasseBereich der neue Wert von QBusGeschwKlasseBereich.
			*/
			public void setQBusGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qBusGeschwKlasseBereich) {
				this._qBusGeschwKlasseBereich = _qBusGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QLkwKGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwKGeschwKlasseBereich() {
				return _qLkwKGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qLkwKGeschwKlasseBereich der neue Wert von QLkwKGeschwKlasseBereich.
			*/
			public void setQLkwKGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwKGeschwKlasseBereich) {
				this._qLkwKGeschwKlasseBereich = _qLkwKGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwAGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQLkwAGeschwKlasseBereich() {
				return _qLkwAGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qLkwAGeschwKlasseBereich der neue Wert von QLkwAGeschwKlasseBereich.
			*/
			public void setQLkwAGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qLkwAGeschwKlasseBereich) {
				this._qLkwAGeschwKlasseBereich = _qLkwAGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfzGeschwKlasseBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
				 getQSattelKfzGeschwKlasseBereich() {
				return _qSattelKfzGeschwKlasseBereich;
			}
		
			/**
			zulässiger Bereich für die Anzahl Fahrzeuge in Geschwindigkeitsklasse Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qSattelKfzGeschwKlasseBereich der neue Wert von QSattelKfzGeschwKlasseBereich.
			*/
			public void setQSattelKfzGeschwKlasseBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlMinMaxVerkehrsStaerkeStunde
			 _qSattelKfzGeschwKlasseBereich) {
				this._qSattelKfzGeschwKlasseBereich = _qSattelKfzGeschwKlasseBereich;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getOptionen() != null) {
		                if (getOptionen().isZustand()) {
		                    datum.getUnscaledValue("Optionen").setText(getOptionen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Optionen").set(getOptionen().getValue());
		                }
					}
					// AttributListenDefinition
						getQKfzBereich().bean2Atl(datum.getItem("qKfzBereich"), factory);
					// AttributListenDefinition
						getQPkwAeBereich().bean2Atl(datum.getItem("qPkwÄBereich"), factory);
					// AttributListenDefinition
						getQKfzNkBereich().bean2Atl(datum.getItem("qKfzNkBereich"), factory);
					// AttributListenDefinition
						getQPkwGBereich().bean2Atl(datum.getItem("qPkwGBereich"), factory);
					// AttributListenDefinition
						getQPkwBereich().bean2Atl(datum.getItem("qPkwBereich"), factory);
					// AttributListenDefinition
						getQKradBereich().bean2Atl(datum.getItem("qKradBereich"), factory);
					// AttributListenDefinition
						getQLfwBereich().bean2Atl(datum.getItem("qLfwBereich"), factory);
					// AttributListenDefinition
						getQLkwAeBereich().bean2Atl(datum.getItem("qLkwÄBereich"), factory);
					// AttributListenDefinition
						getQPkwABereich().bean2Atl(datum.getItem("qPkwABereich"), factory);
					// AttributListenDefinition
						getQLkwBereich().bean2Atl(datum.getItem("qLkwBereich"), factory);
					// AttributListenDefinition
						getQBusBereich().bean2Atl(datum.getItem("qBusBereich"), factory);
					// AttributListenDefinition
						getQLkwKBereich().bean2Atl(datum.getItem("qLkwKBereich"), factory);
					// AttributListenDefinition
						getQLkwABereich().bean2Atl(datum.getItem("qLkwABereich"), factory);
					// AttributListenDefinition
						getQSattelKfzBereich().bean2Atl(datum.getItem("qSattelKfzBereich"), factory);
					// AttributListenDefinition
						getVKfzBereich().bean2Atl(datum.getItem("vKfzBereich"), factory);
					// AttributListenDefinition
						getVPkwAeBereich().bean2Atl(datum.getItem("vPkwÄBereich"), factory);
					// AttributListenDefinition
						getVKfzNkBereich().bean2Atl(datum.getItem("vKfzNkBereich"), factory);
					// AttributListenDefinition
						getVPkwGBereich().bean2Atl(datum.getItem("vPkwGBereich"), factory);
					// AttributListenDefinition
						getVPkwBereich().bean2Atl(datum.getItem("vPkwBereich"), factory);
					// AttributListenDefinition
						getVKradBereich().bean2Atl(datum.getItem("vKradBereich"), factory);
					// AttributListenDefinition
						getVLfwBereich().bean2Atl(datum.getItem("vLfwBereich"), factory);
					// AttributListenDefinition
						getVLkwAeBereich().bean2Atl(datum.getItem("vLkwÄBereich"), factory);
					// AttributListenDefinition
						getVPkwABereich().bean2Atl(datum.getItem("vPkwABereich"), factory);
					// AttributListenDefinition
						getVLkwBereich().bean2Atl(datum.getItem("vLkwBereich"), factory);
					// AttributListenDefinition
						getVBusBereich().bean2Atl(datum.getItem("vBusBereich"), factory);
					// AttributListenDefinition
						getVLkwKBereich().bean2Atl(datum.getItem("vLkwKBereich"), factory);
					// AttributListenDefinition
						getVLkwABereich().bean2Atl(datum.getItem("vLkwABereich"), factory);
					// AttributListenDefinition
						getVSattelKfzBereich().bean2Atl(datum.getItem("vSattelKfzBereich"), factory);
					// AttributListenDefinition
						getSKfzBereich().bean2Atl(datum.getItem("sKfzBereich"), factory);
					// AttributListenDefinition
						getSPkwAeBereich().bean2Atl(datum.getItem("sPkwÄBereich"), factory);
					// AttributListenDefinition
						getSKfzNkBereich().bean2Atl(datum.getItem("sKfzNkBereich"), factory);
					// AttributListenDefinition
						getSPkwGBereich().bean2Atl(datum.getItem("sPkwGBereich"), factory);
					// AttributListenDefinition
						getSPkwBereich().bean2Atl(datum.getItem("sPkwBereich"), factory);
					// AttributListenDefinition
						getSKradBereich().bean2Atl(datum.getItem("sKradBereich"), factory);
					// AttributListenDefinition
						getSLfwBereich().bean2Atl(datum.getItem("sLfwBereich"), factory);
					// AttributListenDefinition
						getSLkwAeBereich().bean2Atl(datum.getItem("sLkwÄBereich"), factory);
					// AttributListenDefinition
						getSPkwABereich().bean2Atl(datum.getItem("sPkwABereich"), factory);
					// AttributListenDefinition
						getSLkwBereich().bean2Atl(datum.getItem("sLkwBereich"), factory);
					// AttributListenDefinition
						getSBusBereich().bean2Atl(datum.getItem("sBusBereich"), factory);
					// AttributListenDefinition
						getSLkwKBereich().bean2Atl(datum.getItem("sLkwKBereich"), factory);
					// AttributListenDefinition
						getSLkwABereich().bean2Atl(datum.getItem("sLkwABereich"), factory);
					// AttributListenDefinition
						getSSattelKfzBereich().bean2Atl(datum.getItem("sSattelKfzBereich"), factory);
					// AttributListenDefinition
						getV85KfzBereich().bean2Atl(datum.getItem("v85KfzBereich"), factory);
					// AttributListenDefinition
						getV85PkwAeBereich().bean2Atl(datum.getItem("v85PkwÄBereich"), factory);
					// AttributListenDefinition
						getV85KfzNkBereich().bean2Atl(datum.getItem("v85KfzNkBereich"), factory);
					// AttributListenDefinition
						getV85PkwGBereich().bean2Atl(datum.getItem("v85PkwGBereich"), factory);
					// AttributListenDefinition
						getV85PkwBereich().bean2Atl(datum.getItem("v85PkwBereich"), factory);
					// AttributListenDefinition
						getV85KradBereich().bean2Atl(datum.getItem("v85KradBereich"), factory);
					// AttributListenDefinition
						getV85LfwBereich().bean2Atl(datum.getItem("v85LfwBereich"), factory);
					// AttributListenDefinition
						getV85LkwAeBereich().bean2Atl(datum.getItem("v85LkwÄBereich"), factory);
					// AttributListenDefinition
						getV85PkwABereich().bean2Atl(datum.getItem("v85PkwABereich"), factory);
					// AttributListenDefinition
						getV85LkwBereich().bean2Atl(datum.getItem("v85LkwBereich"), factory);
					// AttributListenDefinition
						getV85BusBereich().bean2Atl(datum.getItem("v85BusBereich"), factory);
					// AttributListenDefinition
						getV85LkwKBereich().bean2Atl(datum.getItem("v85LkwKBereich"), factory);
					// AttributListenDefinition
						getV85LkwABereich().bean2Atl(datum.getItem("v85LkwABereich"), factory);
					// AttributListenDefinition
						getV85SattelKfzBereich().bean2Atl(datum.getItem("v85SattelKfzBereich"), factory);
					// AttributListenDefinition
						getQKfzGeschwKlasseBereich().bean2Atl(datum.getItem("qKfzGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwAeGeschwKlasseBereich().bean2Atl(datum.getItem("qPkwÄGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQKfzNkGeschwKlasseBereich().bean2Atl(datum.getItem("qKfzNkGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwGGeschwKlasseBereich().bean2Atl(datum.getItem("qPkwGGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwGeschwKlasseBereich().bean2Atl(datum.getItem("qPkwGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQKradGeschwKlasseBereich().bean2Atl(datum.getItem("qKradGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLfwGeschwKlasseBereich().bean2Atl(datum.getItem("qLfwGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwAeGeschwKlasseBereich().bean2Atl(datum.getItem("qLkwÄGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwAGeschwKlasseBereich().bean2Atl(datum.getItem("qPkwAGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwGeschwKlasseBereich().bean2Atl(datum.getItem("qLkwGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQBusGeschwKlasseBereich().bean2Atl(datum.getItem("qBusGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwKGeschwKlasseBereich().bean2Atl(datum.getItem("qLkwKGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwAGeschwKlasseBereich().bean2Atl(datum.getItem("qLkwAGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQSattelKfzGeschwKlasseBereich().bean2Atl(datum.getItem("qSattelKfzGeschwKlasseBereich"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Optionen").isState()) {
								setOptionen(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttOptionenPlausibilitaetsPruefungFormal
								.getZustand(daten.getScaledValue("Optionen").getText()));
							} else {
							setOptionen(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttOptionenPlausibilitaetsPruefungFormal
							(daten.
								getUnscaledValue
							("Optionen").
									byteValue
							()));
							}
					// AttributListenDefinition
						getQKfzBereich().atl2Bean(daten.getItem("qKfzBereich"), factory);
					// AttributListenDefinition
						getQPkwAeBereich().atl2Bean(daten.getItem("qPkwÄBereich"), factory);
					// AttributListenDefinition
						getQKfzNkBereich().atl2Bean(daten.getItem("qKfzNkBereich"), factory);
					// AttributListenDefinition
						getQPkwGBereich().atl2Bean(daten.getItem("qPkwGBereich"), factory);
					// AttributListenDefinition
						getQPkwBereich().atl2Bean(daten.getItem("qPkwBereich"), factory);
					// AttributListenDefinition
						getQKradBereich().atl2Bean(daten.getItem("qKradBereich"), factory);
					// AttributListenDefinition
						getQLfwBereich().atl2Bean(daten.getItem("qLfwBereich"), factory);
					// AttributListenDefinition
						getQLkwAeBereich().atl2Bean(daten.getItem("qLkwÄBereich"), factory);
					// AttributListenDefinition
						getQPkwABereich().atl2Bean(daten.getItem("qPkwABereich"), factory);
					// AttributListenDefinition
						getQLkwBereich().atl2Bean(daten.getItem("qLkwBereich"), factory);
					// AttributListenDefinition
						getQBusBereich().atl2Bean(daten.getItem("qBusBereich"), factory);
					// AttributListenDefinition
						getQLkwKBereich().atl2Bean(daten.getItem("qLkwKBereich"), factory);
					// AttributListenDefinition
						getQLkwABereich().atl2Bean(daten.getItem("qLkwABereich"), factory);
					// AttributListenDefinition
						getQSattelKfzBereich().atl2Bean(daten.getItem("qSattelKfzBereich"), factory);
					// AttributListenDefinition
						getVKfzBereich().atl2Bean(daten.getItem("vKfzBereich"), factory);
					// AttributListenDefinition
						getVPkwAeBereich().atl2Bean(daten.getItem("vPkwÄBereich"), factory);
					// AttributListenDefinition
						getVKfzNkBereich().atl2Bean(daten.getItem("vKfzNkBereich"), factory);
					// AttributListenDefinition
						getVPkwGBereich().atl2Bean(daten.getItem("vPkwGBereich"), factory);
					// AttributListenDefinition
						getVPkwBereich().atl2Bean(daten.getItem("vPkwBereich"), factory);
					// AttributListenDefinition
						getVKradBereich().atl2Bean(daten.getItem("vKradBereich"), factory);
					// AttributListenDefinition
						getVLfwBereich().atl2Bean(daten.getItem("vLfwBereich"), factory);
					// AttributListenDefinition
						getVLkwAeBereich().atl2Bean(daten.getItem("vLkwÄBereich"), factory);
					// AttributListenDefinition
						getVPkwABereich().atl2Bean(daten.getItem("vPkwABereich"), factory);
					// AttributListenDefinition
						getVLkwBereich().atl2Bean(daten.getItem("vLkwBereich"), factory);
					// AttributListenDefinition
						getVBusBereich().atl2Bean(daten.getItem("vBusBereich"), factory);
					// AttributListenDefinition
						getVLkwKBereich().atl2Bean(daten.getItem("vLkwKBereich"), factory);
					// AttributListenDefinition
						getVLkwABereich().atl2Bean(daten.getItem("vLkwABereich"), factory);
					// AttributListenDefinition
						getVSattelKfzBereich().atl2Bean(daten.getItem("vSattelKfzBereich"), factory);
					// AttributListenDefinition
						getSKfzBereich().atl2Bean(daten.getItem("sKfzBereich"), factory);
					// AttributListenDefinition
						getSPkwAeBereich().atl2Bean(daten.getItem("sPkwÄBereich"), factory);
					// AttributListenDefinition
						getSKfzNkBereich().atl2Bean(daten.getItem("sKfzNkBereich"), factory);
					// AttributListenDefinition
						getSPkwGBereich().atl2Bean(daten.getItem("sPkwGBereich"), factory);
					// AttributListenDefinition
						getSPkwBereich().atl2Bean(daten.getItem("sPkwBereich"), factory);
					// AttributListenDefinition
						getSKradBereich().atl2Bean(daten.getItem("sKradBereich"), factory);
					// AttributListenDefinition
						getSLfwBereich().atl2Bean(daten.getItem("sLfwBereich"), factory);
					// AttributListenDefinition
						getSLkwAeBereich().atl2Bean(daten.getItem("sLkwÄBereich"), factory);
					// AttributListenDefinition
						getSPkwABereich().atl2Bean(daten.getItem("sPkwABereich"), factory);
					// AttributListenDefinition
						getSLkwBereich().atl2Bean(daten.getItem("sLkwBereich"), factory);
					// AttributListenDefinition
						getSBusBereich().atl2Bean(daten.getItem("sBusBereich"), factory);
					// AttributListenDefinition
						getSLkwKBereich().atl2Bean(daten.getItem("sLkwKBereich"), factory);
					// AttributListenDefinition
						getSLkwABereich().atl2Bean(daten.getItem("sLkwABereich"), factory);
					// AttributListenDefinition
						getSSattelKfzBereich().atl2Bean(daten.getItem("sSattelKfzBereich"), factory);
					// AttributListenDefinition
						getV85KfzBereich().atl2Bean(daten.getItem("v85KfzBereich"), factory);
					// AttributListenDefinition
						getV85PkwAeBereich().atl2Bean(daten.getItem("v85PkwÄBereich"), factory);
					// AttributListenDefinition
						getV85KfzNkBereich().atl2Bean(daten.getItem("v85KfzNkBereich"), factory);
					// AttributListenDefinition
						getV85PkwGBereich().atl2Bean(daten.getItem("v85PkwGBereich"), factory);
					// AttributListenDefinition
						getV85PkwBereich().atl2Bean(daten.getItem("v85PkwBereich"), factory);
					// AttributListenDefinition
						getV85KradBereich().atl2Bean(daten.getItem("v85KradBereich"), factory);
					// AttributListenDefinition
						getV85LfwBereich().atl2Bean(daten.getItem("v85LfwBereich"), factory);
					// AttributListenDefinition
						getV85LkwAeBereich().atl2Bean(daten.getItem("v85LkwÄBereich"), factory);
					// AttributListenDefinition
						getV85PkwABereich().atl2Bean(daten.getItem("v85PkwABereich"), factory);
					// AttributListenDefinition
						getV85LkwBereich().atl2Bean(daten.getItem("v85LkwBereich"), factory);
					// AttributListenDefinition
						getV85BusBereich().atl2Bean(daten.getItem("v85BusBereich"), factory);
					// AttributListenDefinition
						getV85LkwKBereich().atl2Bean(daten.getItem("v85LkwKBereich"), factory);
					// AttributListenDefinition
						getV85LkwABereich().atl2Bean(daten.getItem("v85LkwABereich"), factory);
					// AttributListenDefinition
						getV85SattelKfzBereich().atl2Bean(daten.getItem("v85SattelKfzBereich"), factory);
					// AttributListenDefinition
						getQKfzGeschwKlasseBereich().atl2Bean(daten.getItem("qKfzGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwAeGeschwKlasseBereich().atl2Bean(daten.getItem("qPkwÄGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQKfzNkGeschwKlasseBereich().atl2Bean(daten.getItem("qKfzNkGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwGGeschwKlasseBereich().atl2Bean(daten.getItem("qPkwGGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwGeschwKlasseBereich().atl2Bean(daten.getItem("qPkwGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQKradGeschwKlasseBereich().atl2Bean(daten.getItem("qKradGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLfwGeschwKlasseBereich().atl2Bean(daten.getItem("qLfwGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwAeGeschwKlasseBereich().atl2Bean(daten.getItem("qLkwÄGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQPkwAGeschwKlasseBereich().atl2Bean(daten.getItem("qPkwAGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwGeschwKlasseBereich().atl2Bean(daten.getItem("qLkwGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQBusGeschwKlasseBereich().atl2Bean(daten.getItem("qBusGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwKGeschwKlasseBereich().atl2Bean(daten.getItem("qLkwKGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQLkwAGeschwKlasseBereich().atl2Bean(daten.getItem("qLkwAGeschwKlasseBereich"), factory);
					// AttributListenDefinition
						getQSattelKfzGeschwKlasseBereich().atl2Bean(daten.getItem("qSattelKfzGeschwKlasseBereich"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setOptionen(getOptionen());
							klon._qKfzBereich = getQKfzBereich().clone();
							klon._qPkwAeBereich = getQPkwAeBereich().clone();
							klon._qKfzNkBereich = getQKfzNkBereich().clone();
							klon._qPkwGBereich = getQPkwGBereich().clone();
							klon._qPkwBereich = getQPkwBereich().clone();
							klon._qKradBereich = getQKradBereich().clone();
							klon._qLfwBereich = getQLfwBereich().clone();
							klon._qLkwAeBereich = getQLkwAeBereich().clone();
							klon._qPkwABereich = getQPkwABereich().clone();
							klon._qLkwBereich = getQLkwBereich().clone();
							klon._qBusBereich = getQBusBereich().clone();
							klon._qLkwKBereich = getQLkwKBereich().clone();
							klon._qLkwABereich = getQLkwABereich().clone();
							klon._qSattelKfzBereich = getQSattelKfzBereich().clone();
							klon._vKfzBereich = getVKfzBereich().clone();
							klon._vPkwAeBereich = getVPkwAeBereich().clone();
							klon._vKfzNkBereich = getVKfzNkBereich().clone();
							klon._vPkwGBereich = getVPkwGBereich().clone();
							klon._vPkwBereich = getVPkwBereich().clone();
							klon._vKradBereich = getVKradBereich().clone();
							klon._vLfwBereich = getVLfwBereich().clone();
							klon._vLkwAeBereich = getVLkwAeBereich().clone();
							klon._vPkwABereich = getVPkwABereich().clone();
							klon._vLkwBereich = getVLkwBereich().clone();
							klon._vBusBereich = getVBusBereich().clone();
							klon._vLkwKBereich = getVLkwKBereich().clone();
							klon._vLkwABereich = getVLkwABereich().clone();
							klon._vSattelKfzBereich = getVSattelKfzBereich().clone();
							klon._sKfzBereich = getSKfzBereich().clone();
							klon._sPkwAeBereich = getSPkwAeBereich().clone();
							klon._sKfzNkBereich = getSKfzNkBereich().clone();
							klon._sPkwGBereich = getSPkwGBereich().clone();
							klon._sPkwBereich = getSPkwBereich().clone();
							klon._sKradBereich = getSKradBereich().clone();
							klon._sLfwBereich = getSLfwBereich().clone();
							klon._sLkwAeBereich = getSLkwAeBereich().clone();
							klon._sPkwABereich = getSPkwABereich().clone();
							klon._sLkwBereich = getSLkwBereich().clone();
							klon._sBusBereich = getSBusBereich().clone();
							klon._sLkwKBereich = getSLkwKBereich().clone();
							klon._sLkwABereich = getSLkwABereich().clone();
							klon._sSattelKfzBereich = getSSattelKfzBereich().clone();
							klon._v85KfzBereich = getV85KfzBereich().clone();
							klon._v85PkwAeBereich = getV85PkwAeBereich().clone();
							klon._v85KfzNkBereich = getV85KfzNkBereich().clone();
							klon._v85PkwGBereich = getV85PkwGBereich().clone();
							klon._v85PkwBereich = getV85PkwBereich().clone();
							klon._v85KradBereich = getV85KradBereich().clone();
							klon._v85LfwBereich = getV85LfwBereich().clone();
							klon._v85LkwAeBereich = getV85LkwAeBereich().clone();
							klon._v85PkwABereich = getV85PkwABereich().clone();
							klon._v85LkwBereich = getV85LkwBereich().clone();
							klon._v85BusBereich = getV85BusBereich().clone();
							klon._v85LkwKBereich = getV85LkwKBereich().clone();
							klon._v85LkwABereich = getV85LkwABereich().clone();
							klon._v85SattelKfzBereich = getV85SattelKfzBereich().clone();
							klon._qKfzGeschwKlasseBereich = getQKfzGeschwKlasseBereich().clone();
							klon._qPkwAeGeschwKlasseBereich = getQPkwAeGeschwKlasseBereich().clone();
							klon._qKfzNkGeschwKlasseBereich = getQKfzNkGeschwKlasseBereich().clone();
							klon._qPkwGGeschwKlasseBereich = getQPkwGGeschwKlasseBereich().clone();
							klon._qPkwGeschwKlasseBereich = getQPkwGeschwKlasseBereich().clone();
							klon._qKradGeschwKlasseBereich = getQKradGeschwKlasseBereich().clone();
							klon._qLfwGeschwKlasseBereich = getQLfwGeschwKlasseBereich().clone();
							klon._qLkwAeGeschwKlasseBereich = getQLkwAeGeschwKlasseBereich().clone();
							klon._qPkwAGeschwKlasseBereich = getQPkwAGeschwKlasseBereich().clone();
							klon._qLkwGeschwKlasseBereich = getQLkwGeschwKlasseBereich().clone();
							klon._qBusGeschwKlasseBereich = getQBusGeschwKlasseBereich().clone();
							klon._qLkwKGeschwKlasseBereich = getQLkwKGeschwKlasseBereich().clone();
							klon._qLkwAGeschwKlasseBereich = getQLkwAGeschwKlasseBereich().clone();
							klon._qSattelKfzGeschwKlasseBereich = getQSattelKfzGeschwKlasseBereich().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenLangZeitIntervallPlausibilitätsPrüfungFormal";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungFormal(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
