/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition Attributliste nbaBedingungFundamental.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von Ereignis Referenzen
						und Umfeldbedingung Referenzen.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaBedingungFundamental implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
			 _ereignisReferenz
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
			 _umfeldReferenz
			;
	
		/**
		Referenz auf ein Ereignis.
		<p>
		
		</p>
		
		@return der Wert von EreignisReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
			 getEreignisReferenz() {
			return _ereignisReferenz;
		}
	
		/**
		Referenz auf ein Ereignis.
		<p>
		
		</p>
		
		@param _ereignisReferenz der neue Wert von EreignisReferenz.
		*/
		public void setEreignisReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
		 _ereignisReferenz) {
			this._ereignisReferenz = _ereignisReferenz;
		}
	
		/**
		Referenz auf eine Umfeldbedingung.
		<p>
		
		</p>
		
		@return der Wert von UmfeldReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
			 getUmfeldReferenz() {
			return _umfeldReferenz;
		}
	
		/**
		Referenz auf eine Umfeldbedingung.
		<p>
		
		</p>
		
		@param _umfeldReferenz der neue Wert von UmfeldReferenz.
		*/
		public void setUmfeldReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
		 _umfeldReferenz) {
			this._umfeldReferenz = _umfeldReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEreignisReferenz = getEreignisReferenz();
					final SystemObject tmpEreignisReferenz;
						if (soEreignisReferenz instanceof SystemObject) {
							tmpEreignisReferenz = (SystemObject)soEreignisReferenz;
						} else if(soEreignisReferenz instanceof SystemObjekt){
							tmpEreignisReferenz = ((SystemObjekt)soEreignisReferenz).getSystemObject();
						} else{
							tmpEreignisReferenz = null;
						}
					datum.getReferenceValue("EreignisReferenz").setSystemObject(tmpEreignisReferenz);
				// ObjektReferenzAttributTyp
					final Object soUmfeldReferenz = getUmfeldReferenz();
					final SystemObject tmpUmfeldReferenz;
						if (soUmfeldReferenz instanceof SystemObject) {
							tmpUmfeldReferenz = (SystemObject)soUmfeldReferenz;
						} else if(soUmfeldReferenz instanceof SystemObjekt){
							tmpUmfeldReferenz = ((SystemObjekt)soUmfeldReferenz).getSystemObject();
						} else{
							tmpUmfeldReferenz = null;
						}
					datum.getReferenceValue("UmfeldReferenz").setSystemObject(tmpUmfeldReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEreignisReferenz = daten.getReferenceValue("EreignisReferenz").getId();
					final SystemObjekt tmpEreignisReferenz;
					if (idEreignisReferenz == 0) {
						tmpEreignisReferenz = null;
					} else {
						final SystemObject soEreignisReferenz = factory.getDav().getDataModel().getObject(idEreignisReferenz);
						if (soEreignisReferenz == null) {
								tmpEreignisReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisUngueltig(idEreignisReferenz);
						} else {
							tmpEreignisReferenz = factory.getModellobjekt(soEreignisReferenz);
						}
					}
					setEreignisReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
					) tmpEreignisReferenz);
				// ObjektReferenzAttributTyp
					final long idUmfeldReferenz = daten.getReferenceValue("UmfeldReferenz").getId();
					final SystemObjekt tmpUmfeldReferenz;
					if (idUmfeldReferenz == 0) {
						tmpUmfeldReferenz = null;
					} else {
						final SystemObject soUmfeldReferenz = factory.getDav().getDataModel().getObject(idUmfeldReferenz);
						if (soUmfeldReferenz == null) {
								tmpUmfeldReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaObjektUmfeldbedingungUngueltig(idUmfeldReferenz);
						} else {
							tmpUmfeldReferenz = factory.getModellobjekt(soUmfeldReferenz);
						}
					}
					setUmfeldReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
					) tmpUmfeldReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaBedingungFundamental clone() {
		AtlNbaBedingungFundamental klon = new AtlNbaBedingungFundamental();
		
						klon.setEreignisReferenz(getEreignisReferenz());
						klon.setUmfeldReferenz(getUmfeldReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
