/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Festlegungen für Betriebsmeldungen für ein Ziel für die NBA.
<p>
&lt;absatz&gt;
						Festlegungen für Betriebsmeldungen für ein Ziel für die NBA.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktBetriebsmeldungZiel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 _zielReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _betriebsmeldungAbsetzen
			;
			private String
			 _meldungsTypZusatz
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _warntonInOberflaeche
			;
	
		/**
		Ziel für die Betriebsmeldung.
		<p>
		
		</p>
		
		@return der Wert von ZielReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 getZielReferenz() {
			return _zielReferenz;
		}
	
		/**
		Ziel für die Betriebsmeldung.
		<p>
		
		</p>
		
		@param _zielReferenz der neue Wert von ZielReferenz.
		*/
		public void setZielReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
		 _zielReferenz) {
			this._zielReferenz = _zielReferenz;
		}
	
		/**
		Schalter, ob eine Betriebsmeldung bei einer FahrtRichtungs-Änderung abgesetzt werden soll.
		<p>
		
		</p>
		
		@return der Wert von BetriebsmeldungAbsetzen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBetriebsmeldungAbsetzen() {
			return _betriebsmeldungAbsetzen;
		}
	
		/**
		Schalter, ob eine Betriebsmeldung bei einer FahrtRichtungs-Änderung abgesetzt werden soll.
		<p>
		
		</p>
		
		@param _betriebsmeldungAbsetzen der neue Wert von BetriebsmeldungAbsetzen.
		*/
		public void setBetriebsmeldungAbsetzen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _betriebsmeldungAbsetzen) {
			this._betriebsmeldungAbsetzen = _betriebsmeldungAbsetzen;
		}
	
		/**
		Text der im MeldungsTypZusatz der Betriebsmeldung eingetragen werden soll.
		<p>
		
		</p>
		
		@return der Wert von MeldungsTypZusatz.
		*/
			public String
			 getMeldungsTypZusatz() {
			return _meldungsTypZusatz;
		}
	
		/**
		Text der im MeldungsTypZusatz der Betriebsmeldung eingetragen werden soll.
		<p>
		
		</p>
		
		@param _meldungsTypZusatz der neue Wert von MeldungsTypZusatz.
		*/
		public void setMeldungsTypZusatz(String
		 _meldungsTypZusatz) {
			if (_meldungsTypZusatz.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._meldungsTypZusatz = _meldungsTypZusatz;
		}
	
		/**
		Schalter, ob auf die Betriebsmeldung in der Oberfläche durch einen Warnton aufmerksam gemacht werden soll.
		<p>
		&lt;absatz&gt;
									Schalter, ob auf die Betriebsmeldung in der Oberfläche durch einen Warnton aufmerksam gemacht werden soll.
									Bei 'nein' wird die Betriebsmeldung mit der MeldungsKlasse 'Information' versendet und bei 'ja' mit der MeldungsKlasse 'Warnung'.
									In der Oberfläche muß dann bei MeldungsKlasse 'Warnung' ein Warnton ausgelöst werden.
								&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von WarntonInOberflaeche.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getWarntonInOberflaeche() {
			return _warntonInOberflaeche;
		}
	
		/**
		Schalter, ob auf die Betriebsmeldung in der Oberfläche durch einen Warnton aufmerksam gemacht werden soll.
		<p>
		&lt;absatz&gt;
									Schalter, ob auf die Betriebsmeldung in der Oberfläche durch einen Warnton aufmerksam gemacht werden soll.
									Bei 'nein' wird die Betriebsmeldung mit der MeldungsKlasse 'Information' versendet und bei 'ja' mit der MeldungsKlasse 'Warnung'.
									In der Oberfläche muß dann bei MeldungsKlasse 'Warnung' ein Warnton ausgelöst werden.
								&lt;&#47;absatz&gt;
		</p>
		
		@param _warntonInOberflaeche der neue Wert von WarntonInOberflaeche.
		*/
		public void setWarntonInOberflaeche(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _warntonInOberflaeche) {
			this._warntonInOberflaeche = _warntonInOberflaeche;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soZielReferenz = getZielReferenz();
					final SystemObject tmpZielReferenz;
						if (soZielReferenz instanceof SystemObject) {
							tmpZielReferenz = (SystemObject)soZielReferenz;
						} else if(soZielReferenz instanceof SystemObjekt){
							tmpZielReferenz = ((SystemObjekt)soZielReferenz).getSystemObject();
						} else{
							tmpZielReferenz = null;
						}
					datum.getReferenceValue("ZielReferenz").setSystemObject(tmpZielReferenz);
				// GanzzahlAttributTyp
				if (getBetriebsmeldungAbsetzen() != null) {
	                if (getBetriebsmeldungAbsetzen().isZustand()) {
	                    datum.getUnscaledValue("BetriebsmeldungAbsetzen").setText(getBetriebsmeldungAbsetzen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("BetriebsmeldungAbsetzen").set(getBetriebsmeldungAbsetzen().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getMeldungsTypZusatz() != null) {
					datum.getTextValue("MeldungsTypZusatz").setText(getMeldungsTypZusatz());
				}
				// GanzzahlAttributTyp
				if (getWarntonInOberflaeche() != null) {
	                if (getWarntonInOberflaeche().isZustand()) {
	                    datum.getUnscaledValue("WarntonInOberfläche").setText(getWarntonInOberflaeche().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WarntonInOberfläche").set(getWarntonInOberflaeche().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idZielReferenz = daten.getReferenceValue("ZielReferenz").getId();
					final SystemObjekt tmpZielReferenz;
					if (idZielReferenz == 0) {
						tmpZielReferenz = null;
					} else {
						final SystemObject soZielReferenz = factory.getDav().getDataModel().getObject(idZielReferenz);
						if (soZielReferenz == null) {
								tmpZielReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaZielUngueltig(idZielReferenz);
						} else {
							tmpZielReferenz = factory.getModellobjekt(soZielReferenz);
						}
					}
					setZielReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
					) tmpZielReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BetriebsmeldungAbsetzen").isState()) {
							setBetriebsmeldungAbsetzen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("BetriebsmeldungAbsetzen").getText()));
						} else {
						setBetriebsmeldungAbsetzen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("BetriebsmeldungAbsetzen").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setMeldungsTypZusatz(daten.getTextValue("MeldungsTypZusatz").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("WarntonInOberfläche").isState()) {
							setWarntonInOberflaeche(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("WarntonInOberfläche").getText()));
						} else {
						setWarntonInOberflaeche(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("WarntonInOberfläche").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktBetriebsmeldungZiel clone() {
		AtlNbaEntscheidungspunktBetriebsmeldungZiel klon = new AtlNbaEntscheidungspunktBetriebsmeldungZiel();
		
						klon.setZielReferenz(getZielReferenz());
						klon.setBetriebsmeldungAbsetzen(getBetriebsmeldungAbsetzen());
						klon.setMeldungsTypZusatz(getMeldungsTypZusatz());
						klon.setWarntonInOberflaeche(getWarntonInOberflaeche());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
