/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ReisezeitAlgorithmus für die angegebene FahrtRichtung für die NBA.
<p>
&lt;absatz&gt;
						ReisezeitAlgorithmus für die angegebene FahrtRichtung für die NBA.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 29
 */
public class AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
			 _algorithmusAktiveTeilroute
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
			 _algorithmusPassiveTeilroute
			;
	
		/**
		Gibt die FahrtRichtung für den ReisezeitAlgorithmus an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für den ReisezeitAlgorithmus an.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
		/**
		Algorithmus für die aktive Teilroute für die angegebene FahrtRichtung.
		<p>
		
		</p>
		
		@return der Wert von AlgorithmusAktiveTeilroute.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
			 getAlgorithmusAktiveTeilroute() {
			return _algorithmusAktiveTeilroute;
		}
	
		/**
		Algorithmus für die aktive Teilroute für die angegebene FahrtRichtung.
		<p>
		
		</p>
		
		@param _algorithmusAktiveTeilroute der neue Wert von AlgorithmusAktiveTeilroute.
		*/
		public void setAlgorithmusAktiveTeilroute(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
		 _algorithmusAktiveTeilroute) {
			this._algorithmusAktiveTeilroute = _algorithmusAktiveTeilroute;
		}
	
		/**
		Algorithmus für die passive Teilroute die angegebene FahrtRichtung.
		<p>
		
		</p>
		
		@return der Wert von AlgorithmusPassiveTeilroute.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
			 getAlgorithmusPassiveTeilroute() {
			return _algorithmusPassiveTeilroute;
		}
	
		/**
		Algorithmus für die passive Teilroute die angegebene FahrtRichtung.
		<p>
		
		</p>
		
		@param _algorithmusPassiveTeilroute der neue Wert von AlgorithmusPassiveTeilroute.
		*/
		public void setAlgorithmusPassiveTeilroute(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
		 _algorithmusPassiveTeilroute) {
			this._algorithmusPassiveTeilroute = _algorithmusPassiveTeilroute;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAlgorithmusAktiveTeilroute() != null) {
	                if (getAlgorithmusAktiveTeilroute().isZustand()) {
	                    datum.getUnscaledValue("AlgorithmusAktiveTeilroute").setText(getAlgorithmusAktiveTeilroute().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AlgorithmusAktiveTeilroute").set(getAlgorithmusAktiveTeilroute().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAlgorithmusPassiveTeilroute() != null) {
	                if (getAlgorithmusPassiveTeilroute().isZustand()) {
	                    datum.getUnscaledValue("AlgorithmusPassiveTeilroute").setText(getAlgorithmusPassiveTeilroute().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AlgorithmusPassiveTeilroute").set(getAlgorithmusPassiveTeilroute().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AlgorithmusAktiveTeilroute").isState()) {
							setAlgorithmusAktiveTeilroute(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
							.getZustand(daten.getScaledValue("AlgorithmusAktiveTeilroute").getText()));
						} else {
						setAlgorithmusAktiveTeilroute(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
						(daten.
							getUnscaledValue
						("AlgorithmusAktiveTeilroute").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AlgorithmusPassiveTeilroute").isState()) {
							setAlgorithmusPassiveTeilroute(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
							.getZustand(daten.getScaledValue("AlgorithmusPassiveTeilroute").getText()));
						} else {
						setAlgorithmusPassiveTeilroute(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaReisezeitAlgorithmus
						(daten.
							getUnscaledValue
						("AlgorithmusPassiveTeilroute").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung clone() {
		AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung klon = new AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung();
		
						klon.setFahrtRichtung(getFahrtRichtung());
						klon.setAlgorithmusAktiveTeilroute(getAlgorithmusAktiveTeilroute());
						klon.setAlgorithmusPassiveTeilroute(getAlgorithmusPassiveTeilroute());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
