/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ReisezeitAlgorithmus für alle FahrtRichtungen des angegebenen Ziels für die NBA.
<p>
&lt;absatz&gt;
						ReisezeitAlgorithmus für alle FahrtRichtungen des angegebenen Ziels für die NBA.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 29
 */
public class AtlNbaEntscheidungspunktReisezeitAlgorithmusZiel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 _zielReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung
			> _reisezeitAlgorithmusFuerFahrtRichtungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung
			>(0, true);
	
		/**
		Ziel für die ReisezeitAlgorithmus.
		<p>
		
		</p>
		
		@return der Wert von ZielReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 getZielReferenz() {
			return _zielReferenz;
		}
	
		/**
		Ziel für die ReisezeitAlgorithmus.
		<p>
		
		</p>
		
		@param _zielReferenz der neue Wert von ZielReferenz.
		*/
		public void setZielReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
		 _zielReferenz) {
			this._zielReferenz = _zielReferenz;
		}
	
		/**
		ReisezeitAlgorithmus für alle FahrtRichtungen des Ziels.
		<p>
		
		</p>
		
		@return der Wert von ReisezeitAlgorithmusFuerFahrtRichtungen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung
			> getReisezeitAlgorithmusFuerFahrtRichtungen() {
			return _reisezeitAlgorithmusFuerFahrtRichtungen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soZielReferenz = getZielReferenz();
					final SystemObject tmpZielReferenz;
						if (soZielReferenz instanceof SystemObject) {
							tmpZielReferenz = (SystemObject)soZielReferenz;
						} else if(soZielReferenz instanceof SystemObjekt){
							tmpZielReferenz = ((SystemObjekt)soZielReferenz).getSystemObject();
						} else{
							tmpZielReferenz = null;
						}
					datum.getReferenceValue("ZielReferenz").setSystemObject(tmpZielReferenz);
				// AttributListenDefinition
					final Data.Array arrayReisezeitAlgorithmusFuerFahrtRichtungen = datum.getArray("ReisezeitAlgorithmusFürFahrtRichtungen");
					arrayReisezeitAlgorithmusFuerFahrtRichtungen.setLength(getReisezeitAlgorithmusFuerFahrtRichtungen().size());
					for (int i = 0; i < arrayReisezeitAlgorithmusFuerFahrtRichtungen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung
						 atl = getReisezeitAlgorithmusFuerFahrtRichtungen().get(i);
						atl.bean2Atl(arrayReisezeitAlgorithmusFuerFahrtRichtungen.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idZielReferenz = daten.getReferenceValue("ZielReferenz").getId();
					final SystemObjekt tmpZielReferenz;
					if (idZielReferenz == 0) {
						tmpZielReferenz = null;
					} else {
						final SystemObject soZielReferenz = factory.getDav().getDataModel().getObject(idZielReferenz);
						if (soZielReferenz == null) {
								tmpZielReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaZielUngueltig(idZielReferenz);
						} else {
							tmpZielReferenz = factory.getModellobjekt(soZielReferenz);
						}
					}
					setZielReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
					) tmpZielReferenz);
				// AttributListenDefinition
					final Data.Array arrayReisezeitAlgorithmusFuerFahrtRichtungen = daten.getArray("ReisezeitAlgorithmusFürFahrtRichtungen");
					for (int i = 0; i < arrayReisezeitAlgorithmusFuerFahrtRichtungen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitAlgorithmusFahrtRichtung
						 ();
						atl.atl2Bean(arrayReisezeitAlgorithmusFuerFahrtRichtungen.getItem(i), factory);
						getReisezeitAlgorithmusFuerFahrtRichtungen().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktReisezeitAlgorithmusZiel clone() {
		AtlNbaEntscheidungspunktReisezeitAlgorithmusZiel klon = new AtlNbaEntscheidungspunktReisezeitAlgorithmusZiel();
		
						klon.setZielReferenz(getZielReferenz());
					klon._reisezeitAlgorithmusFuerFahrtRichtungen = getReisezeitAlgorithmusFuerFahrtRichtungen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
