/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Schaltbild für eine Ziel-FahrtRichtungs-Kombination am Entscheidungspunkt.
<p>
&lt;absatz&gt;
						Schaltbild für eine Ziel-FahrtRichtungs-Kombination am Entscheidungspunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 36
 */
public class AtlNbaEntscheidungspunktSchaltbild implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _prioritaet
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZielMitFahrtRichtung
			> _zielMitFahrtRichtung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZielMitFahrtRichtung
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
			> _schaltbilder = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
			> _schaltbilderHinweis = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
			>(0, true);
	
		/**
		Priorität der Liste mit Zielen mit FahrtRichtungen (höhere Zahl entspricht höherer Priorität).
		<p>
		
		</p>
		
		@return der Wert von Prioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 getPrioritaet() {
			return _prioritaet;
		}
	
		/**
		Priorität der Liste mit Zielen mit FahrtRichtungen (höhere Zahl entspricht höherer Priorität).
		<p>
		
		</p>
		
		@param _prioritaet der neue Wert von Prioritaet.
		*/
		public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
		 _prioritaet) {
			this._prioritaet = _prioritaet;
		}
	
		/**
		Liste mit Ziel-FahrtRichtungs-Kombinationen.
		<p>
		Liste mit Ziel-FahrtRichtungs-Kombinationen. Alle angegebenen Ziel-FahrtRichtungs-Kombinationen müssen erfüllt sein,
								damit die angegebenen Schaltbilder für die Schaltbilderzeugung verwendet werden.
		</p>
		
		@return der Wert von ZielMitFahrtRichtung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZielMitFahrtRichtung
			> getZielMitFahrtRichtung() {
			return _zielMitFahrtRichtung;
		}
	
	
		/**
		Schaltbilder für alle zu beeinflussenden Anzeigen.
		<p>
		
		</p>
		
		@return der Wert von Schaltbilder.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
			> getSchaltbilder() {
			return _schaltbilder;
		}
	
	
		/**
		Schaltbilder-Hinweis für alle zu beeinflussenden Anzeigen.
		<p>
		&lt;absatz&gt;
				  				Wenn das Schaltbild (Umleitungsempfehlung) angezeigt wird, aber kein Hinweis auf die zu Grunde liegende
		              Störung (Tafel der anderen Fahrtrichtung dunkel), dann wird der hier versorgte Anzeigeinhalt als Default-Hinweis
		              angezeigt.
					   		&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von SchaltbilderHinweis.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
			> getSchaltbilderHinweis() {
			return _schaltbilderHinweis;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getPrioritaet() != null) {
	                if (getPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Priorität").setText(getPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Priorität").set(getPrioritaet().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayZielMitFahrtRichtung = datum.getArray("ZielMitFahrtRichtung");
					arrayZielMitFahrtRichtung.setLength(getZielMitFahrtRichtung().size());
					for (int i = 0; i < arrayZielMitFahrtRichtung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZielMitFahrtRichtung
						 atl = getZielMitFahrtRichtung().get(i);
						atl.bean2Atl(arrayZielMitFahrtRichtung.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arraySchaltbilder = datum.getArray("Schaltbilder");
					arraySchaltbilder.setLength(getSchaltbilder().size());
					for (int i = 0; i < arraySchaltbilder.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
						 atl = getSchaltbilder().get(i);
						atl.bean2Atl(arraySchaltbilder.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arraySchaltbilderHinweis = datum.getArray("SchaltbilderHinweis");
					arraySchaltbilderHinweis.setLength(getSchaltbilderHinweis().size());
					for (int i = 0; i < arraySchaltbilderHinweis.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
						 atl = getSchaltbilderHinweis().get(i);
						atl.bean2Atl(arraySchaltbilderHinweis.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Priorität").isState()) {
							setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							.getZustand(daten.getScaledValue("Priorität").getText()));
						} else {
						setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
						(daten.
							getUnscaledValue
						("Priorität").
								intValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayZielMitFahrtRichtung = daten.getArray("ZielMitFahrtRichtung");
					for (int i = 0; i < arrayZielMitFahrtRichtung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZielMitFahrtRichtung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZielMitFahrtRichtung
						 ();
						atl.atl2Bean(arrayZielMitFahrtRichtung.getItem(i), factory);
						getZielMitFahrtRichtung().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arraySchaltbilder = daten.getArray("Schaltbilder");
					for (int i = 0; i < arraySchaltbilder.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
						 ();
						atl.atl2Bean(arraySchaltbilder.getItem(i), factory);
						getSchaltbilder().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arraySchaltbilderHinweis = daten.getArray("SchaltbilderHinweis");
					for (int i = 0; i < arraySchaltbilderHinweis.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktSchaltbildAnzeige
						 ();
						atl.atl2Bean(arraySchaltbilderHinweis.getItem(i), factory);
						getSchaltbilderHinweis().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktSchaltbild clone() {
		AtlNbaEntscheidungspunktSchaltbild klon = new AtlNbaEntscheidungspunktSchaltbild();
		
						klon.setPrioritaet(getPrioritaet());
					klon._zielMitFahrtRichtung = getZielMitFahrtRichtung().clone();
					klon._schaltbilder = getSchaltbilder().clone();
					klon._schaltbilderHinweis = getSchaltbilderHinweis().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
