/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anzeige mit der Zuordnung zur FahrtRichtung und Bedeutung der Anzeige für Hinweise.
<p>
&lt;absatz&gt;
						Anzeige mit der Zuordnung zur FahrtRichtung und Bedeutung der Anzeige für Hinweise.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 _anzeige
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtungErweitert
			 _fahrtRichtungen
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
			 _anzeigenBedeutung
			;
	
		/**
		Anzeige für die Schaltbildvorgabe.
		<p>
		Anzeige für die die Informationen gelten.
		</p>
		
		@return der Wert von Anzeige.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 getAnzeige() {
			return _anzeige;
		}
	
		/**
		Anzeige für die Schaltbildvorgabe.
		<p>
		Anzeige für die die Informationen gelten.
		</p>
		
		@param _anzeige der neue Wert von Anzeige.
		*/
		public void setAnzeige(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
		 _anzeige) {
			this._anzeige = _anzeige;
		}
	
		/**
		Gibt die FahrtRichtungen an, für die die Anzeige zuständig ist.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtungErweitert
			 getFahrtRichtungen() {
			return _fahrtRichtungen;
		}
	
		/**
		Gibt die FahrtRichtungen an, für die die Anzeige zuständig ist.
		<p>
		
		</p>
		
		@param _fahrtRichtungen der neue Wert von FahrtRichtungen.
		*/
		public void setFahrtRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtungErweitert
		 _fahrtRichtungen) {
			this._fahrtRichtungen = _fahrtRichtungen;
		}
	
		/**
		Gibt die Bedeutung der Anzeige für die Beschaltung mit Hinweisen an.
		<p>
		
		</p>
		
		@return der Wert von AnzeigenBedeutung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
			 getAnzeigenBedeutung() {
			return _anzeigenBedeutung;
		}
	
		/**
		Gibt die Bedeutung der Anzeige für die Beschaltung mit Hinweisen an.
		<p>
		
		</p>
		
		@param _anzeigenBedeutung der neue Wert von AnzeigenBedeutung.
		*/
		public void setAnzeigenBedeutung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
		 _anzeigenBedeutung) {
			this._anzeigenBedeutung = _anzeigenBedeutung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeige = getAnzeige();
					final SystemObject tmpAnzeige;
						if (soAnzeige instanceof SystemObject) {
							tmpAnzeige = (SystemObject)soAnzeige;
						} else if(soAnzeige instanceof SystemObjekt){
							tmpAnzeige = ((SystemObjekt)soAnzeige).getSystemObject();
						} else{
							tmpAnzeige = null;
						}
					datum.getReferenceValue("Anzeige").setSystemObject(tmpAnzeige);
				// GanzzahlAttributTyp
				if (getFahrtRichtungen() != null) {
	                if (getFahrtRichtungen().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtungen").setText(getFahrtRichtungen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtungen").set(getFahrtRichtungen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnzeigenBedeutung() != null) {
	                if (getAnzeigenBedeutung().isZustand()) {
	                    datum.getUnscaledValue("AnzeigenBedeutung").setText(getAnzeigenBedeutung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzeigenBedeutung").set(getAnzeigenBedeutung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeige = daten.getReferenceValue("Anzeige").getId();
					final SystemObjekt tmpAnzeige;
					if (idAnzeige == 0) {
						tmpAnzeige = null;
					} else {
						final SystemObject soAnzeige = factory.getDav().getDataModel().getObject(idAnzeige);
						if (soAnzeige == null) {
								tmpAnzeige = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeige);
						} else {
							tmpAnzeige = factory.getModellobjekt(soAnzeige);
						}
					}
					setAnzeige((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
					) tmpAnzeige);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtungen").isState()) {
							setFahrtRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtungErweitert
							.getZustand(daten.getScaledValue("FahrtRichtungen").getText()));
						} else {
						setFahrtRichtungen(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtungErweitert
						(daten.
							getUnscaledValue
						("FahrtRichtungen").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AnzeigenBedeutung").isState()) {
							setAnzeigenBedeutung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
							.getZustand(daten.getScaledValue("AnzeigenBedeutung").getText()));
						} else {
						setAnzeigenBedeutung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
						(daten.
							getUnscaledValue
						("AnzeigenBedeutung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen clone() {
		AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen klon = new AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen();
		
						klon.setAnzeige(getAnzeige());
						klon.setFahrtRichtungen(getFahrtRichtungen());
						klon.setAnzeigenBedeutung(getAnzeigenBedeutung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
