/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
FahrtRichtungen für die die Anzeige zuständig ist und Bedeutung der Anzeige für Hinweise.
<p>
&lt;absatz&gt;
						FahrtRichtungen für die die Anzeige zuständig ist und Bedeutung der Anzeige für Hinweise.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAq implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
			 _anzeigeQuerschnitt
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen
			> _anzeigen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen
			>(0, true);
	
		/**
		Anzeige für die Schaltbildvorgabe.
		<p>
		Anzeige für die die Informationen gelten.
		</p>
		
		@return der Wert von AnzeigeQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
			 getAnzeigeQuerschnitt() {
			return _anzeigeQuerschnitt;
		}
	
		/**
		Anzeige für die Schaltbildvorgabe.
		<p>
		Anzeige für die die Informationen gelten.
		</p>
		
		@param _anzeigeQuerschnitt der neue Wert von AnzeigeQuerschnitt.
		*/
		public void setAnzeigeQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
		 _anzeigeQuerschnitt) {
			this._anzeigeQuerschnitt = _anzeigeQuerschnitt;
		}
	
		/**
		Anzeigen die zum AnzeigeQuerschnitt gehören mit FahrtRichtungen und Bedeutung der Anzeigen für Hinweise.
		<p>
		Anzeigen die zum AnzeigeQuerschnitt gehören mit FahrtRichtungen und Bedeutung der Anzeigen für Hinweise.
		</p>
		
		@return der Wert von Anzeigen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen
			> getAnzeigen() {
			return _anzeigen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeigeQuerschnitt = getAnzeigeQuerschnitt();
					final SystemObject tmpAnzeigeQuerschnitt;
						if (soAnzeigeQuerschnitt instanceof SystemObject) {
							tmpAnzeigeQuerschnitt = (SystemObject)soAnzeigeQuerschnitt;
						} else if(soAnzeigeQuerschnitt instanceof SystemObjekt){
							tmpAnzeigeQuerschnitt = ((SystemObjekt)soAnzeigeQuerschnitt).getSystemObject();
						} else{
							tmpAnzeigeQuerschnitt = null;
						}
					datum.getReferenceValue("AnzeigeQuerschnitt").setSystemObject(tmpAnzeigeQuerschnitt);
				// AttributListenDefinition
					final Data.Array arrayAnzeigen = datum.getArray("Anzeigen");
					arrayAnzeigen.setLength(getAnzeigen().size());
					for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen
						 atl = getAnzeigen().get(i);
						atl.bean2Atl(arrayAnzeigen.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeigeQuerschnitt = daten.getReferenceValue("AnzeigeQuerschnitt").getId();
					final SystemObjekt tmpAnzeigeQuerschnitt;
					if (idAnzeigeQuerschnitt == 0) {
						tmpAnzeigeQuerschnitt = null;
					} else {
						final SystemObject soAnzeigeQuerschnitt = factory.getDav().getDataModel().getObject(idAnzeigeQuerschnitt);
						if (soAnzeigeQuerschnitt == null) {
								tmpAnzeigeQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idAnzeigeQuerschnitt);
						} else {
							tmpAnzeigeQuerschnitt = factory.getModellobjekt(soAnzeigeQuerschnitt);
						}
					}
					setAnzeigeQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
					) tmpAnzeigeQuerschnitt);
				// AttributListenDefinition
					final Data.Array arrayAnzeigen = daten.getArray("Anzeigen");
					for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAnzeigen
						 ();
						atl.atl2Bean(arrayAnzeigen.getItem(i), factory);
						getAnzeigen().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAq clone() {
		AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAq klon = new AtlNbaEntscheidungspunktZuordnungAnzeigenZuFahrtRichtungAq();
		
						klon.setAnzeigeQuerschnitt(getAnzeigeQuerschnitt());
					klon._anzeigen = getAnzeigen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
