/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition des Fundamentaldiagramm.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von Attributen
						für das nbaFundamentaldiagramm.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlNbaFundamentaldiagramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 _ereignisTyp
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
			 _umfeldbedingung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _standard
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFundamentalDefault
			 _default_JavaKeyword
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaStuetzstelleFundamentaldiagramm
			> _stuetzstelle = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaStuetzstelleFundamentaldiagramm
			>(0, true);
	
		/**
		Referenz auf ein EreignisTyp.
		<p>
		
		</p>
		
		@return der Wert von EreignisTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 getEreignisTyp() {
			return _ereignisTyp;
		}
	
		/**
		Referenz auf ein EreignisTyp.
		<p>
		
		</p>
		
		@param _ereignisTyp der neue Wert von EreignisTyp.
		*/
		public void setEreignisTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
		 _ereignisTyp) {
			this._ereignisTyp = _ereignisTyp;
		}
	
		/**
		Referenz auf eine Umfeldbedingung.
		<p>
		
		</p>
		
		@return der Wert von Umfeldbedingung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
			 getUmfeldbedingung() {
			return _umfeldbedingung;
		}
	
		/**
		Referenz auf eine Umfeldbedingung.
		<p>
		
		</p>
		
		@param _umfeldbedingung der neue Wert von Umfeldbedingung.
		*/
		public void setUmfeldbedingung(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
		 _umfeldbedingung) {
			this._umfeldbedingung = _umfeldbedingung;
		}
	
		/**
		Das Fundamentaldiagramm ist als Standardversorgung gekennzeichnet.
		<p>
		
		</p>
		
		@return der Wert von Standard.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getStandard() {
			return _standard;
		}
	
		/**
		Das Fundamentaldiagramm ist als Standardversorgung gekennzeichnet.
		<p>
		
		</p>
		
		@param _standard der neue Wert von Standard.
		*/
		public void setStandard(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _standard) {
			this._standard = _standard;
		}
	
		/**
		Das Fundamentaldiagramm ist als Standardversorgung gekennzeichnet.
		<p>
		
		</p>
		
		@return der Wert von Default_JavaKeyword.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFundamentalDefault
			 getDefault_JavaKeyword() {
			return _default_JavaKeyword;
		}
	
		/**
		Das Fundamentaldiagramm ist als Standardversorgung gekennzeichnet.
		<p>
		
		</p>
		
		@param _default_JavaKeyword der neue Wert von Default_JavaKeyword.
		*/
		public void setDefault_JavaKeyword(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFundamentalDefault
		 _default_JavaKeyword) {
			this._default_JavaKeyword = _default_JavaKeyword;
		}
	
		/**
		Definition einer Stützstelle Fundamentaldiagramm.
		<p>
		
		</p>
		
		@return der Wert von Stuetzstelle.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaStuetzstelleFundamentaldiagramm
			> getStuetzstelle() {
			return _stuetzstelle;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEreignisTyp = getEreignisTyp();
					final SystemObject tmpEreignisTyp;
						if (soEreignisTyp instanceof SystemObject) {
							tmpEreignisTyp = (SystemObject)soEreignisTyp;
						} else if(soEreignisTyp instanceof SystemObjekt){
							tmpEreignisTyp = ((SystemObjekt)soEreignisTyp).getSystemObject();
						} else{
							tmpEreignisTyp = null;
						}
					datum.getReferenceValue("EreignisTyp").setSystemObject(tmpEreignisTyp);
				// ObjektReferenzAttributTyp
					final Object soUmfeldbedingung = getUmfeldbedingung();
					final SystemObject tmpUmfeldbedingung;
						if (soUmfeldbedingung instanceof SystemObject) {
							tmpUmfeldbedingung = (SystemObject)soUmfeldbedingung;
						} else if(soUmfeldbedingung instanceof SystemObjekt){
							tmpUmfeldbedingung = ((SystemObjekt)soUmfeldbedingung).getSystemObject();
						} else{
							tmpUmfeldbedingung = null;
						}
					datum.getReferenceValue("Umfeldbedingung").setSystemObject(tmpUmfeldbedingung);
				// GanzzahlAttributTyp
				if (getStandard() != null) {
	                if (getStandard().isZustand()) {
	                    datum.getUnscaledValue("Standard").setText(getStandard().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Standard").set(getStandard().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDefault_JavaKeyword() != null) {
	                if (getDefault_JavaKeyword().isZustand()) {
	                    datum.getUnscaledValue("Default").setText(getDefault_JavaKeyword().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Default").set(getDefault_JavaKeyword().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayStuetzstelle = datum.getArray("Stützstelle");
					arrayStuetzstelle.setLength(getStuetzstelle().size());
					for (int i = 0; i < arrayStuetzstelle.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaStuetzstelleFundamentaldiagramm
						 atl = getStuetzstelle().get(i);
						atl.bean2Atl(arrayStuetzstelle.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEreignisTyp = daten.getReferenceValue("EreignisTyp").getId();
					final SystemObjekt tmpEreignisTyp;
					if (idEreignisTyp == 0) {
						tmpEreignisTyp = null;
					} else {
						final SystemObject soEreignisTyp = factory.getDav().getDataModel().getObject(idEreignisTyp);
						if (soEreignisTyp == null) {
								tmpEreignisTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTyp);
						} else {
							tmpEreignisTyp = factory.getModellobjekt(soEreignisTyp);
						}
					}
					setEreignisTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
					) tmpEreignisTyp);
				// ObjektReferenzAttributTyp
					final long idUmfeldbedingung = daten.getReferenceValue("Umfeldbedingung").getId();
					final SystemObjekt tmpUmfeldbedingung;
					if (idUmfeldbedingung == 0) {
						tmpUmfeldbedingung = null;
					} else {
						final SystemObject soUmfeldbedingung = factory.getDav().getDataModel().getObject(idUmfeldbedingung);
						if (soUmfeldbedingung == null) {
								tmpUmfeldbedingung = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaObjektUmfeldbedingungUngueltig(idUmfeldbedingung);
						} else {
							tmpUmfeldbedingung = factory.getModellobjekt(soUmfeldbedingung);
						}
					}
					setUmfeldbedingung((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaObjektUmfeldbedingung
					) tmpUmfeldbedingung);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Standard").isState()) {
							setStandard(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Standard").getText()));
						} else {
						setStandard(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Standard").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Default").isState()) {
							setDefault_JavaKeyword(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFundamentalDefault
							.getZustand(daten.getScaledValue("Default").getText()));
						} else {
						setDefault_JavaKeyword(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFundamentalDefault
						(daten.
							getUnscaledValue
						("Default").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayStuetzstelle = daten.getArray("Stützstelle");
					for (int i = 0; i < arrayStuetzstelle.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaStuetzstelleFundamentaldiagramm
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaStuetzstelleFundamentaldiagramm
						 ();
						atl.atl2Bean(arrayStuetzstelle.getItem(i), factory);
						getStuetzstelle().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaFundamentaldiagramm clone() {
		AtlNbaFundamentaldiagramm klon = new AtlNbaFundamentaldiagramm();
		
						klon.setEreignisTyp(getEreignisTyp());
						klon.setUmfeldbedingung(getUmfeldbedingung());
						klon.setStandard(getStandard());
						klon.setDefault_JavaKeyword(getDefault_JavaKeyword());
					klon._stuetzstelle = getStuetzstelle().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
