/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Alternative Bezeichungen für Location (richtungsabhängig) zur Anzeige der Anschlussstelle mit den Templates der Netzweiten Steuerung.
<p>
Für die angegebene Location, mit der Möglichkeit der Angabe einer Richtung, können mehrere alternative Bezeichungen versorgt werden.
          Die im Array versorgten alternativen Bezeichungen werden in der Reihenfolge, in der sie im Array vorliegen abgearbeitet. D. h. die
          alternative Bezeichnung mit dem Index 0 hat die höchste Priorität für die Verwendung zur Anzeige.
          Somit können unterschiedliche alternativen Bezeichungen für unterschiedlich lange Wechseltextanzeigen zum Einsatz gebracht werden.
          Beim ersten Einsatz wird nur die TmcRichtung "ohne Richtung" verwendet.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 34
 */
public class AtlNbaLocationAlternativeBezeichnung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
			 _tmcLocationCode
			;
			@Defaultwert(wert = "ohne Richtung")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
			 _tmcRichtung
			;
			private Feld<String
			> _alternativeBezeichnung = new Feld<String
			>(0, true);
	
		/**
		TmcLocationCode für den in der angegebenen TmcRichtung die alternativen Bezeichungen gelten.
		<p>
		
		</p>
		
		@return der Wert von TmcLocationCode.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
			 getTmcLocationCode() {
			return _tmcLocationCode;
		}
	
		/**
		TmcLocationCode für den in der angegebenen TmcRichtung die alternativen Bezeichungen gelten.
		<p>
		
		</p>
		
		@param _tmcLocationCode der neue Wert von TmcLocationCode.
		*/
		public void setTmcLocationCode(	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
		 _tmcLocationCode) {
			this._tmcLocationCode = _tmcLocationCode;
		}
	
		/**
		TmcRichtung für die die alternativen Bezeichungen gelten. "ohne Richtung" für Verwendung der alternativen Bezeichungen in beide Richtungen.
		<p>
		
		</p>
		
		@return der Wert von TmcRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
			 getTmcRichtung() {
			return _tmcRichtung;
		}
	
		/**
		TmcRichtung für die die alternativen Bezeichungen gelten. "ohne Richtung" für Verwendung der alternativen Bezeichungen in beide Richtungen.
		<p>
		
		</p>
		
		@param _tmcRichtung der neue Wert von TmcRichtung.
		*/
		public void setTmcRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
		 _tmcRichtung) {
			this._tmcRichtung = _tmcRichtung;
		}
	
		/**
		Alternative Bezeichungen zur Anzeige der Anschlussstelle mit den Templates der Netzweiten Steuerung.
		<p>
		
		</p>
		
		@return der Wert von AlternativeBezeichnung.
		*/
			public Feld<String
			> getAlternativeBezeichnung() {
			return _alternativeBezeichnung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soTmcLocationCode = getTmcLocationCode();
					final SystemObject tmpTmcLocationCode;
						if (soTmcLocationCode instanceof SystemObject) {
							tmpTmcLocationCode = (SystemObject)soTmcLocationCode;
						} else if(soTmcLocationCode instanceof SystemObjekt){
							tmpTmcLocationCode = ((SystemObjekt)soTmcLocationCode).getSystemObject();
						} else{
							tmpTmcLocationCode = null;
						}
					datum.getReferenceValue("TmcLocationCode").setSystemObject(tmpTmcLocationCode);
				// GanzzahlAttributTyp
				if (getTmcRichtung() != null) {
	                if (getTmcRichtung().isZustand()) {
	                    datum.getUnscaledValue("TmcRichtung").setText(getTmcRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TmcRichtung").set(getTmcRichtung().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getAlternativeBezeichnung() != null) {
					final Data.TextArray arrayAlternativeBezeichnung = datum.getTextArray("AlternativeBezeichnung");
					arrayAlternativeBezeichnung.setLength(getAlternativeBezeichnung().size());
					for (int i = 0; i < arrayAlternativeBezeichnung.getLength(); ++i) {
						arrayAlternativeBezeichnung.getTextValue(i).setText(getAlternativeBezeichnung().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idTmcLocationCode = daten.getReferenceValue("TmcLocationCode").getId();
					final SystemObjekt tmpTmcLocationCode;
					if (idTmcLocationCode == 0) {
						tmpTmcLocationCode = null;
					} else {
						final SystemObject soTmcLocationCode = factory.getDav().getDataModel().getObject(idTmcLocationCode);
						if (soTmcLocationCode == null) {
								tmpTmcLocationCode = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.impl.TmcPunktUngueltig(idTmcLocationCode);
						} else {
							tmpTmcLocationCode = factory.getModellobjekt(soTmcLocationCode);
						}
					}
					setTmcLocationCode((	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
					) tmpTmcLocationCode);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TmcRichtung").isState()) {
							setTmcRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
							.getZustand(daten.getScaledValue("TmcRichtung").getText()));
						} else {
						setTmcRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
						(daten.
							getUnscaledValue
						("TmcRichtung").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayAlternativeBezeichnung = daten.getTextArray("AlternativeBezeichnung");
					for (int i = 0; i < arrayAlternativeBezeichnung.getLength(); ++i) {
						getAlternativeBezeichnung().add(arrayAlternativeBezeichnung.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaLocationAlternativeBezeichnung clone() {
		AtlNbaLocationAlternativeBezeichnung klon = new AtlNbaLocationAlternativeBezeichnung();
		
						klon.setTmcLocationCode(getTmcLocationCode());
						klon.setTmcRichtung(getTmcRichtung());
					klon._alternativeBezeichnung = getAlternativeBezeichnung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
