/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der Parameter Standardganglinie pro Ereignistyp.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von Attributen
						für Parameter pro Ereignistyp.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaParameterTyp implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 _ereignisTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttGlaettung
			 _glaettung
			;
	
		/**
		Referenz auf ein EreignisTyp.
		<p>
		
		</p>
		
		@return der Wert von EreignisTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
			 getEreignisTyp() {
			return _ereignisTyp;
		}
	
		/**
		Referenz auf ein EreignisTyp.
		<p>
		
		</p>
		
		@param _ereignisTyp der neue Wert von EreignisTyp.
		*/
		public void setEreignisTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
		 _ereignisTyp) {
			this._ereignisTyp = _ereignisTyp;
		}
	
		/**
		Glättungsparameter.
		<p>
		
		</p>
		
		@return der Wert von Glaettung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttGlaettung
			 getGlaettung() {
			return _glaettung;
		}
	
		/**
		Glättungsparameter.
		<p>
		
		</p>
		
		@param _glaettung der neue Wert von Glaettung.
		*/
		public void setGlaettung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttGlaettung
		 _glaettung) {
			this._glaettung = _glaettung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEreignisTyp = getEreignisTyp();
					final SystemObject tmpEreignisTyp;
						if (soEreignisTyp instanceof SystemObject) {
							tmpEreignisTyp = (SystemObject)soEreignisTyp;
						} else if(soEreignisTyp instanceof SystemObjekt){
							tmpEreignisTyp = ((SystemObjekt)soEreignisTyp).getSystemObject();
						} else{
							tmpEreignisTyp = null;
						}
					datum.getReferenceValue("EreignisTyp").setSystemObject(tmpEreignisTyp);
				// GanzzahlAttributTyp
				if (getGlaettung() != null) {
	                if (getGlaettung().isZustand()) {
	                    datum.getUnscaledValue("Glättung").setText(getGlaettung().toString());
	                } else {
						datum.
						getScaledValue
	                	("Glättung").set(getGlaettung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEreignisTyp = daten.getReferenceValue("EreignisTyp").getId();
					final SystemObjekt tmpEreignisTyp;
					if (idEreignisTyp == 0) {
						tmpEreignisTyp = null;
					} else {
						final SystemObject soEreignisTyp = factory.getDav().getDataModel().getObject(idEreignisTyp);
						if (soEreignisTyp == null) {
								tmpEreignisTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idEreignisTyp);
						} else {
							tmpEreignisTyp = factory.getModellobjekt(soEreignisTyp);
						}
					}
					setEreignisTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
					) tmpEreignisTyp);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Glättung").isState()) {
							setGlaettung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttGlaettung
							.getZustand(daten.getScaledValue("Glättung").getText()));
						} else {
						setGlaettung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttGlaettung
						(daten.
							getScaledValue
						("Glättung").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaParameterTyp clone() {
		AtlNbaParameterTyp klon = new AtlNbaParameterTyp();
		
						klon.setEreignisTyp(getEreignisTyp());
						klon.setGlaettung(getGlaettung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
