/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einstellung Grenzwert in Prozent pro Verkehrsparameter.
<p>
&lt;absatz&gt;
						Einstellung Grenzwert in Prozent pro Objekt und Verkehrsparameter.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 39
 */
public class AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _objektReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
			> _grenzwerte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
			>(0, true);
	
		/**
		Referenz auf ein Objekt.
		<p>
		
		</p>
		
		@return der Wert von ObjektReferenz.
		*/
			public 	Object
			 getObjektReferenz() {
			return _objektReferenz;
		}
	
		/**
		Referenz auf ein Objekt.
		<p>
		
		</p>
		
		@param _objektReferenz der neue Wert von ObjektReferenz.
		*/
		public void setObjektReferenz(	Object
		 _objektReferenz) {
			this._objektReferenz = _objektReferenz;
		}
	
		/**
		Globale Einstellung der Grenzwerte pro Verkehrsparameter.
		<p>
		
		</p>
		
		@return der Wert von Grenzwerte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
			> getGrenzwerte() {
			return _grenzwerte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soObjektReferenz = getObjektReferenz();
					final SystemObject tmpObjektReferenz;
						if (soObjektReferenz instanceof SystemObject) {
							tmpObjektReferenz = (SystemObject)soObjektReferenz;
						} else if(soObjektReferenz instanceof SystemObjekt){
							tmpObjektReferenz = ((SystemObjekt)soObjektReferenz).getSystemObject();
						} else{
							tmpObjektReferenz = null;
						}
					datum.getReferenceValue("ObjektReferenz").setSystemObject(tmpObjektReferenz);
				// AttributListenDefinition
					final Data.Array arrayGrenzwerte = datum.getArray("Grenzwerte");
					arrayGrenzwerte.setLength(getGrenzwerte().size());
					for (int i = 0; i < arrayGrenzwerte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
						 atl = getGrenzwerte().get(i);
						atl.bean2Atl(arrayGrenzwerte.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idObjektReferenz = daten.getReferenceValue("ObjektReferenz").getId();
					final SystemObjekt tmpObjektReferenz;
					if (idObjektReferenz == 0) {
						tmpObjektReferenz = null;
					} else {
						final SystemObject soObjektReferenz = factory.getDav().getDataModel().getObject(idObjektReferenz);
						if (soObjektReferenz == null) {
								tmpObjektReferenz = new BaseUngueltigesSystemObjekt(idObjektReferenz);
						} else {
							tmpObjektReferenz = factory.getModellobjekt(soObjektReferenz);
						}
					}
					setObjektReferenz((	Object
					) tmpObjektReferenz);
				// AttributListenDefinition
					final Data.Array arrayGrenzwerte = daten.getArray("Grenzwerte");
					for (int i = 0; i < arrayGrenzwerte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
						 ();
						atl.atl2Bean(arrayGrenzwerte.getItem(i), factory);
						getGrenzwerte().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt clone() {
		AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt klon = new AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt();
		
						klon.setObjektReferenz(getObjektReferenz());
					klon._grenzwerte = getGrenzwerte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
