/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einstellung Grenzwert in Prozent pro Verkehrsparameter.
<p>
&lt;absatz&gt;
						Einstellung Grenzwert in Prozent pro Objekt und Verkehrsparameter.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 39
 */
public class AtlNbaParameterUeberwachungPrognoseErgebnisseObjektTyp implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _typReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
			> _grenzwerteGlobal = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt
			> _grenzwerteObjekt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt
			>(0, true);
	
		/**
		Referenz auf ein Objekttyp.
		<p>
		
		</p>
		
		@return der Wert von TypReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getTypReferenz() {
			return _typReferenz;
		}
	
		/**
		Referenz auf ein Objekttyp.
		<p>
		
		</p>
		
		@param _typReferenz der neue Wert von TypReferenz.
		*/
		public void setTypReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _typReferenz) {
			this._typReferenz = _typReferenz;
		}
	
		/**
		Globale Einstellung der Grenzwerte pro Verkehrsparameter.
		<p>
		
		</p>
		
		@return der Wert von GrenzwerteGlobal.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
			> getGrenzwerteGlobal() {
			return _grenzwerteGlobal;
		}
	
	
		/**
		Globale Einstellung der Grenzwerte pro Verkehrsparameter.
		<p>
		
		</p>
		
		@return der Wert von GrenzwerteObjekt.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt
			> getGrenzwerteObjekt() {
			return _grenzwerteObjekt;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soTypReferenz = getTypReferenz();
					final SystemObject tmpTypReferenz;
						if (soTypReferenz instanceof SystemObject) {
							tmpTypReferenz = (SystemObject)soTypReferenz;
						} else if(soTypReferenz instanceof SystemObjekt){
							tmpTypReferenz = ((SystemObjekt)soTypReferenz).getSystemObject();
						} else{
							tmpTypReferenz = null;
						}
					datum.getReferenceValue("TypReferenz").setSystemObject(tmpTypReferenz);
				// AttributListenDefinition
					final Data.Array arrayGrenzwerteGlobal = datum.getArray("GrenzwerteGlobal");
					arrayGrenzwerteGlobal.setLength(getGrenzwerteGlobal().size());
					for (int i = 0; i < arrayGrenzwerteGlobal.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
						 atl = getGrenzwerteGlobal().get(i);
						atl.bean2Atl(arrayGrenzwerteGlobal.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayGrenzwerteObjekt = datum.getArray("GrenzwerteObjekt");
					arrayGrenzwerteObjekt.setLength(getGrenzwerteObjekt().size());
					for (int i = 0; i < arrayGrenzwerteObjekt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt
						 atl = getGrenzwerteObjekt().get(i);
						atl.bean2Atl(arrayGrenzwerteObjekt.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idTypReferenz = daten.getReferenceValue("TypReferenz").getId();
					final SystemObjekt tmpTypReferenz;
					if (idTypReferenz == 0) {
						tmpTypReferenz = null;
					} else {
						final SystemObject soTypReferenz = factory.getDav().getDataModel().getObject(idTypReferenz);
						if (soTypReferenz == null) {
								tmpTypReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTypReferenz);
						} else {
							tmpTypReferenz = factory.getModellobjekt(soTypReferenz);
						}
					}
					setTypReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpTypReferenz);
				// AttributListenDefinition
					final Data.Array arrayGrenzwerteGlobal = daten.getArray("GrenzwerteGlobal");
					for (int i = 0; i < arrayGrenzwerteGlobal.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisse
						 ();
						atl.atl2Bean(arrayGrenzwerteGlobal.getItem(i), factory);
						getGrenzwerteGlobal().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayGrenzwerteObjekt = daten.getArray("GrenzwerteObjekt");
					for (int i = 0; i < arrayGrenzwerteObjekt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaParameterUeberwachungPrognoseErgebnisseObjekt
						 ();
						atl.atl2Bean(arrayGrenzwerteObjekt.getItem(i), factory);
						getGrenzwerteObjekt().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaParameterUeberwachungPrognoseErgebnisseObjektTyp clone() {
		AtlNbaParameterUeberwachungPrognoseErgebnisseObjektTyp klon = new AtlNbaParameterUeberwachungPrognoseErgebnisseObjektTyp();
		
						klon.setTypReferenz(getTypReferenz());
					klon._grenzwerteGlobal = getGrenzwerteGlobal().clone();
					klon._grenzwerteObjekt = getGrenzwerteObjekt().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
