/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Parametrierung der Priorität.
<p>
&lt;absatz&gt;
            Attributgruppe zur Parametrierung der Priorität
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlNbaPrioritaetAnzeigeInhaltGlobal1 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _defaultPrioritaet
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
			> _anzeigeInhaltGlobal = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
			>(0, true);
	
		/**
		Priorität des Anzeigeinhalt.
		<p>
		
		</p>
		
		@return der Wert von DefaultPrioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 getDefaultPrioritaet() {
			return _defaultPrioritaet;
		}
	
		/**
		Priorität des Anzeigeinhalt.
		<p>
		
		</p>
		
		@param _defaultPrioritaet der neue Wert von DefaultPrioritaet.
		*/
		public void setDefaultPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
		 _defaultPrioritaet) {
			this._defaultPrioritaet = _defaultPrioritaet;
		}
	
		/**
		Priorität Aspekt.
		<p>
		
		</p>
		
		@return der Wert von AnzeigeInhaltGlobal.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
			> getAnzeigeInhaltGlobal() {
			return _anzeigeInhaltGlobal;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getDefaultPrioritaet() != null) {
	                if (getDefaultPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Default-Priorität").setText(getDefaultPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Default-Priorität").set(getDefaultPrioritaet().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayAnzeigeInhaltGlobal = datum.getArray("AnzeigeInhaltGlobal");
					arrayAnzeigeInhaltGlobal.setLength(getAnzeigeInhaltGlobal().size());
					for (int i = 0; i < arrayAnzeigeInhaltGlobal.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
						 atl = getAnzeigeInhaltGlobal().get(i);
						atl.bean2Atl(arrayAnzeigeInhaltGlobal.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Default-Priorität").isState()) {
							setDefaultPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							.getZustand(daten.getScaledValue("Default-Priorität").getText()));
						} else {
						setDefaultPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
						(daten.
							getUnscaledValue
						("Default-Priorität").
								intValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayAnzeigeInhaltGlobal = daten.getArray("AnzeigeInhaltGlobal");
					for (int i = 0; i < arrayAnzeigeInhaltGlobal.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
						 ();
						atl.atl2Bean(arrayAnzeigeInhaltGlobal.getItem(i), factory);
						getAnzeigeInhaltGlobal().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaPrioritaetAnzeigeInhaltGlobal1 clone() {
		AtlNbaPrioritaetAnzeigeInhaltGlobal1 klon = new AtlNbaPrioritaetAnzeigeInhaltGlobal1();
		
						klon.setDefaultPrioritaet(getDefaultPrioritaet());
					klon._anzeigeInhaltGlobal = getAnzeigeInhaltGlobal().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
