/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste zur Parametrierung der Priorität Aspekt.
<p>
&lt;absatz&gt;
            Attributliste zur Parametrierung der Priorität Aspekt
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 13
 */
public class AtlNbaPrioritaetAspekt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _defaultPrioritaet
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
			> _anzeigeInhaltAspekt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
			>(0, true);
	
		/**
		Referenz auf Aspekt.
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspekt() {
			return _aspekt;
		}
	
		/**
		Referenz auf Aspekt.
		<p>
		
		</p>
		
		@param _aspekt der neue Wert von Aspekt.
		*/
		public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspekt) {
			this._aspekt = _aspekt;
		}
	
		/**
		Priorität des Aspekts.
		<p>
		
		</p>
		
		@return der Wert von DefaultPrioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 getDefaultPrioritaet() {
			return _defaultPrioritaet;
		}
	
		/**
		Priorität des Aspekts.
		<p>
		
		</p>
		
		@param _defaultPrioritaet der neue Wert von DefaultPrioritaet.
		*/
		public void setDefaultPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
		 _defaultPrioritaet) {
			this._defaultPrioritaet = _defaultPrioritaet;
		}
	
		/**
		Priorität Anzeige Aspekt.
		<p>
		
		</p>
		
		@return der Wert von AnzeigeInhaltAspekt.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
			> getAnzeigeInhaltAspekt() {
			return _anzeigeInhaltAspekt;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAspekt = getAspekt();
					final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
					datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
				// GanzzahlAttributTyp
				if (getDefaultPrioritaet() != null) {
	                if (getDefaultPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Default-Priorität").setText(getDefaultPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Default-Priorität").set(getDefaultPrioritaet().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayAnzeigeInhaltAspekt = datum.getArray("AnzeigeInhaltAspekt");
					arrayAnzeigeInhaltAspekt.setLength(getAnzeigeInhaltAspekt().size());
					for (int i = 0; i < arrayAnzeigeInhaltAspekt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
						 atl = getAnzeigeInhaltAspekt().get(i);
						atl.bean2Atl(arrayAnzeigeInhaltAspekt.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAspekt = daten.getReferenceValue("Aspekt").getId();
					final SystemObjekt tmpAspekt;
					if (idAspekt == 0) {
						tmpAspekt = null;
					} else {
						final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
						if (soAspekt == null) {
								tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
						} else {
							tmpAspekt = factory.getModellobjekt(soAspekt);
						}
					}
					setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspekt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Default-Priorität").isState()) {
							setDefaultPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							.getZustand(daten.getScaledValue("Default-Priorität").getText()));
						} else {
						setDefaultPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
						(daten.
							getUnscaledValue
						("Default-Priorität").
								intValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayAnzeigeInhaltAspekt = daten.getArray("AnzeigeInhaltAspekt");
					for (int i = 0; i < arrayAnzeigeInhaltAspekt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAnzeigeInhaltGlobal
						 ();
						atl.atl2Bean(arrayAnzeigeInhaltAspekt.getItem(i), factory);
						getAnzeigeInhaltAspekt().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaPrioritaetAspekt clone() {
		AtlNbaPrioritaetAspekt klon = new AtlNbaPrioritaetAspekt();
		
						klon.setAspekt(getAspekt());
						klon.setDefaultPrioritaet(getDefaultPrioritaet());
					klon._anzeigeInhaltAspekt = getAnzeigeInhaltAspekt().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
