/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelner Reisezeit-Prognose-Datensatz für die NBA.
<p>
&lt;absatz&gt;
						Einzelner Reisezeit-Prognose-Datensatz für die NBA.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaReisezeitPrognose implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitpunkt
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private 	RelativerZeitstempel
			 _reisezeitAlg2
			;
	
		/**
		Zeitpunkt für die prognostizierte Reisezeit.
		<p>
		
		</p>
		
		@return der Wert von Zeitpunkt.
		*/
			public 	Zeitstempel
			 getZeitpunkt() {
			return _zeitpunkt;
		}
	
		/**
		Zeitpunkt für die prognostizierte Reisezeit.
		<p>
		
		</p>
		
		@param _zeitpunkt der neue Wert von Zeitpunkt.
		*/
		public void setZeitpunkt(	Zeitstempel
		 _zeitpunkt) {
			this._zeitpunkt = _zeitpunkt;
		}
	
		/**
		Reisezeit zum Zeitpunkt (im Falle einer Überlastung der Strecke (Q prog grosser als Q max) berechnet durch Korrektur).
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Reisezeit zum Zeitpunkt (im Falle einer Überlastung der Strecke (Q prog grosser als Q max) berechnet durch Korrektur).
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Reisezeit zum Zeitpunkt (im Falle einer Überlastung der Strecke (Q prog grosser als Q max) berechnet mit Stau in der Zukunft).
		<p>
		
		</p>
		
		@return der Wert von ReisezeitAlg2.
		*/
			public 	RelativerZeitstempel
			 getReisezeitAlg2() {
			return _reisezeitAlg2;
		}
	
		/**
		Reisezeit zum Zeitpunkt (im Falle einer Überlastung der Strecke (Q prog grosser als Q max) berechnet mit Stau in der Zukunft).
		<p>
		
		</p>
		
		@param _reisezeitAlg2 der neue Wert von ReisezeitAlg2.
		*/
		public void setReisezeitAlg2(	RelativerZeitstempel
		 _reisezeitAlg2) {
			this._reisezeitAlg2 = _reisezeitAlg2;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ReisezeitAlg2").setMillis(getReisezeitAlg2().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Zeitpunkt").getMillis()));
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// ZeitstempelAttributTyp
					setReisezeitAlg2(new
						RelativerZeitstempel
						(daten.getTimeValue("ReisezeitAlg2").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaReisezeitPrognose clone() {
		AtlNbaReisezeitPrognose klon = new AtlNbaReisezeitPrognose();
		
						klon.setZeitpunkt(getZeitpunkt());
						klon.setReisezeit(getReisezeit());
						klon.setReisezeitAlg2(getReisezeitAlg2());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
