/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ReisezeitPrognose für die Messquerschnitte des NBA-RoutenStück für einen Prognosezeitpunkt.
<p>
&lt;absatz&gt;
						ReisezeitPrognose für die Messquerschnitte des NBA-RoutenStück für einen Prognosezeitpunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 30
 */
public class AtlNbaRoutenStueckReisezeitPrognoseMQ implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitpunkt
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln
			> _reisezeitPrognose = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln
			>(0, true);
	
		/**
		Zeitpunkt der Reisezeitprognose.
		<p>
		
		</p>
		
		@return der Wert von Zeitpunkt.
		*/
			public 	Zeitstempel
			 getZeitpunkt() {
			return _zeitpunkt;
		}
	
		/**
		Zeitpunkt der Reisezeitprognose.
		<p>
		
		</p>
		
		@param _zeitpunkt der neue Wert von Zeitpunkt.
		*/
		public void setZeitpunkt(	Zeitstempel
		 _zeitpunkt) {
			this._zeitpunkt = _zeitpunkt;
		}
	
		/**
		ReisezeitPrognose für die Messquerschnitte des NBA-RoutenStück für einen Prognosezeitpunkt.
		<p>
		
		</p>
		
		@return der Wert von ReisezeitPrognose.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln
			> getReisezeitPrognose() {
			return _reisezeitPrognose;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
				// AttributListenDefinition
					final Data.Array arrayReisezeitPrognose = datum.getArray("ReisezeitPrognose");
					arrayReisezeitPrognose.setLength(getReisezeitPrognose().size());
					for (int i = 0; i < arrayReisezeitPrognose.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln
						 atl = getReisezeitPrognose().get(i);
						atl.bean2Atl(arrayReisezeitPrognose.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Zeitpunkt").getMillis()));
				// AttributListenDefinition
					final Data.Array arrayReisezeitPrognose = daten.getArray("ReisezeitPrognose");
					for (int i = 0; i < arrayReisezeitPrognose.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln
						 ();
						atl.atl2Bean(arrayReisezeitPrognose.getItem(i), factory);
						getReisezeitPrognose().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaRoutenStueckReisezeitPrognoseMQ clone() {
		AtlNbaRoutenStueckReisezeitPrognoseMQ klon = new AtlNbaRoutenStueckReisezeitPrognoseMQ();
		
						klon.setZeitpunkt(getZeitpunkt());
					klon._reisezeitPrognose = getReisezeitPrognose().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
