/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Reisezeitberechnung pro Route.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenReisezeitAlgorithmus5 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private 	RelativerZeitstempel
			 _reisezeitMitFaktorOffset
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitRS
			> _routenstueck = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitRS
			>(0, true);
	
		/**
		Aktuelle Reisezeit der Route.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit der Route.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit der Route unter Berücksichtigung der Parameter Faktor und Offset.
		<p>
		
		</p>
		
		@return der Wert von ReisezeitMitFaktorOffset.
		*/
			public 	RelativerZeitstempel
			 getReisezeitMitFaktorOffset() {
			return _reisezeitMitFaktorOffset;
		}
	
		/**
		Aktuelle Reisezeit der Route unter Berücksichtigung der Parameter Faktor und Offset.
		<p>
		
		</p>
		
		@param _reisezeitMitFaktorOffset der neue Wert von ReisezeitMitFaktorOffset.
		*/
		public void setReisezeitMitFaktorOffset(	RelativerZeitstempel
		 _reisezeitMitFaktorOffset) {
			this._reisezeitMitFaktorOffset = _reisezeitMitFaktorOffset;
		}
	
		/**
		Aktuelle Analyse der Reisezeitbestimmung des Routenstück.
		<p>
		
		</p>
		
		@return der Wert von Routenstueck.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitRS
			> getRoutenstueck() {
			return _routenstueck;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ReisezeitMitFaktorOffset").setMillis(getReisezeitMitFaktorOffset().getTime());
				// AttributListenDefinition
					final Data.Array arrayRoutenstueck = datum.getArray("Routenstück");
					arrayRoutenstueck.setLength(getRoutenstueck().size());
					for (int i = 0; i < arrayRoutenstueck.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitRS
						 atl = getRoutenstueck().get(i);
						atl.bean2Atl(arrayRoutenstueck.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// ZeitstempelAttributTyp
					setReisezeitMitFaktorOffset(new
						RelativerZeitstempel
						(daten.getTimeValue("ReisezeitMitFaktorOffset").getMillis()));
				// AttributListenDefinition
					final Data.Array arrayRoutenstueck = daten.getArray("Routenstück");
					for (int i = 0; i < arrayRoutenstueck.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitRS
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitRS
						 ();
						atl.atl2Bean(arrayRoutenstueck.getItem(i), factory);
						getRoutenstueck().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenReisezeitAlgorithmus5 clone() {
		AtlNbaStrgDatenReisezeitAlgorithmus5 klon = new AtlNbaStrgDatenReisezeitAlgorithmus5();
		
						klon.setReisezeit(getReisezeit());
						klon.setReisezeitMitFaktorOffset(getReisezeitMitFaktorOffset());
					klon._routenstueck = getRoutenstueck().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
