/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Reisezeitberechnung pro RoutenStück.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenReisezeitRS implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			 _routenStueck
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSS
			> _strassenSegment = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSS
			>(0, true);
	
		/**
		Referenz auf ein Routenstück.
		<p>
		
		</p>
		
		@return der Wert von RoutenStueck.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			 getRoutenStueck() {
			return _routenStueck;
		}
	
		/**
		Referenz auf ein Routenstück.
		<p>
		
		</p>
		
		@param _routenStueck der neue Wert von RoutenStueck.
		*/
		public void setRoutenStueck(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
		 _routenStueck) {
			this._routenStueck = _routenStueck;
		}
	
		/**
		Aktuelle Reisezeit des RoutenStück.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit des RoutenStück.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Länge des Routenstück.
		<p>
		
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Länge des Routenstück.
		<p>
		
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laenge) {
			this._laenge = _laenge;
		}
	
		/**
		Aktuelle Analyse der Reisezeitbestimmung des StraßenSegmentt.
		<p>
		
		</p>
		
		@return der Wert von StrassenSegment.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSS
			> getStrassenSegment() {
			return _strassenSegment;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soRoutenStueck = getRoutenStueck();
					final SystemObject tmpRoutenStueck;
						if (soRoutenStueck instanceof SystemObject) {
							tmpRoutenStueck = (SystemObject)soRoutenStueck;
						} else if(soRoutenStueck instanceof SystemObjekt){
							tmpRoutenStueck = ((SystemObjekt)soRoutenStueck).getSystemObject();
						} else{
							tmpRoutenStueck = null;
						}
					datum.getReferenceValue("RoutenStück").setSystemObject(tmpRoutenStueck);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Länge").set(getLaenge().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayStrassenSegment = datum.getArray("StraßenSegment");
					arrayStrassenSegment.setLength(getStrassenSegment().size());
					for (int i = 0; i < arrayStrassenSegment.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSS
						 atl = getStrassenSegment().get(i);
						atl.bean2Atl(arrayStrassenSegment.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idRoutenStueck = daten.getReferenceValue("RoutenStück").getId();
					final SystemObjekt tmpRoutenStueck;
					if (idRoutenStueck == 0) {
						tmpRoutenStueck = null;
					} else {
						final SystemObject soRoutenStueck = factory.getDav().getDataModel().getObject(idRoutenStueck);
						if (soRoutenStueck == null) {
								tmpRoutenStueck = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.RoutenStueckUngueltig(idRoutenStueck);
						} else {
							tmpRoutenStueck = factory.getModellobjekt(soRoutenStueck);
						}
					}
					setRoutenStueck((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
					) tmpRoutenStueck);
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Länge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Länge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Länge").
								longValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayStrassenSegment = daten.getArray("StraßenSegment");
					for (int i = 0; i < arrayStrassenSegment.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSS
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSS
						 ();
						atl.atl2Bean(arrayStrassenSegment.getItem(i), factory);
						getStrassenSegment().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenReisezeitRS clone() {
		AtlNbaStrgDatenReisezeitRS klon = new AtlNbaStrgDatenReisezeitRS();
		
						klon.setRoutenStueck(getRoutenStueck());
						klon.setReisezeit(getReisezeit());
						klon.setLaenge(getLaenge());
					klon._strassenSegment = getStrassenSegment().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
