/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Reisezeitberechnung pro StraßenSegment.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenReisezeitSS implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
			 _strassenSegment
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSTS
			> _strassenTeilSegment = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSTS
			>(0, true);
	
		/**
		Referenz auf ein StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von StrassenSegment.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
			 getStrassenSegment() {
			return _strassenSegment;
		}
	
		/**
		Referenz auf ein StraßenSegment.
		<p>
		
		</p>
		
		@param _strassenSegment der neue Wert von StrassenSegment.
		*/
		public void setStrassenSegment(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
		 _strassenSegment) {
			this._strassenSegment = _strassenSegment;
		}
	
		/**
		Aktuelle Reisezeit des StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit des StraßenSegment.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Länge des StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Länge des StraßenSegment.
		<p>
		
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laenge) {
			this._laenge = _laenge;
		}
	
		/**
		Aktuelle Analyse der Reisezeitbestimmung des StraßenTeilSegment.
		<p>
		
		</p>
		
		@return der Wert von StrassenTeilSegment.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSTS
			> getStrassenTeilSegment() {
			return _strassenTeilSegment;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStrassenSegment = getStrassenSegment();
					final SystemObject tmpStrassenSegment;
						if (soStrassenSegment instanceof SystemObject) {
							tmpStrassenSegment = (SystemObject)soStrassenSegment;
						} else if(soStrassenSegment instanceof SystemObjekt){
							tmpStrassenSegment = ((SystemObjekt)soStrassenSegment).getSystemObject();
						} else{
							tmpStrassenSegment = null;
						}
					datum.getReferenceValue("StraßenSegment").setSystemObject(tmpStrassenSegment);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Länge").set(getLaenge().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayStrassenTeilSegment = datum.getArray("StraßenTeilSegment");
					arrayStrassenTeilSegment.setLength(getStrassenTeilSegment().size());
					for (int i = 0; i < arrayStrassenTeilSegment.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSTS
						 atl = getStrassenTeilSegment().get(i);
						atl.bean2Atl(arrayStrassenTeilSegment.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStrassenSegment = daten.getReferenceValue("StraßenSegment").getId();
					final SystemObjekt tmpStrassenSegment;
					if (idStrassenSegment == 0) {
						tmpStrassenSegment = null;
					} else {
						final SystemObject soStrassenSegment = factory.getDav().getDataModel().getObject(idStrassenSegment);
						if (soStrassenSegment == null) {
								tmpStrassenSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenSegmentUngueltig(idStrassenSegment);
						} else {
							tmpStrassenSegment = factory.getModellobjekt(soStrassenSegment);
						}
					}
					setStrassenSegment((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
					) tmpStrassenSegment);
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Länge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Länge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Länge").
								longValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayStrassenTeilSegment = daten.getArray("StraßenTeilSegment");
					for (int i = 0; i < arrayStrassenTeilSegment.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSTS
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitSTS
						 ();
						atl.atl2Bean(arrayStrassenTeilSegment.getItem(i), factory);
						getStrassenTeilSegment().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenReisezeitSS clone() {
		AtlNbaStrgDatenReisezeitSS klon = new AtlNbaStrgDatenReisezeitSS();
		
						klon.setStrassenSegment(getStrassenSegment());
						klon.setReisezeit(getReisezeit());
						klon.setLaenge(getLaenge());
					klon._strassenTeilSegment = getStrassenTeilSegment().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
