/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Reisezeitberechnung pro StraßenTeilSegment.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenReisezeitSTS implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 _strassenTeilSegment
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _geschwindigkeit
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitMQ
			> _messQuerschnitt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitMQ
			>(0, true);
	
		/**
		Referenz auf ein StraßenTeilSegment.
		<p>
		
		</p>
		
		@return der Wert von StrassenTeilSegment.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 getStrassenTeilSegment() {
			return _strassenTeilSegment;
		}
	
		/**
		Referenz auf ein StraßenTeilSegment.
		<p>
		
		</p>
		
		@param _strassenTeilSegment der neue Wert von StrassenTeilSegment.
		*/
		public void setStrassenTeilSegment(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
		 _strassenTeilSegment) {
			this._strassenTeilSegment = _strassenTeilSegment;
		}
	
		/**
		Aktuelle Reisezeit des StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit des StraßenSegment.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Länge des StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Länge des StraßenSegment.
		<p>
		
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laenge) {
			this._laenge = _laenge;
		}
	
		/**
		Default Geschwindigkeit auf dem StraßenTeilSegment. Wird verwendet, wenn auf dem
		            StraßenSegment auf dem das StraßenTeilSegment liegt keine Erfassung (MQ) vorhanden ist.
		<p>
		
		</p>
		
		@return der Wert von Geschwindigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getGeschwindigkeit() {
			return _geschwindigkeit;
		}
	
		/**
		Default Geschwindigkeit auf dem StraßenTeilSegment. Wird verwendet, wenn auf dem
		            StraßenSegment auf dem das StraßenTeilSegment liegt keine Erfassung (MQ) vorhanden ist.
		<p>
		
		</p>
		
		@param _geschwindigkeit der neue Wert von Geschwindigkeit.
		*/
		public void setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _geschwindigkeit) {
			this._geschwindigkeit = _geschwindigkeit;
		}
	
		/**
		Aktuelle Analyse der Reisezeitbestimmung des MessQuerschnitt.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitMQ
			> getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStrassenTeilSegment = getStrassenTeilSegment();
					final SystemObject tmpStrassenTeilSegment;
						if (soStrassenTeilSegment instanceof SystemObject) {
							tmpStrassenTeilSegment = (SystemObject)soStrassenTeilSegment;
						} else if(soStrassenTeilSegment instanceof SystemObjekt){
							tmpStrassenTeilSegment = ((SystemObjekt)soStrassenTeilSegment).getSystemObject();
						} else{
							tmpStrassenTeilSegment = null;
						}
					datum.getReferenceValue("StraßenTeilSegment").setSystemObject(tmpStrassenTeilSegment);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Länge").set(getLaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGeschwindigkeit() != null) {
	                if (getGeschwindigkeit().isZustand()) {
	                    datum.getUnscaledValue("Geschwindigkeit").setText(getGeschwindigkeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Geschwindigkeit").set(getGeschwindigkeit().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayMessQuerschnitt = datum.getArray("MessQuerschnitt");
					arrayMessQuerschnitt.setLength(getMessQuerschnitt().size());
					for (int i = 0; i < arrayMessQuerschnitt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitMQ
						 atl = getMessQuerschnitt().get(i);
						atl.bean2Atl(arrayMessQuerschnitt.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStrassenTeilSegment = daten.getReferenceValue("StraßenTeilSegment").getId();
					final SystemObjekt tmpStrassenTeilSegment;
					if (idStrassenTeilSegment == 0) {
						tmpStrassenTeilSegment = null;
					} else {
						final SystemObject soStrassenTeilSegment = factory.getDav().getDataModel().getObject(idStrassenTeilSegment);
						if (soStrassenTeilSegment == null) {
								tmpStrassenTeilSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenTeilSegmentUngueltig(idStrassenTeilSegment);
						} else {
							tmpStrassenTeilSegment = factory.getModellobjekt(soStrassenTeilSegment);
						}
					}
					setStrassenTeilSegment((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
					) tmpStrassenTeilSegment);
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Länge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Länge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Länge").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Geschwindigkeit").isState()) {
							setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("Geschwindigkeit").getText()));
						} else {
						setGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("Geschwindigkeit").
								shortValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayMessQuerschnitt = daten.getArray("MessQuerschnitt");
					for (int i = 0; i < arrayMessQuerschnitt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitMQ
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenReisezeitMQ
						 ();
						atl.atl2Bean(arrayMessQuerschnitt.getItem(i), factory);
						getMessQuerschnitt().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenReisezeitSTS clone() {
		AtlNbaStrgDatenReisezeitSTS klon = new AtlNbaStrgDatenReisezeitSTS();
		
						klon.setStrassenTeilSegment(getStrassenTeilSegment());
						klon.setReisezeit(getReisezeit());
						klon.setLaenge(getLaenge());
						klon.setGeschwindigkeit(getGeschwindigkeit());
					klon._messQuerschnitt = getMessQuerschnitt().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
