/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten pro Stauindikator.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenStauindikatorAlgorithmus7 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 _strassenTeilSegment
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _siNr
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
			 _stauindikator
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 _logik
			;
	
		/**
		Referenz auf ein StraßenTeilSegment.
		<p>
		
		</p>
		
		@return der Wert von StrassenTeilSegment.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 getStrassenTeilSegment() {
			return _strassenTeilSegment;
		}
	
		/**
		Referenz auf ein StraßenTeilSegment.
		<p>
		
		</p>
		
		@param _strassenTeilSegment der neue Wert von StrassenTeilSegment.
		*/
		public void setStrassenTeilSegment(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
		 _strassenTeilSegment) {
			this._strassenTeilSegment = _strassenTeilSegment;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@return der Wert von SiNr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getSiNr() {
			return _siNr;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@param _siNr der neue Wert von SiNr.
		*/
		public void setSiNr(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _siNr) {
			this._siNr = _siNr;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@return der Wert von Stauindikator.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
			 getStauindikator() {
			return _stauindikator;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@param _stauindikator der neue Wert von Stauindikator.
		*/
		public void setStauindikator(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
		 _stauindikator) {
			this._stauindikator = _stauindikator;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@return der Wert von Logik.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 getLogik() {
			return _logik;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@param _logik der neue Wert von Logik.
		*/
		public void setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
		 _logik) {
			this._logik = _logik;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStrassenTeilSegment = getStrassenTeilSegment();
					final SystemObject tmpStrassenTeilSegment;
						if (soStrassenTeilSegment instanceof SystemObject) {
							tmpStrassenTeilSegment = (SystemObject)soStrassenTeilSegment;
						} else if(soStrassenTeilSegment instanceof SystemObjekt){
							tmpStrassenTeilSegment = ((SystemObjekt)soStrassenTeilSegment).getSystemObject();
						} else{
							tmpStrassenTeilSegment = null;
						}
					datum.getReferenceValue("StraßenTeilSegment").setSystemObject(tmpStrassenTeilSegment);
				// GanzzahlAttributTyp
				if (getSiNr() != null) {
	                if (getSiNr().isZustand()) {
	                    datum.getUnscaledValue("SiNr").setText(getSiNr().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SiNr").set(getSiNr().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStauindikator() != null) {
	                if (getStauindikator().isZustand()) {
	                    datum.getUnscaledValue("Stauindikator").setText(getStauindikator().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Stauindikator").set(getStauindikator().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLogik() != null) {
	                if (getLogik().isZustand()) {
	                    datum.getUnscaledValue("Logik").setText(getLogik().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Logik").set(getLogik().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStrassenTeilSegment = daten.getReferenceValue("StraßenTeilSegment").getId();
					final SystemObjekt tmpStrassenTeilSegment;
					if (idStrassenTeilSegment == 0) {
						tmpStrassenTeilSegment = null;
					} else {
						final SystemObject soStrassenTeilSegment = factory.getDav().getDataModel().getObject(idStrassenTeilSegment);
						if (soStrassenTeilSegment == null) {
								tmpStrassenTeilSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenTeilSegmentUngueltig(idStrassenTeilSegment);
						} else {
							tmpStrassenTeilSegment = factory.getModellobjekt(soStrassenTeilSegment);
						}
					}
					setStrassenTeilSegment((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
					) tmpStrassenTeilSegment);
				// GanzzahlAttributTyp
						setSiNr(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("SiNr").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Stauindikator").isState()) {
							setStauindikator(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
							.getZustand(daten.getScaledValue("Stauindikator").getText()));
						} else {
						setStauindikator(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
						(daten.
							getUnscaledValue
						("Stauindikator").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Logik").isState()) {
							setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
							.getZustand(daten.getScaledValue("Logik").getText()));
						} else {
						setLogik(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
						(daten.
							getUnscaledValue
						("Logik").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenStauindikatorAlgorithmus7 clone() {
		AtlNbaStrgDatenStauindikatorAlgorithmus7 klon = new AtlNbaStrgDatenStauindikatorAlgorithmus7();
		
						klon.setStrassenTeilSegment(getStrassenTeilSegment());
						klon.setSiNr(getSiNr());
						klon.setStauindikator(getStauindikator());
						klon.setLogik(getLogik());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
