/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Staulängenberechnung pro Route.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenStaulaengeAlgorithmus6 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _staulaenge
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _staulaengeMitOffset
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStaulaenge
			> _stau = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStaulaenge
			>(0, true);
	
		/**
		Aktuell vorhandene Staulänge auf der Route.
		<p>
		
		</p>
		
		@return der Wert von Staulaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStaulaenge() {
			return _staulaenge;
		}
	
		/**
		Aktuell vorhandene Staulänge auf der Route.
		<p>
		
		</p>
		
		@param _staulaenge der neue Wert von Staulaenge.
		*/
		public void setStaulaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _staulaenge) {
			this._staulaenge = _staulaenge;
		}
	
		/**
		Aktuell vorhandene Staulänge auf der Route unter Berücksichtigung des Offset.
		<p>
		
		</p>
		
		@return der Wert von StaulaengeMitOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStaulaengeMitOffset() {
			return _staulaengeMitOffset;
		}
	
		/**
		Aktuell vorhandene Staulänge auf der Route unter Berücksichtigung des Offset.
		<p>
		
		</p>
		
		@param _staulaengeMitOffset der neue Wert von StaulaengeMitOffset.
		*/
		public void setStaulaengeMitOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _staulaengeMitOffset) {
			this._staulaengeMitOffset = _staulaengeMitOffset;
		}
	
		/**
		Aktuelle Staulänge des Staus.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStaulaenge
			> getStau() {
			return _stau;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getStaulaenge() != null) {
	                if (getStaulaenge().isZustand()) {
	                    datum.getUnscaledValue("Staulänge").setText(getStaulaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Staulänge").set(getStaulaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStaulaengeMitOffset() != null) {
	                if (getStaulaengeMitOffset().isZustand()) {
	                    datum.getUnscaledValue("StaulängeMitOffset").setText(getStaulaengeMitOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StaulängeMitOffset").set(getStaulaengeMitOffset().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayStau = datum.getArray("Stau");
					arrayStau.setLength(getStau().size());
					for (int i = 0; i < arrayStau.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStaulaenge
						 atl = getStau().get(i);
						atl.bean2Atl(arrayStau.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Staulänge").isState()) {
							setStaulaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Staulänge").getText()));
						} else {
						setStaulaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Staulänge").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StaulängeMitOffset").isState()) {
							setStaulaengeMitOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("StaulängeMitOffset").getText()));
						} else {
						setStaulaengeMitOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("StaulängeMitOffset").
								longValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayStau = daten.getArray("Stau");
					for (int i = 0; i < arrayStau.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStaulaenge
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgDatenStaulaenge
						 ();
						atl.atl2Bean(arrayStau.getItem(i), factory);
						getStau().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenStaulaengeAlgorithmus6 clone() {
		AtlNbaStrgDatenStaulaengeAlgorithmus6 klon = new AtlNbaStrgDatenStaulaengeAlgorithmus6();
		
						klon.setStaulaenge(getStaulaenge());
						klon.setStaulaengeMitOffset(getStaulaengeMitOffset());
					klon._stau = getStau().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
