/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus1 (Geschwindigkeit).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus1 (Geschwindigkeit)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaStrgParameterAlgorithmus1 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfzStufeEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfzStufeAus
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vDiffStufeEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qGStufeEin
			;
	
		/**
		Einschaltkriterium VKfz.
		<p>
		
		</p>
		
		@return der Wert von VKfzStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVKfzStufeEin() {
			return _vKfzStufeEin;
		}
	
		/**
		Einschaltkriterium VKfz.
		<p>
		
		</p>
		
		@param _vKfzStufeEin der neue Wert von VKfzStufeEin.
		*/
		public void setVKfzStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vKfzStufeEin) {
			this._vKfzStufeEin = _vKfzStufeEin;
		}
	
		/**
		Ausschaltkriterium VKfz.
		<p>
		
		</p>
		
		@return der Wert von VKfzStufeAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVKfzStufeAus() {
			return _vKfzStufeAus;
		}
	
		/**
		Ausschaltkriterium VKfz.
		<p>
		
		</p>
		
		@param _vKfzStufeAus der neue Wert von VKfzStufeAus.
		*/
		public void setVKfzStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vKfzStufeAus) {
			this._vKfzStufeAus = _vKfzStufeAus;
		}
	
		/**
		Einschaltkriterium VDiff.
		<p>
		
		</p>
		
		@return der Wert von VDiffStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVDiffStufeEin() {
			return _vDiffStufeEin;
		}
	
		/**
		Einschaltkriterium VDiff.
		<p>
		
		</p>
		
		@param _vDiffStufeEin der neue Wert von VDiffStufeEin.
		*/
		public void setVDiffStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vDiffStufeEin) {
			this._vDiffStufeEin = _vDiffStufeEin;
		}
	
		/**
		Einschaltkriterium QKfz.
		<p>
		
		</p>
		
		@return der Wert von QGStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getQGStufeEin() {
			return _qGStufeEin;
		}
	
		/**
		Einschaltkriterium QKfz.
		<p>
		
		</p>
		
		@param _qGStufeEin der neue Wert von QGStufeEin.
		*/
		public void setQGStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _qGStufeEin) {
			this._qGStufeEin = _qGStufeEin;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVKfzStufeEin() != null) {
	                if (getVKfzStufeEin().isZustand()) {
	                    datum.getUnscaledValue("vKfzStufeEin").setText(getVKfzStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vKfzStufeEin").set(getVKfzStufeEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVKfzStufeAus() != null) {
	                if (getVKfzStufeAus().isZustand()) {
	                    datum.getUnscaledValue("vKfzStufeAus").setText(getVKfzStufeAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vKfzStufeAus").set(getVKfzStufeAus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVDiffStufeEin() != null) {
	                if (getVDiffStufeEin().isZustand()) {
	                    datum.getUnscaledValue("vDiffStufeEin").setText(getVDiffStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vDiffStufeEin").set(getVDiffStufeEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQGStufeEin() != null) {
	                if (getQGStufeEin().isZustand()) {
	                    datum.getUnscaledValue("qGStufeEin").setText(getQGStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("qGStufeEin").set(getQGStufeEin().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vKfzStufeEin").isState()) {
							setVKfzStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vKfzStufeEin").getText()));
						} else {
						setVKfzStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vKfzStufeEin").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vKfzStufeAus").isState()) {
							setVKfzStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vKfzStufeAus").getText()));
						} else {
						setVKfzStufeAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vKfzStufeAus").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vDiffStufeEin").isState()) {
							setVDiffStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vDiffStufeEin").getText()));
						} else {
						setVDiffStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vDiffStufeEin").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("qGStufeEin").isState()) {
							setQGStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("qGStufeEin").getText()));
						} else {
						setQGStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("qGStufeEin").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgParameterAlgorithmus1 clone() {
		AtlNbaStrgParameterAlgorithmus1 klon = new AtlNbaStrgParameterAlgorithmus1();
		
						klon.setVKfzStufeEin(getVKfzStufeEin());
						klon.setVKfzStufeAus(getVKfzStufeAus());
						klon.setVDiffStufeEin(getVDiffStufeEin());
						klon.setQGStufeEin(getQGStufeEin());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
