/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus3 (Bemessungsverkehrsstärke).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus3 (Bemessungsverkehrsstärke)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaStrgParameterAlgorithmus3 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 _qbStufeEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 _qbStufeAus
			;
	
		/**
		Einschaltkriterium Bemessungsverkehrsstärke.
		<p>
		
		</p>
		
		@return der Wert von QbStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 getQbStufeEin() {
			return _qbStufeEin;
		}
	
		/**
		Einschaltkriterium Bemessungsverkehrsstärke.
		<p>
		
		</p>
		
		@param _qbStufeEin der neue Wert von QbStufeEin.
		*/
		public void setQbStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
		 _qbStufeEin) {
			this._qbStufeEin = _qbStufeEin;
		}
	
		/**
		Ausschaltkriterium Bemessungsverkehrsstärke.
		<p>
		
		</p>
		
		@return der Wert von QbStufeAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 getQbStufeAus() {
			return _qbStufeAus;
		}
	
		/**
		Ausschaltkriterium Bemessungsverkehrsstärke.
		<p>
		
		</p>
		
		@param _qbStufeAus der neue Wert von QbStufeAus.
		*/
		public void setQbStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
		 _qbStufeAus) {
			this._qbStufeAus = _qbStufeAus;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getQbStufeEin() != null) {
	                if (getQbStufeEin().isZustand()) {
	                    datum.getUnscaledValue("QbStufeEin").setText(getQbStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QbStufeEin").set(getQbStufeEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQbStufeAus() != null) {
	                if (getQbStufeAus().isZustand()) {
	                    datum.getUnscaledValue("QbStufeAus").setText(getQbStufeAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QbStufeAus").set(getQbStufeAus().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QbStufeEin").isState()) {
							setQbStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("QbStufeEin").getText()));
						} else {
						setQbStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("QbStufeEin").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QbStufeAus").isState()) {
							setQbStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("QbStufeAus").getText()));
						} else {
						setQbStufeAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("QbStufeAus").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgParameterAlgorithmus3 clone() {
		AtlNbaStrgParameterAlgorithmus3 klon = new AtlNbaStrgParameterAlgorithmus3();
		
						klon.setQbStufeEin(getQbStufeEin());
						klon.setQbStufeAus(getQbStufeAus());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
