/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus4 (KFZ-Verkehrsstärke).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung
            Algorithmus4 (KFZ-Verkehrsstärke)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaStrgParameterAlgorithmus4 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qKfzStufeEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _qKfzStufeAus
			;
	
		/**
		Einschaltkriterium KFZ-Verkehrsstärke.
		<p>
		
		</p>
		
		@return der Wert von QKfzStufeEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getQKfzStufeEin() {
			return _qKfzStufeEin;
		}
	
		/**
		Einschaltkriterium KFZ-Verkehrsstärke.
		<p>
		
		</p>
		
		@param _qKfzStufeEin der neue Wert von QKfzStufeEin.
		*/
		public void setQKfzStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _qKfzStufeEin) {
			this._qKfzStufeEin = _qKfzStufeEin;
		}
	
		/**
		Ausschaltkriterium KFZ-Verkehrsstärke.
		<p>
		
		</p>
		
		@return der Wert von QKfzStufeAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getQKfzStufeAus() {
			return _qKfzStufeAus;
		}
	
		/**
		Ausschaltkriterium KFZ-Verkehrsstärke.
		<p>
		
		</p>
		
		@param _qKfzStufeAus der neue Wert von QKfzStufeAus.
		*/
		public void setQKfzStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _qKfzStufeAus) {
			this._qKfzStufeAus = _qKfzStufeAus;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getQKfzStufeEin() != null) {
	                if (getQKfzStufeEin().isZustand()) {
	                    datum.getUnscaledValue("QKfzStufeEin").setText(getQKfzStufeEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QKfzStufeEin").set(getQKfzStufeEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQKfzStufeAus() != null) {
	                if (getQKfzStufeAus().isZustand()) {
	                    datum.getUnscaledValue("QKfzStufeAus").setText(getQKfzStufeAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QKfzStufeAus").set(getQKfzStufeAus().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QKfzStufeEin").isState()) {
							setQKfzStufeEin(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("QKfzStufeEin").getText()));
						} else {
						setQKfzStufeEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("QKfzStufeEin").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QKfzStufeAus").isState()) {
							setQKfzStufeAus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("QKfzStufeAus").getText()));
						} else {
						setQKfzStufeAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("QKfzStufeAus").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgParameterAlgorithmus4 clone() {
		AtlNbaStrgParameterAlgorithmus4 klon = new AtlNbaStrgParameterAlgorithmus4();
		
						klon.setQKfzStufeEin(getQKfzStufeEin());
						klon.setQKfzStufeAus(getQKfzStufeAus());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
