/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus6 (Stausituation, lngenbezogen).
<p>
&lt;absatz&gt;
						Attributliste fr Definition der Parameter Steuerung fr lokale Beeinflussung
            Algorithmus6 (Stausituation, lngenbezogen).
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgParameterAlgorithmus6 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _slmaxEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _slmaxAus
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _lkEin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _lkAus
			;
	
		/**
		maximale Staulnge fr die Route k Einschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von SlmaxEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getSlmaxEin() {
			return _slmaxEin;
		}
	
		/**
		maximale Staulnge fr die Route k Einschaltkriterium.
		<p>
		
		</p>
		
		@param _slmaxEin der neue Wert von SlmaxEin.
		*/
		public void setSlmaxEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _slmaxEin) {
			this._slmaxEin = _slmaxEin;
		}
	
		/**
		maximale Staulnge fr die Route k Ausschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von SlmaxAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getSlmaxAus() {
			return _slmaxAus;
		}
	
		/**
		maximale Staulnge fr die Route k Ausschaltkriterium.
		<p>
		
		</p>
		
		@param _slmaxAus der neue Wert von SlmaxAus.
		*/
		public void setSlmaxAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _slmaxAus) {
			this._slmaxAus = _slmaxAus;
		}
	
		/**
		Parameter fr die Route k Einschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von LkEin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLkEin() {
			return _lkEin;
		}
	
		/**
		Parameter fr die Route k Einschaltkriterium.
		<p>
		
		</p>
		
		@param _lkEin der neue Wert von LkEin.
		*/
		public void setLkEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _lkEin) {
			this._lkEin = _lkEin;
		}
	
		/**
		Parameter fr die Route k Ausschaltkriterium.
		<p>
		
		</p>
		
		@return der Wert von LkAus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLkAus() {
			return _lkAus;
		}
	
		/**
		Parameter fr die Route k Ausschaltkriterium.
		<p>
		
		</p>
		
		@param _lkAus der neue Wert von LkAus.
		*/
		public void setLkAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _lkAus) {
			this._lkAus = _lkAus;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getSlmaxEin() != null) {
	                if (getSlmaxEin().isZustand()) {
	                    datum.getUnscaledValue("SlmaxEin").setText(getSlmaxEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SlmaxEin").set(getSlmaxEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSlmaxAus() != null) {
	                if (getSlmaxAus().isZustand()) {
	                    datum.getUnscaledValue("SlmaxAus").setText(getSlmaxAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SlmaxAus").set(getSlmaxAus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLkEin() != null) {
	                if (getLkEin().isZustand()) {
	                    datum.getUnscaledValue("LkEin").setText(getLkEin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LkEin").set(getLkEin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLkAus() != null) {
	                if (getLkAus().isZustand()) {
	                    datum.getUnscaledValue("LkAus").setText(getLkAus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LkAus").set(getLkAus().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SlmaxEin").isState()) {
							setSlmaxEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("SlmaxEin").getText()));
						} else {
						setSlmaxEin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("SlmaxEin").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SlmaxAus").isState()) {
							setSlmaxAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("SlmaxAus").getText()));
						} else {
						setSlmaxAus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("SlmaxAus").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LkEin").isState()) {
							setLkEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("LkEin").getText()));
						} else {
						setLkEin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("LkEin").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LkAus").isState()) {
							setLkAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("LkAus").getText()));
						} else {
						setLkAus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("LkAus").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgParameterAlgorithmus6 clone() {
		AtlNbaStrgParameterAlgorithmus6 klon = new AtlNbaStrgParameterAlgorithmus6();
		
						klon.setSlmaxEin(getSlmaxEin());
						klon.setSlmaxAus(getSlmaxAus());
						klon.setLkEin(getLkEin());
						klon.setLkAus(getLkAus());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
