/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus6 pro Ursacheneinheit.
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung Algorithmus6 Ursacheneinheit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgUrsachenEinheitAlg6 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _masche
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus6
			 _parameter
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus6
			()
			;
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Masche.
		*/
			public 	Object
			 getMasche() {
			return _masche;
		}
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@param _masche der neue Wert von Masche.
		*/
		public void setMasche(	Object
		 _masche) {
			this._masche = _masche;
		}
	
		/**
		Parameter für Stufe 1 .. N für Algorithmus6.
		<p>
		
		</p>
		
		@return der Wert von Parameter.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus6
			 getParameter() {
			return _parameter;
		}
	
		/**
		Parameter für Stufe 1 .. N für Algorithmus6.
		<p>
		
		</p>
		
		@param _parameter der neue Wert von Parameter.
		*/
		public void setParameter(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgParameterAlgorithmus6
		 _parameter) {
			this._parameter = _parameter;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMasche = getMasche();
					final SystemObject tmpMasche;
						if (soMasche instanceof SystemObject) {
							tmpMasche = (SystemObject)soMasche;
						} else if(soMasche instanceof SystemObjekt){
							tmpMasche = ((SystemObjekt)soMasche).getSystemObject();
						} else{
							tmpMasche = null;
						}
					datum.getReferenceValue("Masche").setSystemObject(tmpMasche);
				// AttributListenDefinition
					getParameter().bean2Atl(datum.getItem("Parameter"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMasche = daten.getReferenceValue("Masche").getId();
					final SystemObjekt tmpMasche;
					if (idMasche == 0) {
						tmpMasche = null;
					} else {
						final SystemObject soMasche = factory.getDav().getDataModel().getObject(idMasche);
						if (soMasche == null) {
								tmpMasche = new BaseUngueltigesSystemObjekt(idMasche);
						} else {
							tmpMasche = factory.getModellobjekt(soMasche);
						}
					}
					setMasche((	Object
					) tmpMasche);
				// AttributListenDefinition
					getParameter().atl2Bean(daten.getItem("Parameter"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgUrsachenEinheitAlg6 clone() {
		AtlNbaStrgUrsachenEinheitAlg6 klon = new AtlNbaStrgUrsachenEinheitAlg6();
		
						klon.setMasche(getMasche());
						klon._parameter = getParameter().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
