/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Schaltbild Ursacheneinheit.
<p>
&lt;absatz&gt;
						Schaltbild Ursacheneinheit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaUeSchaltbild implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 _anzeige
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _notwendig
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _prioritaet
			;
			@Defaultwert(wert = "Undefiniert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaProgrammStatus
			 _programmstatus
			;
			@Defaultwert(wert = "null")
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit
			 _quelle
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
			 _schaltbild
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
			()
			;
	
		/**
		Anzeige für die Schaltbildvorgabe.
		<p>
		Beschreibung der Schaltbildvorgabe für den Status aktiv und inaktiv
		</p>
		
		@return der Wert von Anzeige.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 getAnzeige() {
			return _anzeige;
		}
	
		/**
		Anzeige für die Schaltbildvorgabe.
		<p>
		Beschreibung der Schaltbildvorgabe für den Status aktiv und inaktiv
		</p>
		
		@param _anzeige der neue Wert von Anzeige.
		*/
		public void setAnzeige(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
		 _anzeige) {
			this._anzeige = _anzeige;
		}
	
		/**
		Inhalt notwendig oder nicht.
		<p>
		
		</p>
		
		@return der Wert von Notwendig.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNotwendig() {
			return _notwendig;
		}
	
		/**
		Inhalt notwendig oder nicht.
		<p>
		
		</p>
		
		@param _notwendig der neue Wert von Notwendig.
		*/
		public void setNotwendig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _notwendig) {
			this._notwendig = _notwendig;
		}
	
		/**
		Priorität der Anzeige.
		<p>
		
		</p>
		
		@return der Wert von Prioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 getPrioritaet() {
			return _prioritaet;
		}
	
		/**
		Priorität der Anzeige.
		<p>
		
		</p>
		
		@param _prioritaet der neue Wert von Prioritaet.
		*/
		public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
		 _prioritaet) {
			this._prioritaet = _prioritaet;
		}
	
		/**
		Programmstatus der Anzeige.
		<p>
		
		</p>
		
		@return der Wert von Programmstatus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaProgrammStatus
			 getProgrammstatus() {
			return _programmstatus;
		}
	
		/**
		Programmstatus der Anzeige.
		<p>
		
		</p>
		
		@param _programmstatus der neue Wert von Programmstatus.
		*/
		public void setProgrammstatus(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaProgrammStatus
		 _programmstatus) {
			this._programmstatus = _programmstatus;
		}
	
		/**
		Referenz auf die verursachende UrsachenEinheit.
		<p>
		
		</p>
		
		@return der Wert von Quelle.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit
			 getQuelle() {
			return _quelle;
		}
	
		/**
		Referenz auf die verursachende UrsachenEinheit.
		<p>
		
		</p>
		
		@param _quelle der neue Wert von Quelle.
		*/
		public void setQuelle(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit
		 _quelle) {
			this._quelle = _quelle;
		}
	
		/**
		Schaltbild der Ursacheneinheit.
		<p>
		
		</p>
		
		@return der Wert von Schaltbild.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
			 getSchaltbild() {
			return _schaltbild;
		}
	
		/**
		Schaltbild der Ursacheneinheit.
		<p>
		
		</p>
		
		@param _schaltbild der neue Wert von Schaltbild.
		*/
		public void setSchaltbild(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
		 _schaltbild) {
			this._schaltbild = _schaltbild;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeige = getAnzeige();
					final SystemObject tmpAnzeige;
						if (soAnzeige instanceof SystemObject) {
							tmpAnzeige = (SystemObject)soAnzeige;
						} else if(soAnzeige instanceof SystemObjekt){
							tmpAnzeige = ((SystemObjekt)soAnzeige).getSystemObject();
						} else{
							tmpAnzeige = null;
						}
					datum.getReferenceValue("Anzeige").setSystemObject(tmpAnzeige);
				// GanzzahlAttributTyp
				if (getNotwendig() != null) {
	                if (getNotwendig().isZustand()) {
	                    datum.getUnscaledValue("notwendig").setText(getNotwendig().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("notwendig").set(getNotwendig().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrioritaet() != null) {
	                if (getPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Priorität").setText(getPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Priorität").set(getPrioritaet().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getProgrammstatus() != null) {
	                if (getProgrammstatus().isZustand()) {
	                    datum.getUnscaledValue("Programmstatus").setText(getProgrammstatus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Programmstatus").set(getProgrammstatus().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soQuelle = getQuelle();
					final SystemObject tmpQuelle;
						if (soQuelle instanceof SystemObject) {
							tmpQuelle = (SystemObject)soQuelle;
						} else if(soQuelle instanceof SystemObjekt){
							tmpQuelle = ((SystemObjekt)soQuelle).getSystemObject();
						} else{
							tmpQuelle = null;
						}
					datum.getReferenceValue("Quelle").setSystemObject(tmpQuelle);
				// AttributListenDefinition
					getSchaltbild().bean2Atl(datum.getItem("Schaltbild"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeige = daten.getReferenceValue("Anzeige").getId();
					final SystemObjekt tmpAnzeige;
					if (idAnzeige == 0) {
						tmpAnzeige = null;
					} else {
						final SystemObject soAnzeige = factory.getDav().getDataModel().getObject(idAnzeige);
						if (soAnzeige == null) {
								tmpAnzeige = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeige);
						} else {
							tmpAnzeige = factory.getModellobjekt(soAnzeige);
						}
					}
					setAnzeige((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
					) tmpAnzeige);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("notwendig").isState()) {
							setNotwendig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("notwendig").getText()));
						} else {
						setNotwendig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("notwendig").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Priorität").isState()) {
							setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							.getZustand(daten.getScaledValue("Priorität").getText()));
						} else {
						setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
						(daten.
							getUnscaledValue
						("Priorität").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Programmstatus").isState()) {
							setProgrammstatus(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaProgrammStatus
							.getZustand(daten.getScaledValue("Programmstatus").getText()));
						} else {
						setProgrammstatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaProgrammStatus
						(daten.
							getUnscaledValue
						("Programmstatus").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idQuelle = daten.getReferenceValue("Quelle").getId();
					final SystemObjekt tmpQuelle;
					if (idQuelle == 0) {
						tmpQuelle = null;
					} else {
						final SystemObject soQuelle = factory.getDav().getDataModel().getObject(idQuelle);
						if (soQuelle == null) {
								tmpQuelle = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaUrsachenEinheitUngueltig(idQuelle);
						} else {
							tmpQuelle = factory.getModellobjekt(soQuelle);
						}
					}
					setQuelle((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaUrsachenEinheit
					) tmpQuelle);
				// AttributListenDefinition
					getSchaltbild().atl2Bean(daten.getItem("Schaltbild"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaUeSchaltbild clone() {
		AtlNbaUeSchaltbild klon = new AtlNbaUeSchaltbild();
		
						klon.setAnzeige(getAnzeige());
						klon.setNotwendig(getNotwendig());
						klon.setPrioritaet(getPrioritaet());
						klon.setProgrammstatus(getProgrammstatus());
						klon.setQuelle(getQuelle());
						klon._schaltbild = getSchaltbild().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
