/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften Schaltbildvorgabe Ursacheneinheit.
<p>
&lt;absatz&gt;
						Eigenschaften Schaltbildvorgabe Ursacheneinheit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlNbaUeSchaltbildVorgabeEigenschaften implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _notwendig
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _prioritaet
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
			 _schaltbild
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
			()
			;
	
		/**
		Inhalt notwendig oder nicht.
		<p>
		
		</p>
		
		@return der Wert von Notwendig.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNotwendig() {
			return _notwendig;
		}
	
		/**
		Inhalt notwendig oder nicht.
		<p>
		
		</p>
		
		@param _notwendig der neue Wert von Notwendig.
		*/
		public void setNotwendig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _notwendig) {
			this._notwendig = _notwendig;
		}
	
		/**
		Priorität der Anzeige.
		<p>
		
		</p>
		
		@return der Wert von Prioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 getPrioritaet() {
			return _prioritaet;
		}
	
		/**
		Priorität der Anzeige.
		<p>
		
		</p>
		
		@param _prioritaet der neue Wert von Prioritaet.
		*/
		public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
		 _prioritaet) {
			this._prioritaet = _prioritaet;
		}
	
		/**
		Schaltbildvorgabe der Ursacheneinheit.
		<p>
		
		</p>
		
		@return der Wert von Schaltbild.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
			 getSchaltbild() {
			return _schaltbild;
		}
	
		/**
		Schaltbildvorgabe der Ursacheneinheit.
		<p>
		
		</p>
		
		@param _schaltbild der neue Wert von Schaltbild.
		*/
		public void setSchaltbild(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaAnzeigeEigenschaft
		 _schaltbild) {
			this._schaltbild = _schaltbild;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getNotwendig() != null) {
	                if (getNotwendig().isZustand()) {
	                    datum.getUnscaledValue("notwendig").setText(getNotwendig().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("notwendig").set(getNotwendig().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrioritaet() != null) {
	                if (getPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Priorität").setText(getPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Priorität").set(getPrioritaet().getValue());
	                }
				}
				// AttributListenDefinition
					getSchaltbild().bean2Atl(datum.getItem("Schaltbild"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("notwendig").isState()) {
							setNotwendig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("notwendig").getText()));
						} else {
						setNotwendig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("notwendig").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Priorität").isState()) {
							setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							.getZustand(daten.getScaledValue("Priorität").getText()));
						} else {
						setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
						(daten.
							getUnscaledValue
						("Priorität").
								intValue
						()));
						}
				// AttributListenDefinition
					getSchaltbild().atl2Bean(daten.getItem("Schaltbild"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaUeSchaltbildVorgabeEigenschaften clone() {
		AtlNbaUeSchaltbildVorgabeEigenschaften klon = new AtlNbaUeSchaltbildVorgabeEigenschaften();
		
						klon.setNotwendig(getNotwendig());
						klon.setPrioritaet(getPrioritaet());
						klon._schaltbild = getSchaltbild().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
