/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition Attributliste nbaUmfeld.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von Umfeldbedingungen
						zu Umfelddatensensoren.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaUmfeld implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaUmfeldbedingungen
			 _datenart
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
			 _sensorReferenz
			;
	
		/**
		Art der Umfeldbedingung.
		<p>
		
		</p>
		
		@return der Wert von Datenart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaUmfeldbedingungen
			 getDatenart() {
			return _datenart;
		}
	
		/**
		Art der Umfeldbedingung.
		<p>
		
		</p>
		
		@param _datenart der neue Wert von Datenart.
		*/
		public void setDatenart(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaUmfeldbedingungen
		 _datenart) {
			this._datenart = _datenart;
		}
	
		/**
		Referenz auf einen Umfelddatensensor.
		<p>
		
		</p>
		
		@return der Wert von SensorReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
			 getSensorReferenz() {
			return _sensorReferenz;
		}
	
		/**
		Referenz auf einen Umfelddatensensor.
		<p>
		
		</p>
		
		@param _sensorReferenz der neue Wert von SensorReferenz.
		*/
		public void setSensorReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
		 _sensorReferenz) {
			this._sensorReferenz = _sensorReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getDatenart() != null) {
	                if (getDatenart().isZustand()) {
	                    datum.getUnscaledValue("Datenart").setText(getDatenart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Datenart").set(getDatenart().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soSensorReferenz = getSensorReferenz();
					final SystemObject tmpSensorReferenz;
						if (soSensorReferenz instanceof SystemObject) {
							tmpSensorReferenz = (SystemObject)soSensorReferenz;
						} else if(soSensorReferenz instanceof SystemObjekt){
							tmpSensorReferenz = ((SystemObjekt)soSensorReferenz).getSystemObject();
						} else{
							tmpSensorReferenz = null;
						}
					datum.getReferenceValue("SensorReferenz").setSystemObject(tmpSensorReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Datenart").isState()) {
							setDatenart(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaUmfeldbedingungen
							.getZustand(daten.getScaledValue("Datenart").getText()));
						} else {
						setDatenart(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaUmfeldbedingungen
						(daten.
							getUnscaledValue
						("Datenart").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idSensorReferenz = daten.getReferenceValue("SensorReferenz").getId();
					final SystemObjekt tmpSensorReferenz;
					if (idSensorReferenz == 0) {
						tmpSensorReferenz = null;
					} else {
						final SystemObject soSensorReferenz = factory.getDav().getDataModel().getObject(idSensorReferenz);
						if (soSensorReferenz == null) {
								tmpSensorReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UmfeldDatenSensorUngueltig(idSensorReferenz);
						} else {
							tmpSensorReferenz = factory.getModellobjekt(soSensorReferenz);
						}
					}
					setSensorReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
					) tmpSensorReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaUmfeld clone() {
		AtlNbaUmfeld klon = new AtlNbaUmfeld();
		
						klon.setDatenart(getDatenart());
						klon.setSensorReferenz(getSensorReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
