/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition Attributliste nbaUmfeldMq.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von Umfeldbedingungen
						zu Umfelddatensensoren MQ spezifisch.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaUmfeldMq implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUmfeld
			> _umfeld = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUmfeld
			>(0, true);
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnittReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 getMessQuerschnittReferenz() {
			return _messQuerschnittReferenz;
		}
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@param _messQuerschnittReferenz der neue Wert von MessQuerschnittReferenz.
		*/
		public void setMessQuerschnittReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
		 _messQuerschnittReferenz) {
			this._messQuerschnittReferenz = _messQuerschnittReferenz;
		}
	
		/**
		Definition einer Zuordnung Umfelddatenart zu Umfeldsensor
						    MQ spezifisch.
		<p>
		
		</p>
		
		@return der Wert von Umfeld.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUmfeld
			> getUmfeld() {
			return _umfeld;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnittReferenz = getMessQuerschnittReferenz();
					final SystemObject tmpMessQuerschnittReferenz;
						if (soMessQuerschnittReferenz instanceof SystemObject) {
							tmpMessQuerschnittReferenz = (SystemObject)soMessQuerschnittReferenz;
						} else if(soMessQuerschnittReferenz instanceof SystemObjekt){
							tmpMessQuerschnittReferenz = ((SystemObjekt)soMessQuerschnittReferenz).getSystemObject();
						} else{
							tmpMessQuerschnittReferenz = null;
						}
					datum.getReferenceValue("MessQuerschnittReferenz").setSystemObject(tmpMessQuerschnittReferenz);
				// AttributListenDefinition
					final Data.Array arrayUmfeld = datum.getArray("Umfeld");
					arrayUmfeld.setLength(getUmfeld().size());
					for (int i = 0; i < arrayUmfeld.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUmfeld
						 atl = getUmfeld().get(i);
						atl.bean2Atl(arrayUmfeld.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnittReferenz = daten.getReferenceValue("MessQuerschnittReferenz").getId();
					final SystemObjekt tmpMessQuerschnittReferenz;
					if (idMessQuerschnittReferenz == 0) {
						tmpMessQuerschnittReferenz = null;
					} else {
						final SystemObject soMessQuerschnittReferenz = factory.getDav().getDataModel().getObject(idMessQuerschnittReferenz);
						if (soMessQuerschnittReferenz == null) {
								tmpMessQuerschnittReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittReferenz);
						} else {
							tmpMessQuerschnittReferenz = factory.getModellobjekt(soMessQuerschnittReferenz);
						}
					}
					setMessQuerschnittReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
					) tmpMessQuerschnittReferenz);
				// AttributListenDefinition
					final Data.Array arrayUmfeld = daten.getArray("Umfeld");
					for (int i = 0; i < arrayUmfeld.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUmfeld
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaUmfeld
						 ();
						atl.atl2Bean(arrayUmfeld.getItem(i), factory);
						getUmfeld().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaUmfeldMq clone() {
		AtlNbaUmfeldMq klon = new AtlNbaUmfeldMq();
		
						klon.setMessQuerschnittReferenz(getMessQuerschnittReferenz());
					klon._umfeld = getUmfeld().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
