/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste für die Verkehrszustandsermittlung.
<p>
&lt;absatz&gt;
						???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaVerkehrszustandAlgorithmus1 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
			 _vertrauenswuerdigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _zugehoerigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _freierVerkehr
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _dichterVerkehr
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _zaehfliessend
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _stau
			;
	
		/**
		Vertrauenswürdigkeit.
		<p>
		
		</p>
		
		@return der Wert von Vertrauenswuerdigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
			 getVertrauenswuerdigkeit() {
			return _vertrauenswuerdigkeit;
		}
	
		/**
		Vertrauenswürdigkeit.
		<p>
		
		</p>
		
		@param _vertrauenswuerdigkeit der neue Wert von Vertrauenswuerdigkeit.
		*/
		public void setVertrauenswuerdigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
		 _vertrauenswuerdigkeit) {
			this._vertrauenswuerdigkeit = _vertrauenswuerdigkeit;
		}
	
		/**
		Zugehörigkeit.
		<p>
		
		</p>
		
		@return der Wert von Zugehoerigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getZugehoerigkeit() {
			return _zugehoerigkeit;
		}
	
		/**
		Zugehörigkeit.
		<p>
		
		</p>
		
		@param _zugehoerigkeit der neue Wert von Zugehoerigkeit.
		*/
		public void setZugehoerigkeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _zugehoerigkeit) {
			this._zugehoerigkeit = _zugehoerigkeit;
		}
	
		/**
		Verkehrszustandsklasse freier Verkehr.
		<p>
		
		</p>
		
		@return der Wert von FreierVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getFreierVerkehr() {
			return _freierVerkehr;
		}
	
		/**
		Verkehrszustandsklasse freier Verkehr.
		<p>
		
		</p>
		
		@param _freierVerkehr der neue Wert von FreierVerkehr.
		*/
		public void setFreierVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _freierVerkehr) {
			this._freierVerkehr = _freierVerkehr;
		}
	
		/**
		Verkehrszustandsklasse dichter Verkehr.
		<p>
		
		</p>
		
		@return der Wert von DichterVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getDichterVerkehr() {
			return _dichterVerkehr;
		}
	
		/**
		Verkehrszustandsklasse dichter Verkehr.
		<p>
		
		</p>
		
		@param _dichterVerkehr der neue Wert von DichterVerkehr.
		*/
		public void setDichterVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _dichterVerkehr) {
			this._dichterVerkehr = _dichterVerkehr;
		}
	
		/**
		Verkehrszustandsklasse zähfließender Verkehr.
		<p>
		
		</p>
		
		@return der Wert von Zaehfliessend.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getZaehfliessend() {
			return _zaehfliessend;
		}
	
		/**
		Verkehrszustandsklasse zähfließender Verkehr.
		<p>
		
		</p>
		
		@param _zaehfliessend der neue Wert von Zaehfliessend.
		*/
		public void setZaehfliessend(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _zaehfliessend) {
			this._zaehfliessend = _zaehfliessend;
		}
	
		/**
		Verkehrszustandsklasse Stau.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getStau() {
			return _stau;
		}
	
		/**
		Verkehrszustandsklasse Stau.
		<p>
		
		</p>
		
		@param _stau der neue Wert von Stau.
		*/
		public void setStau(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _stau) {
			this._stau = _stau;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVertrauenswuerdigkeit() != null) {
	                if (getVertrauenswuerdigkeit().isZustand()) {
	                    datum.getUnscaledValue("Vertrauenswürdigkeit").setText(getVertrauenswuerdigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Vertrauenswürdigkeit").set(getVertrauenswuerdigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZugehoerigkeit() != null) {
	                if (getZugehoerigkeit().isZustand()) {
	                    datum.getUnscaledValue("Zugehörigkeit").setText(getZugehoerigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Zugehörigkeit").set(getZugehoerigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFreierVerkehr() != null) {
	                if (getFreierVerkehr().isZustand()) {
	                    datum.getUnscaledValue("freierVerkehr").setText(getFreierVerkehr().toString());
	                } else {
						datum.
						getScaledValue
	                	("freierVerkehr").set(getFreierVerkehr().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDichterVerkehr() != null) {
	                if (getDichterVerkehr().isZustand()) {
	                    datum.getUnscaledValue("dichterVerkehr").setText(getDichterVerkehr().toString());
	                } else {
						datum.
						getScaledValue
	                	("dichterVerkehr").set(getDichterVerkehr().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZaehfliessend() != null) {
	                if (getZaehfliessend().isZustand()) {
	                    datum.getUnscaledValue("zähfließend").setText(getZaehfliessend().toString());
	                } else {
						datum.
						getScaledValue
	                	("zähfließend").set(getZaehfliessend().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStau() != null) {
	                if (getStau().isZustand()) {
	                    datum.getUnscaledValue("stau").setText(getStau().toString());
	                } else {
						datum.
						getScaledValue
	                	("stau").set(getStau().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vertrauenswürdigkeit").isState()) {
							setVertrauenswuerdigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
							.getZustand(daten.getScaledValue("Vertrauenswürdigkeit").getText()));
						} else {
						setVertrauenswuerdigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
						(daten.
							getScaledValue
						("Vertrauenswürdigkeit").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						setZugehoerigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("Zugehörigkeit").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFreierVerkehr(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("freierVerkehr").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setDichterVerkehr(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("dichterVerkehr").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setZaehfliessend(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("zähfließend").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setStau(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("stau").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaVerkehrszustandAlgorithmus1 clone() {
		AtlNbaVerkehrszustandAlgorithmus1 klon = new AtlNbaVerkehrszustandAlgorithmus1();
		
						klon.setVertrauenswuerdigkeit(getVertrauenswuerdigkeit());
						klon.setZugehoerigkeit(getZugehoerigkeit());
						klon.setFreierVerkehr(getFreierVerkehr());
						klon.setDichterVerkehr(getDichterVerkehr());
						klon.setZaehfliessend(getZaehfliessend());
						klon.setStau(getStau());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
