/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste für die Verkehrszustandsermittlung.
<p>
&lt;absatz&gt;
						???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class AtlNbaVerkehrszustandAlgorithmus2 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
			 _vertrauenswuerdigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _zugehoerigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _stabil
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _instabil
			;
	
		/**
		Vertrauenswürdigkeit.
		<p>
		
		</p>
		
		@return der Wert von Vertrauenswuerdigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
			 getVertrauenswuerdigkeit() {
			return _vertrauenswuerdigkeit;
		}
	
		/**
		Vertrauenswürdigkeit.
		<p>
		
		</p>
		
		@param _vertrauenswuerdigkeit der neue Wert von Vertrauenswuerdigkeit.
		*/
		public void setVertrauenswuerdigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
		 _vertrauenswuerdigkeit) {
			this._vertrauenswuerdigkeit = _vertrauenswuerdigkeit;
		}
	
		/**
		Zugehörigkeit.
		<p>
		
		</p>
		
		@return der Wert von Zugehoerigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getZugehoerigkeit() {
			return _zugehoerigkeit;
		}
	
		/**
		Zugehörigkeit.
		<p>
		
		</p>
		
		@param _zugehoerigkeit der neue Wert von Zugehoerigkeit.
		*/
		public void setZugehoerigkeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _zugehoerigkeit) {
			this._zugehoerigkeit = _zugehoerigkeit;
		}
	
		/**
		Verkehrszustandsklasse stabil.
		<p>
		
		</p>
		
		@return der Wert von Stabil.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getStabil() {
			return _stabil;
		}
	
		/**
		Verkehrszustandsklasse stabil.
		<p>
		
		</p>
		
		@param _stabil der neue Wert von Stabil.
		*/
		public void setStabil(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _stabil) {
			this._stabil = _stabil;
		}
	
		/**
		Verkehrszustandsklasse instabil.
		<p>
		
		</p>
		
		@return der Wert von Instabil.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getInstabil() {
			return _instabil;
		}
	
		/**
		Verkehrszustandsklasse instabil.
		<p>
		
		</p>
		
		@param _instabil der neue Wert von Instabil.
		*/
		public void setInstabil(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _instabil) {
			this._instabil = _instabil;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVertrauenswuerdigkeit() != null) {
	                if (getVertrauenswuerdigkeit().isZustand()) {
	                    datum.getUnscaledValue("Vertrauenswürdigkeit").setText(getVertrauenswuerdigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Vertrauenswürdigkeit").set(getVertrauenswuerdigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZugehoerigkeit() != null) {
	                if (getZugehoerigkeit().isZustand()) {
	                    datum.getUnscaledValue("Zugehörigkeit").setText(getZugehoerigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Zugehörigkeit").set(getZugehoerigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStabil() != null) {
	                if (getStabil().isZustand()) {
	                    datum.getUnscaledValue("stabil").setText(getStabil().toString());
	                } else {
						datum.
						getScaledValue
	                	("stabil").set(getStabil().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getInstabil() != null) {
	                if (getInstabil().isZustand()) {
	                    datum.getUnscaledValue("instabil").setText(getInstabil().toString());
	                } else {
						datum.
						getScaledValue
	                	("instabil").set(getInstabil().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vertrauenswürdigkeit").isState()) {
							setVertrauenswuerdigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
							.getZustand(daten.getScaledValue("Vertrauenswürdigkeit").getText()));
						} else {
						setVertrauenswuerdigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
						(daten.
							getScaledValue
						("Vertrauenswürdigkeit").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						setZugehoerigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("Zugehörigkeit").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setStabil(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("stabil").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setInstabil(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("instabil").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaVerkehrszustandAlgorithmus2 clone() {
		AtlNbaVerkehrszustandAlgorithmus2 klon = new AtlNbaVerkehrszustandAlgorithmus2();
		
						klon.setVertrauenswuerdigkeit(getVertrauenswuerdigkeit());
						klon.setZugehoerigkeit(getZugehoerigkeit());
						klon.setStabil(getStabil());
						klon.setInstabil(getInstabil());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
