/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste für die Verkehrszustandsermittlung.
<p>
&lt;absatz&gt;
						???
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaVerkehrszustandAlgorithmus3 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
			 _vertrauenswuerdigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _zugehoerigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _guete
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _stauUnfall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _stau
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _zaehfliessendUnfall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _zaehfliessend
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _dichtUnfall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _dicht
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _freiUnfall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _frei
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _keineMeldung
			;
	
		/**
		Vertrauenswürdigkeit.
		<p>
		
		</p>
		
		@return der Wert von Vertrauenswuerdigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
			 getVertrauenswuerdigkeit() {
			return _vertrauenswuerdigkeit;
		}
	
		/**
		Vertrauenswürdigkeit.
		<p>
		
		</p>
		
		@param _vertrauenswuerdigkeit der neue Wert von Vertrauenswuerdigkeit.
		*/
		public void setVertrauenswuerdigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
		 _vertrauenswuerdigkeit) {
			this._vertrauenswuerdigkeit = _vertrauenswuerdigkeit;
		}
	
		/**
		Zugehörigkeit.
		<p>
		
		</p>
		
		@return der Wert von Zugehoerigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getZugehoerigkeit() {
			return _zugehoerigkeit;
		}
	
		/**
		Zugehörigkeit.
		<p>
		
		</p>
		
		@param _zugehoerigkeit der neue Wert von Zugehoerigkeit.
		*/
		public void setZugehoerigkeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _zugehoerigkeit) {
			this._zugehoerigkeit = _zugehoerigkeit;
		}
	
		/**
		Güte.
		<p>
		
		</p>
		
		@return der Wert von Guete.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 getGuete() {
			return _guete;
		}
	
		/**
		Güte.
		<p>
		
		</p>
		
		@param _guete der neue Wert von Guete.
		*/
		public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
		 _guete) {
			this._guete = _guete;
		}
	
		/**
		TMC-Verkehrszustand StauUnfall.
		<p>
		
		</p>
		
		@return der Wert von StauUnfall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getStauUnfall() {
			return _stauUnfall;
		}
	
		/**
		TMC-Verkehrszustand StauUnfall.
		<p>
		
		</p>
		
		@param _stauUnfall der neue Wert von StauUnfall.
		*/
		public void setStauUnfall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _stauUnfall) {
			this._stauUnfall = _stauUnfall;
		}
	
		/**
		TMC-Verkehrszustand Stau.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getStau() {
			return _stau;
		}
	
		/**
		TMC-Verkehrszustand Stau.
		<p>
		
		</p>
		
		@param _stau der neue Wert von Stau.
		*/
		public void setStau(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _stau) {
			this._stau = _stau;
		}
	
		/**
		TMC-Verkehrszustand ZähfließendUnfall.
		<p>
		
		</p>
		
		@return der Wert von ZaehfliessendUnfall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getZaehfliessendUnfall() {
			return _zaehfliessendUnfall;
		}
	
		/**
		TMC-Verkehrszustand ZähfließendUnfall.
		<p>
		
		</p>
		
		@param _zaehfliessendUnfall der neue Wert von ZaehfliessendUnfall.
		*/
		public void setZaehfliessendUnfall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _zaehfliessendUnfall) {
			this._zaehfliessendUnfall = _zaehfliessendUnfall;
		}
	
		/**
		TMC-Verkehrszustand Zähfließend.
		<p>
		
		</p>
		
		@return der Wert von Zaehfliessend.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getZaehfliessend() {
			return _zaehfliessend;
		}
	
		/**
		TMC-Verkehrszustand Zähfließend.
		<p>
		
		</p>
		
		@param _zaehfliessend der neue Wert von Zaehfliessend.
		*/
		public void setZaehfliessend(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _zaehfliessend) {
			this._zaehfliessend = _zaehfliessend;
		}
	
		/**
		TMC-Verkehrszustand DichtUnfall.
		<p>
		
		</p>
		
		@return der Wert von DichtUnfall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getDichtUnfall() {
			return _dichtUnfall;
		}
	
		/**
		TMC-Verkehrszustand DichtUnfall.
		<p>
		
		</p>
		
		@param _dichtUnfall der neue Wert von DichtUnfall.
		*/
		public void setDichtUnfall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _dichtUnfall) {
			this._dichtUnfall = _dichtUnfall;
		}
	
		/**
		TMC-Verkehrszustand Dicht.
		<p>
		
		</p>
		
		@return der Wert von Dicht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getDicht() {
			return _dicht;
		}
	
		/**
		TMC-Verkehrszustand Dicht.
		<p>
		
		</p>
		
		@param _dicht der neue Wert von Dicht.
		*/
		public void setDicht(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _dicht) {
			this._dicht = _dicht;
		}
	
		/**
		TMC-Verkehrszustand FreiUnfall.
		<p>
		
		</p>
		
		@return der Wert von FreiUnfall.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getFreiUnfall() {
			return _freiUnfall;
		}
	
		/**
		TMC-Verkehrszustand FreiUnfall.
		<p>
		
		</p>
		
		@param _freiUnfall der neue Wert von FreiUnfall.
		*/
		public void setFreiUnfall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _freiUnfall) {
			this._freiUnfall = _freiUnfall;
		}
	
		/**
		TMC-Verkehrszustand Frei.
		<p>
		
		</p>
		
		@return der Wert von Frei.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getFrei() {
			return _frei;
		}
	
		/**
		TMC-Verkehrszustand Frei.
		<p>
		
		</p>
		
		@param _frei der neue Wert von Frei.
		*/
		public void setFrei(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _frei) {
			this._frei = _frei;
		}
	
		/**
		TMC-Verkehrszustand keine Meldung.
		<p>
		
		</p>
		
		@return der Wert von KeineMeldung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getKeineMeldung() {
			return _keineMeldung;
		}
	
		/**
		TMC-Verkehrszustand keine Meldung.
		<p>
		
		</p>
		
		@param _keineMeldung der neue Wert von KeineMeldung.
		*/
		public void setKeineMeldung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _keineMeldung) {
			this._keineMeldung = _keineMeldung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVertrauenswuerdigkeit() != null) {
	                if (getVertrauenswuerdigkeit().isZustand()) {
	                    datum.getUnscaledValue("Vertrauenswürdigkeit").setText(getVertrauenswuerdigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Vertrauenswürdigkeit").set(getVertrauenswuerdigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZugehoerigkeit() != null) {
	                if (getZugehoerigkeit().isZustand()) {
	                    datum.getUnscaledValue("Zugehörigkeit").setText(getZugehoerigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Zugehörigkeit").set(getZugehoerigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGuete() != null) {
	                if (getGuete().isZustand()) {
	                    datum.getUnscaledValue("Güte").setText(getGuete().toString());
	                } else {
						datum.
						getScaledValue
	                	("Güte").set(getGuete().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStauUnfall() != null) {
	                if (getStauUnfall().isZustand()) {
	                    datum.getUnscaledValue("stauUnfall").setText(getStauUnfall().toString());
	                } else {
						datum.
						getScaledValue
	                	("stauUnfall").set(getStauUnfall().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStau() != null) {
	                if (getStau().isZustand()) {
	                    datum.getUnscaledValue("stau").setText(getStau().toString());
	                } else {
						datum.
						getScaledValue
	                	("stau").set(getStau().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZaehfliessendUnfall() != null) {
	                if (getZaehfliessendUnfall().isZustand()) {
	                    datum.getUnscaledValue("zähfließendUnfall").setText(getZaehfliessendUnfall().toString());
	                } else {
						datum.
						getScaledValue
	                	("zähfließendUnfall").set(getZaehfliessendUnfall().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZaehfliessend() != null) {
	                if (getZaehfliessend().isZustand()) {
	                    datum.getUnscaledValue("zähfließend").setText(getZaehfliessend().toString());
	                } else {
						datum.
						getScaledValue
	                	("zähfließend").set(getZaehfliessend().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDichtUnfall() != null) {
	                if (getDichtUnfall().isZustand()) {
	                    datum.getUnscaledValue("dichtUnfall").setText(getDichtUnfall().toString());
	                } else {
						datum.
						getScaledValue
	                	("dichtUnfall").set(getDichtUnfall().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDicht() != null) {
	                if (getDicht().isZustand()) {
	                    datum.getUnscaledValue("dicht").setText(getDicht().toString());
	                } else {
						datum.
						getScaledValue
	                	("dicht").set(getDicht().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFreiUnfall() != null) {
	                if (getFreiUnfall().isZustand()) {
	                    datum.getUnscaledValue("freiUnfall").setText(getFreiUnfall().toString());
	                } else {
						datum.
						getScaledValue
	                	("freiUnfall").set(getFreiUnfall().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFrei() != null) {
	                if (getFrei().isZustand()) {
	                    datum.getUnscaledValue("frei").setText(getFrei().toString());
	                } else {
						datum.
						getScaledValue
	                	("frei").set(getFrei().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKeineMeldung() != null) {
	                if (getKeineMeldung().isZustand()) {
	                    datum.getUnscaledValue("keineMeldung").setText(getKeineMeldung().toString());
	                } else {
						datum.
						getScaledValue
	                	("keineMeldung").set(getKeineMeldung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vertrauenswürdigkeit").isState()) {
							setVertrauenswuerdigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
							.getZustand(daten.getScaledValue("Vertrauenswürdigkeit").getText()));
						} else {
						setVertrauenswuerdigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaVertrauenswuerdigkeit
						(daten.
							getScaledValue
						("Vertrauenswürdigkeit").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						setZugehoerigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("Zugehörigkeit").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Güte").isState()) {
							setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							.getZustand(daten.getScaledValue("Güte").getText()));
						} else {
						setGuete(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
						(daten.
							getScaledValue
						("Güte").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						setStauUnfall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("stauUnfall").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setStau(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("stau").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setZaehfliessendUnfall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("zähfließendUnfall").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setZaehfliessend(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("zähfließend").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setDichtUnfall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("dichtUnfall").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setDicht(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("dicht").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFreiUnfall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("freiUnfall").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setFrei(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("frei").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setKeineMeldung(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("keineMeldung").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaVerkehrszustandAlgorithmus3 clone() {
		AtlNbaVerkehrszustandAlgorithmus3 klon = new AtlNbaVerkehrszustandAlgorithmus3();
		
						klon.setVertrauenswuerdigkeit(getVertrauenswuerdigkeit());
						klon.setZugehoerigkeit(getZugehoerigkeit());
						klon.setGuete(getGuete());
						klon.setStauUnfall(getStauUnfall());
						klon.setStau(getStau());
						klon.setZaehfliessendUnfall(getZaehfliessendUnfall());
						klon.setZaehfliessend(getZaehfliessend());
						klon.setDichtUnfall(getDichtUnfall());
						klon.setDicht(getDicht());
						klon.setFreiUnfall(getFreiUnfall());
						klon.setFrei(getFrei());
						klon.setKeineMeldung(getKeineMeldung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
