/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Auf dem Routenstück verwendeter MessQuerschnitt mit räumlicher Ausdehung.
<p>
&lt;absatz&gt;
						Auf dem Routenstück verwendeter MessQuerschnitt mit räumlicher Ausdehung.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class AtlNbaVerwendeteMessQuerschnitteMitAusdehnung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _verwendeterMessQuerschnitt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengeDerAusdehnung
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
			> _strassenSegment = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _startOffset
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _endOffset
			;
	
		/**
		Referenz auf MessQuerschnitt.
		<p>
		
		</p>
		
		@return der Wert von VerwendeterMessQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getVerwendeterMessQuerschnitt() {
			return _verwendeterMessQuerschnitt;
		}
	
		/**
		Referenz auf MessQuerschnitt.
		<p>
		
		</p>
		
		@param _verwendeterMessQuerschnitt der neue Wert von VerwendeterMessQuerschnitt.
		*/
		public void setVerwendeterMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _verwendeterMessQuerschnitt) {
			this._verwendeterMessQuerschnitt = _verwendeterMessQuerschnitt;
		}
	
		/**
		Berechnete Länge der Ausdehnung um den MessQuerschnitt.
		<p>
		
		</p>
		
		@return der Wert von LaengeDerAusdehnung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaengeDerAusdehnung() {
			return _laengeDerAusdehnung;
		}
	
		/**
		Berechnete Länge der Ausdehnung um den MessQuerschnitt.
		<p>
		
		</p>
		
		@param _laengeDerAusdehnung der neue Wert von LaengeDerAusdehnung.
		*/
		public void setLaengeDerAusdehnung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laengeDerAusdehnung) {
			this._laengeDerAusdehnung = _laengeDerAusdehnung;
		}
	
		/**
		Referenzen auf alle Straßensegmente, die der MessQuerschnitt abdeckt.
		<p>
		
		</p>
		
		@return der Wert von StrassenSegment.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
			> getStrassenSegment() {
			return _strassenSegment;
		}
	
	
		/**
		Position des Anfangs im ersten Straßensegment.
		<p>
		
		</p>
		
		@return der Wert von StartOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStartOffset() {
			return _startOffset;
		}
	
		/**
		Position des Anfangs im ersten Straßensegment.
		<p>
		
		</p>
		
		@param _startOffset der neue Wert von StartOffset.
		*/
		public void setStartOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _startOffset) {
			this._startOffset = _startOffset;
		}
	
		/**
		Position des Endes im letzten Straßensegment.
		<p>
		
		</p>
		
		@return der Wert von EndOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getEndOffset() {
			return _endOffset;
		}
	
		/**
		Position des Endes im letzten Straßensegment.
		<p>
		
		</p>
		
		@param _endOffset der neue Wert von EndOffset.
		*/
		public void setEndOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _endOffset) {
			this._endOffset = _endOffset;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soVerwendeterMessQuerschnitt = getVerwendeterMessQuerschnitt();
					final SystemObject tmpVerwendeterMessQuerschnitt;
						if (soVerwendeterMessQuerschnitt instanceof SystemObject) {
							tmpVerwendeterMessQuerschnitt = (SystemObject)soVerwendeterMessQuerschnitt;
						} else if(soVerwendeterMessQuerschnitt instanceof SystemObjekt){
							tmpVerwendeterMessQuerschnitt = ((SystemObjekt)soVerwendeterMessQuerschnitt).getSystemObject();
						} else{
							tmpVerwendeterMessQuerschnitt = null;
						}
					datum.getReferenceValue("VerwendeterMessQuerschnitt").setSystemObject(tmpVerwendeterMessQuerschnitt);
				// GanzzahlAttributTyp
				if (getLaengeDerAusdehnung() != null) {
	                if (getLaengeDerAusdehnung().isZustand()) {
	                    datum.getUnscaledValue("LängeDerAusdehnung").setText(getLaengeDerAusdehnung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LängeDerAusdehnung").set(getLaengeDerAusdehnung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayStrassenSegment = datum.getReferenceArray("StraßenSegment");
					arrayStrassenSegment.setLength(getStrassenSegment().size());
					for (int i = 0; i < arrayStrassenSegment.getLength(); ++i) {
						final Object soStrassenSegment = getStrassenSegment().get(i);
						final SystemObject tmpStrassenSegment;
						if (soStrassenSegment instanceof SystemObject) {
							tmpStrassenSegment = (SystemObject)soStrassenSegment;
						} else if(soStrassenSegment instanceof SystemObjekt){
							tmpStrassenSegment = ((SystemObjekt)soStrassenSegment).getSystemObject();
						} else{
							tmpStrassenSegment = null;
						}
						arrayStrassenSegment.getReferenceValue(i).setSystemObject(tmpStrassenSegment);
					}
				// GanzzahlAttributTyp
				if (getStartOffset() != null) {
	                if (getStartOffset().isZustand()) {
	                    datum.getUnscaledValue("StartOffset").setText(getStartOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StartOffset").set(getStartOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEndOffset() != null) {
	                if (getEndOffset().isZustand()) {
	                    datum.getUnscaledValue("EndOffset").setText(getEndOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EndOffset").set(getEndOffset().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idVerwendeterMessQuerschnitt = daten.getReferenceValue("VerwendeterMessQuerschnitt").getId();
					final SystemObjekt tmpVerwendeterMessQuerschnitt;
					if (idVerwendeterMessQuerschnitt == 0) {
						tmpVerwendeterMessQuerschnitt = null;
					} else {
						final SystemObject soVerwendeterMessQuerschnitt = factory.getDav().getDataModel().getObject(idVerwendeterMessQuerschnitt);
						if (soVerwendeterMessQuerschnitt == null) {
								tmpVerwendeterMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idVerwendeterMessQuerschnitt);
						} else {
							tmpVerwendeterMessQuerschnitt = factory.getModellobjekt(soVerwendeterMessQuerschnitt);
						}
					}
					setVerwendeterMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpVerwendeterMessQuerschnitt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LängeDerAusdehnung").isState()) {
							setLaengeDerAusdehnung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("LängeDerAusdehnung").getText()));
						} else {
						setLaengeDerAusdehnung(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("LängeDerAusdehnung").
								longValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayStrassenSegment = daten.getReferenceArray("StraßenSegment");
					for (int i = 0; i < arrayStrassenSegment.getLength(); ++i) {
						final long idStrassenSegment = daten.getReferenceArray("StraßenSegment").getReferenceValue(i).getId();
						final SystemObjekt tmpStrassenSegment;
						if (idStrassenSegment == 0) {
							tmpStrassenSegment = null;
						} else {
							final SystemObject soStrassenSegment = factory.getDav().getDataModel().getObject(idStrassenSegment);
							if (soStrassenSegment == null) {
									tmpStrassenSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenSegmentUngueltig(idStrassenSegment);
							} else {
								tmpStrassenSegment = factory.getModellobjekt(soStrassenSegment);
							}
						}
							getStrassenSegment().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment
							) tmpStrassenSegment);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StartOffset").isState()) {
							setStartOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("StartOffset").getText()));
						} else {
						setStartOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("StartOffset").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EndOffset").isState()) {
							setEndOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("EndOffset").getText()));
						} else {
						setEndOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("EndOffset").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaVerwendeteMessQuerschnitteMitAusdehnung clone() {
		AtlNbaVerwendeteMessQuerschnitteMitAusdehnung klon = new AtlNbaVerwendeteMessQuerschnitteMitAusdehnung();
		
						klon.setVerwendeterMessQuerschnitt(getVerwendeterMessQuerschnitt());
						klon.setLaengeDerAusdehnung(getLaengeDerAusdehnung());
					klon._strassenSegment = getStrassenSegment().clone();
						klon.setStartOffset(getStartOffset());
						klon.setEndOffset(getEndOffset());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
