/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu einer Route von einem EntscheidungsPunkt zu einem Ziel.
<p>
&lt;absatz&gt;
						Informationen zu einer Route von einem EntscheidungsPunkt zu einem Ziel.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaZielEntscheidungspunktRoutenRoute implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			> _routenStueck = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			>(0, true);
	
		/**
		Nummer der Route in der Routenliste.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Nummer der Route in der Routenliste.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		RoutenStück der Route.
		<p>
		
		</p>
		
		@return der Wert von RoutenStueck.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
			> getRoutenStueck() {
			return _routenStueck;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRoutenStueck = datum.getReferenceArray("RoutenStück");
					arrayRoutenStueck.setLength(getRoutenStueck().size());
					for (int i = 0; i < arrayRoutenStueck.getLength(); ++i) {
						final Object soRoutenStueck = getRoutenStueck().get(i);
						final SystemObject tmpRoutenStueck;
						if (soRoutenStueck instanceof SystemObject) {
							tmpRoutenStueck = (SystemObject)soRoutenStueck;
						} else if(soRoutenStueck instanceof SystemObjekt){
							tmpRoutenStueck = ((SystemObjekt)soRoutenStueck).getSystemObject();
						} else{
							tmpRoutenStueck = null;
						}
						arrayRoutenStueck.getReferenceValue(i).setSystemObject(tmpRoutenStueck);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRoutenStueck = daten.getReferenceArray("RoutenStück");
					for (int i = 0; i < arrayRoutenStueck.getLength(); ++i) {
						final long idRoutenStueck = daten.getReferenceArray("RoutenStück").getReferenceValue(i).getId();
						final SystemObjekt tmpRoutenStueck;
						if (idRoutenStueck == 0) {
							tmpRoutenStueck = null;
						} else {
							final SystemObject soRoutenStueck = factory.getDav().getDataModel().getObject(idRoutenStueck);
							if (soRoutenStueck == null) {
									tmpRoutenStueck = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.RoutenStueckUngueltig(idRoutenStueck);
							} else {
								tmpRoutenStueck = factory.getModellobjekt(soRoutenStueck);
							}
						}
							getRoutenStueck().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.RoutenStueck
							) tmpRoutenStueck);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielEntscheidungspunktRoutenRoute clone() {
		AtlNbaZielEntscheidungspunktRoutenRoute klon = new AtlNbaZielEntscheidungspunktRoutenRoute();
		
						klon.setName(getName());
					klon._routenStueck = getRoutenStueck().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
