/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelner Reisezeit-Prognose-Datensatz für die NBA.
<p>
&lt;absatz&gt;
						Entscheidungspunkt-Informationen für einen Entscheidungspunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlNbaZielEntscheidungspunkte implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 _entscheidungspunktReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _normalRichtung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
	
		/**
		Referenz auf den Entscheidungspunkt, für den die Informationen gelten.
		<p>
		
		</p>
		
		@return der Wert von EntscheidungspunktReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 getEntscheidungspunktReferenz() {
			return _entscheidungspunktReferenz;
		}
	
		/**
		Referenz auf den Entscheidungspunkt, für den die Informationen gelten.
		<p>
		
		</p>
		
		@param _entscheidungspunktReferenz der neue Wert von EntscheidungspunktReferenz.
		*/
		public void setEntscheidungspunktReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
		 _entscheidungspunktReferenz) {
			this._entscheidungspunktReferenz = _entscheidungspunktReferenz;
		}
	
		/**
		Gibt an, ob die angegebene FahrtRichtung die Normalrichtung ist.
		<p>
		
		</p>
		
		@return der Wert von NormalRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNormalRichtung() {
			return _normalRichtung;
		}
	
		/**
		Gibt an, ob die angegebene FahrtRichtung die Normalrichtung ist.
		<p>
		
		</p>
		
		@param _normalRichtung der neue Wert von NormalRichtung.
		*/
		public void setNormalRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _normalRichtung) {
			this._normalRichtung = _normalRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für das Ziel an dem referenzierten Entscheidungspunkt an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für das Ziel an dem referenzierten Entscheidungspunkt an.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEntscheidungspunktReferenz = getEntscheidungspunktReferenz();
					final SystemObject tmpEntscheidungspunktReferenz;
						if (soEntscheidungspunktReferenz instanceof SystemObject) {
							tmpEntscheidungspunktReferenz = (SystemObject)soEntscheidungspunktReferenz;
						} else if(soEntscheidungspunktReferenz instanceof SystemObjekt){
							tmpEntscheidungspunktReferenz = ((SystemObjekt)soEntscheidungspunktReferenz).getSystemObject();
						} else{
							tmpEntscheidungspunktReferenz = null;
						}
					datum.getReferenceValue("EntscheidungspunktReferenz").setSystemObject(tmpEntscheidungspunktReferenz);
				// GanzzahlAttributTyp
				if (getNormalRichtung() != null) {
	                if (getNormalRichtung().isZustand()) {
	                    datum.getUnscaledValue("NormalRichtung").setText(getNormalRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NormalRichtung").set(getNormalRichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEntscheidungspunktReferenz = daten.getReferenceValue("EntscheidungspunktReferenz").getId();
					final SystemObjekt tmpEntscheidungspunktReferenz;
					if (idEntscheidungspunktReferenz == 0) {
						tmpEntscheidungspunktReferenz = null;
					} else {
						final SystemObject soEntscheidungspunktReferenz = factory.getDav().getDataModel().getObject(idEntscheidungspunktReferenz);
						if (soEntscheidungspunktReferenz == null) {
								tmpEntscheidungspunktReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaEntscheidungspunktUngueltig(idEntscheidungspunktReferenz);
						} else {
							tmpEntscheidungspunktReferenz = factory.getModellobjekt(soEntscheidungspunktReferenz);
						}
					}
					setEntscheidungspunktReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
					) tmpEntscheidungspunktReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NormalRichtung").isState()) {
							setNormalRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NormalRichtung").getText()));
						} else {
						setNormalRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NormalRichtung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielEntscheidungspunkte clone() {
		AtlNbaZielEntscheidungspunkte klon = new AtlNbaZielEntscheidungspunkte();
		
						klon.setEntscheidungspunktReferenz(getEntscheidungspunktReferenz());
						klon.setNormalRichtung(getNormalRichtung());
						klon.setFahrtRichtung(getFahrtRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
