/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelner FahrtRichtung-Prognose-Datensatz für die NBA.
<p>
&lt;absatz&gt;
						Entscheidungspunkt-Informationen für einen Prognosezeitpunkt für einen Entscheidungspunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlNbaZielEntscheidungspunktePrognoseZeitpunkt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitpunkt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _normalRichtung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
	
		/**
		Zeitpunkt für die prognostizierte FahrtRichtung.
		<p>
		
		</p>
		
		@return der Wert von Zeitpunkt.
		*/
			public 	Zeitstempel
			 getZeitpunkt() {
			return _zeitpunkt;
		}
	
		/**
		Zeitpunkt für die prognostizierte FahrtRichtung.
		<p>
		
		</p>
		
		@param _zeitpunkt der neue Wert von Zeitpunkt.
		*/
		public void setZeitpunkt(	Zeitstempel
		 _zeitpunkt) {
			this._zeitpunkt = _zeitpunkt;
		}
	
		/**
		Gibt an, ob die angegebene FahrtRichtung die Normalrichtung ist.
		<p>
		
		</p>
		
		@return der Wert von NormalRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNormalRichtung() {
			return _normalRichtung;
		}
	
		/**
		Gibt an, ob die angegebene FahrtRichtung die Normalrichtung ist.
		<p>
		
		</p>
		
		@param _normalRichtung der neue Wert von NormalRichtung.
		*/
		public void setNormalRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _normalRichtung) {
			this._normalRichtung = _normalRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für das Ziel an dem referenzierten Entscheidungspunkt an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für das Ziel an dem referenzierten Entscheidungspunkt an.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
				// GanzzahlAttributTyp
				if (getNormalRichtung() != null) {
	                if (getNormalRichtung().isZustand()) {
	                    datum.getUnscaledValue("NormalRichtung").setText(getNormalRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NormalRichtung").set(getNormalRichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Zeitpunkt").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NormalRichtung").isState()) {
							setNormalRichtung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NormalRichtung").getText()));
						} else {
						setNormalRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NormalRichtung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielEntscheidungspunktePrognoseZeitpunkt clone() {
		AtlNbaZielEntscheidungspunktePrognoseZeitpunkt klon = new AtlNbaZielEntscheidungspunktePrognoseZeitpunkt();
		
						klon.setZeitpunkt(getZeitpunkt());
						klon.setNormalRichtung(getNormalRichtung());
						klon.setFahrtRichtung(getFahrtRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
