/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu einer Route von einem EntscheidungsPunkt zu einem Ziel.
<p>
&lt;absatz&gt;
						Informationen zu einer Route von einem EntscheidungsPunkt zu einem Ziel.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlNbaZielRoutenDiagnoseRoute implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private 	RelativerZeitstempel
			 _reisezeitOhneHysterese
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaRoutenZustand
			 _routeAusgewaehlt
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoutenElement
			> _routenElemente = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoutenElement
			>(0, true);
	
		/**
		Nummer der Route in der Routenliste.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Nummer der Route in der Routenliste.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Aktuelle Reisezeit auf der Route plus HystereseZeit.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit auf der Route plus HystereseZeit.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit auf der Route.
		<p>
		
		</p>
		
		@return der Wert von ReisezeitOhneHysterese.
		*/
			public 	RelativerZeitstempel
			 getReisezeitOhneHysterese() {
			return _reisezeitOhneHysterese;
		}
	
		/**
		Aktuelle Reisezeit auf der Route.
		<p>
		
		</p>
		
		@param _reisezeitOhneHysterese der neue Wert von ReisezeitOhneHysterese.
		*/
		public void setReisezeitOhneHysterese(	RelativerZeitstempel
		 _reisezeitOhneHysterese) {
			this._reisezeitOhneHysterese = _reisezeitOhneHysterese;
		}
	
		/**
		Route für die für die Fahrbeziehung vom EntscheidungsPunkt zum Ziel ausgewählt wurde.
		<p>
		
		</p>
		
		@return der Wert von RouteAusgewaehlt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaRoutenZustand
			 getRouteAusgewaehlt() {
			return _routeAusgewaehlt;
		}
	
		/**
		Route für die für die Fahrbeziehung vom EntscheidungsPunkt zum Ziel ausgewählt wurde.
		<p>
		
		</p>
		
		@param _routeAusgewaehlt der neue Wert von RouteAusgewaehlt.
		*/
		public void setRouteAusgewaehlt(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaRoutenZustand
		 _routeAusgewaehlt) {
			this._routeAusgewaehlt = _routeAusgewaehlt;
		}
	
		/**
		RoutenElemente, die die Route bilden.
		<p>
		
		</p>
		
		@return der Wert von RoutenElemente.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoutenElement
			> getRoutenElemente() {
			return _routenElemente;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ReisezeitOhneHysterese").setMillis(getReisezeitOhneHysterese().getTime());
				// GanzzahlAttributTyp
				if (getRouteAusgewaehlt() != null) {
	                if (getRouteAusgewaehlt().isZustand()) {
	                    datum.getUnscaledValue("RouteAusgewählt").setText(getRouteAusgewaehlt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("RouteAusgewählt").set(getRouteAusgewaehlt().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayRoutenElemente = datum.getArray("RoutenElemente");
					arrayRoutenElemente.setLength(getRoutenElemente().size());
					for (int i = 0; i < arrayRoutenElemente.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoutenElement
						 atl = getRoutenElemente().get(i);
						atl.bean2Atl(arrayRoutenElemente.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// ZeitstempelAttributTyp
					setReisezeitOhneHysterese(new
						RelativerZeitstempel
						(daten.getTimeValue("ReisezeitOhneHysterese").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RouteAusgewählt").isState()) {
							setRouteAusgewaehlt(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaRoutenZustand
							.getZustand(daten.getScaledValue("RouteAusgewählt").getText()));
						} else {
						setRouteAusgewaehlt(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaRoutenZustand
						(daten.
							getUnscaledValue
						("RouteAusgewählt").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayRoutenElemente = daten.getArray("RoutenElemente");
					for (int i = 0; i < arrayRoutenElemente.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoutenElement
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoutenElement
						 ();
						atl.atl2Bean(arrayRoutenElemente.getItem(i), factory);
						getRoutenElemente().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielRoutenDiagnoseRoute clone() {
		AtlNbaZielRoutenDiagnoseRoute klon = new AtlNbaZielRoutenDiagnoseRoute();
		
						klon.setName(getName());
						klon.setReisezeit(getReisezeit());
						klon.setReisezeitOhneHysterese(getReisezeitOhneHysterese());
						klon.setRouteAusgewaehlt(getRouteAusgewaehlt());
					klon._routenElemente = getRoutenElemente().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
