/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu allen Routen (RoutenListe) von einem EntscheidungsPunkt zu einem Ziel.
<p>
&lt;absatz&gt;
						Informationen zu allen möglichen Routen (RoutenListe) von einem EntscheidungsPunkt zu einem Ziel.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlNbaZielRoutenDiagnoseRoutenListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 _entscheidungsPunkt
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoute
			> _routen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoute
			>(0, true);
	
		/**
		EntscheidungsPunkt vor dem die Routen zum Ziel führen.
		<p>
		
		</p>
		
		@return der Wert von EntscheidungsPunkt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
			 getEntscheidungsPunkt() {
			return _entscheidungsPunkt;
		}
	
		/**
		EntscheidungsPunkt vor dem die Routen zum Ziel führen.
		<p>
		
		</p>
		
		@param _entscheidungsPunkt der neue Wert von EntscheidungsPunkt.
		*/
		public void setEntscheidungsPunkt(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
		 _entscheidungsPunkt) {
			this._entscheidungsPunkt = _entscheidungsPunkt;
		}
	
		/**
		Alle möglichen Routen von einem EntscheidungsPunkt zu einem Ziel.
		<p>
		
		</p>
		
		@return der Wert von Routen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoute
			> getRouten() {
			return _routen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soEntscheidungsPunkt = getEntscheidungsPunkt();
					final SystemObject tmpEntscheidungsPunkt;
						if (soEntscheidungsPunkt instanceof SystemObject) {
							tmpEntscheidungsPunkt = (SystemObject)soEntscheidungsPunkt;
						} else if(soEntscheidungsPunkt instanceof SystemObjekt){
							tmpEntscheidungsPunkt = ((SystemObjekt)soEntscheidungsPunkt).getSystemObject();
						} else{
							tmpEntscheidungsPunkt = null;
						}
					datum.getReferenceValue("EntscheidungsPunkt").setSystemObject(tmpEntscheidungsPunkt);
				// AttributListenDefinition
					final Data.Array arrayRouten = datum.getArray("Routen");
					arrayRouten.setLength(getRouten().size());
					for (int i = 0; i < arrayRouten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoute
						 atl = getRouten().get(i);
						atl.bean2Atl(arrayRouten.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idEntscheidungsPunkt = daten.getReferenceValue("EntscheidungsPunkt").getId();
					final SystemObjekt tmpEntscheidungsPunkt;
					if (idEntscheidungsPunkt == 0) {
						tmpEntscheidungsPunkt = null;
					} else {
						final SystemObject soEntscheidungsPunkt = factory.getDav().getDataModel().getObject(idEntscheidungsPunkt);
						if (soEntscheidungsPunkt == null) {
								tmpEntscheidungsPunkt = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaEntscheidungspunktUngueltig(idEntscheidungsPunkt);
						} else {
							tmpEntscheidungsPunkt = factory.getModellobjekt(soEntscheidungsPunkt);
						}
					}
					setEntscheidungsPunkt((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaEntscheidungspunkt
					) tmpEntscheidungsPunkt);
				// AttributListenDefinition
					final Data.Array arrayRouten = daten.getArray("Routen");
					for (int i = 0; i < arrayRouten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoute
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaZielRoutenDiagnoseRoute
						 ();
						atl.atl2Bean(arrayRouten.getItem(i), factory);
						getRouten().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZielRoutenDiagnoseRoutenListe clone() {
		AtlNbaZielRoutenDiagnoseRoutenListe klon = new AtlNbaZielRoutenDiagnoseRoutenListe();
		
						klon.setEntscheidungsPunkt(getEntscheidungsPunkt());
					klon._routen = getRouten().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
