/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekte für die Bestimmung des Zufluss.
<p>
&lt;absatz&gt;
						Objekte für die Bestimmung des Zufluss.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 31
 */
public class AtlNbaZwischenErgebnisseStauObjekteZufluss implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittVorStau
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _ersterMessQuerschnittImStau
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> _einfahrendeMessQuerschnitteVorStau = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> _ausfahrendeMessQuerschnitteVorStau = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			>(0, true);
	
		/**
		Messquerschnitt vor dem Stau.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnittVorStau.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 getMessQuerschnittVorStau() {
			return _messQuerschnittVorStau;
		}
	
		/**
		Messquerschnitt vor dem Stau.
		<p>
		
		</p>
		
		@param _messQuerschnittVorStau der neue Wert von MessQuerschnittVorStau.
		*/
		public void setMessQuerschnittVorStau(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
		 _messQuerschnittVorStau) {
			this._messQuerschnittVorStau = _messQuerschnittVorStau;
		}
	
		/**
		Erster Messquerschnitt vor dem Stau.
		<p>
		
		</p>
		
		@return der Wert von ErsterMessQuerschnittImStau.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 getErsterMessQuerschnittImStau() {
			return _ersterMessQuerschnittImStau;
		}
	
		/**
		Erster Messquerschnitt vor dem Stau.
		<p>
		
		</p>
		
		@param _ersterMessQuerschnittImStau der neue Wert von ErsterMessQuerschnittImStau.
		*/
		public void setErsterMessQuerschnittImStau(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
		 _ersterMessQuerschnittImStau) {
			this._ersterMessQuerschnittImStau = _ersterMessQuerschnittImStau;
		}
	
		/**
		Einfahrende Messquerschnitte zwischen dem Messquerschnitt vor dem Stau und dem Stau.
		<p>
		
		</p>
		
		@return der Wert von EinfahrendeMessQuerschnitteVorStau.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> getEinfahrendeMessQuerschnitteVorStau() {
			return _einfahrendeMessQuerschnitteVorStau;
		}
	
	
		/**
		Ausfahrende Messquerschnitte zwischen dem Messquerschnitt vor dem Stau und dem Stau.
		<p>
		
		</p>
		
		@return der Wert von AusfahrendeMessQuerschnitteVorStau.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			> getAusfahrendeMessQuerschnitteVorStau() {
			return _ausfahrendeMessQuerschnitteVorStau;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnittVorStau = getMessQuerschnittVorStau();
					final SystemObject tmpMessQuerschnittVorStau;
						if (soMessQuerschnittVorStau instanceof SystemObject) {
							tmpMessQuerschnittVorStau = (SystemObject)soMessQuerschnittVorStau;
						} else if(soMessQuerschnittVorStau instanceof SystemObjekt){
							tmpMessQuerschnittVorStau = ((SystemObjekt)soMessQuerschnittVorStau).getSystemObject();
						} else{
							tmpMessQuerschnittVorStau = null;
						}
					datum.getReferenceValue("MessQuerschnittVorStau").setSystemObject(tmpMessQuerschnittVorStau);
				// ObjektReferenzAttributTyp
					final Object soErsterMessQuerschnittImStau = getErsterMessQuerschnittImStau();
					final SystemObject tmpErsterMessQuerschnittImStau;
						if (soErsterMessQuerschnittImStau instanceof SystemObject) {
							tmpErsterMessQuerschnittImStau = (SystemObject)soErsterMessQuerschnittImStau;
						} else if(soErsterMessQuerschnittImStau instanceof SystemObjekt){
							tmpErsterMessQuerschnittImStau = ((SystemObjekt)soErsterMessQuerschnittImStau).getSystemObject();
						} else{
							tmpErsterMessQuerschnittImStau = null;
						}
					datum.getReferenceValue("ErsterMessQuerschnittImStau").setSystemObject(tmpErsterMessQuerschnittImStau);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEinfahrendeMessQuerschnitteVorStau = datum.getReferenceArray("EinfahrendeMessQuerschnitteVorStau");
					arrayEinfahrendeMessQuerschnitteVorStau.setLength(getEinfahrendeMessQuerschnitteVorStau().size());
					for (int i = 0; i < arrayEinfahrendeMessQuerschnitteVorStau.getLength(); ++i) {
						final Object soEinfahrendeMessQuerschnitteVorStau = getEinfahrendeMessQuerschnitteVorStau().get(i);
						final SystemObject tmpEinfahrendeMessQuerschnitteVorStau;
						if (soEinfahrendeMessQuerschnitteVorStau instanceof SystemObject) {
							tmpEinfahrendeMessQuerschnitteVorStau = (SystemObject)soEinfahrendeMessQuerschnitteVorStau;
						} else if(soEinfahrendeMessQuerschnitteVorStau instanceof SystemObjekt){
							tmpEinfahrendeMessQuerschnitteVorStau = ((SystemObjekt)soEinfahrendeMessQuerschnitteVorStau).getSystemObject();
						} else{
							tmpEinfahrendeMessQuerschnitteVorStau = null;
						}
						arrayEinfahrendeMessQuerschnitteVorStau.getReferenceValue(i).setSystemObject(tmpEinfahrendeMessQuerschnitteVorStau);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAusfahrendeMessQuerschnitteVorStau = datum.getReferenceArray("AusfahrendeMessQuerschnitteVorStau");
					arrayAusfahrendeMessQuerschnitteVorStau.setLength(getAusfahrendeMessQuerschnitteVorStau().size());
					for (int i = 0; i < arrayAusfahrendeMessQuerschnitteVorStau.getLength(); ++i) {
						final Object soAusfahrendeMessQuerschnitteVorStau = getAusfahrendeMessQuerschnitteVorStau().get(i);
						final SystemObject tmpAusfahrendeMessQuerschnitteVorStau;
						if (soAusfahrendeMessQuerschnitteVorStau instanceof SystemObject) {
							tmpAusfahrendeMessQuerschnitteVorStau = (SystemObject)soAusfahrendeMessQuerschnitteVorStau;
						} else if(soAusfahrendeMessQuerschnitteVorStau instanceof SystemObjekt){
							tmpAusfahrendeMessQuerschnitteVorStau = ((SystemObjekt)soAusfahrendeMessQuerschnitteVorStau).getSystemObject();
						} else{
							tmpAusfahrendeMessQuerschnitteVorStau = null;
						}
						arrayAusfahrendeMessQuerschnitteVorStau.getReferenceValue(i).setSystemObject(tmpAusfahrendeMessQuerschnitteVorStau);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnittVorStau = daten.getReferenceValue("MessQuerschnittVorStau").getId();
					final SystemObjekt tmpMessQuerschnittVorStau;
					if (idMessQuerschnittVorStau == 0) {
						tmpMessQuerschnittVorStau = null;
					} else {
						final SystemObject soMessQuerschnittVorStau = factory.getDav().getDataModel().getObject(idMessQuerschnittVorStau);
						if (soMessQuerschnittVorStau == null) {
								tmpMessQuerschnittVorStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittVorStau);
						} else {
							tmpMessQuerschnittVorStau = factory.getModellobjekt(soMessQuerschnittVorStau);
						}
					}
					setMessQuerschnittVorStau((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
					) tmpMessQuerschnittVorStau);
				// ObjektReferenzAttributTyp
					final long idErsterMessQuerschnittImStau = daten.getReferenceValue("ErsterMessQuerschnittImStau").getId();
					final SystemObjekt tmpErsterMessQuerschnittImStau;
					if (idErsterMessQuerschnittImStau == 0) {
						tmpErsterMessQuerschnittImStau = null;
					} else {
						final SystemObject soErsterMessQuerschnittImStau = factory.getDav().getDataModel().getObject(idErsterMessQuerschnittImStau);
						if (soErsterMessQuerschnittImStau == null) {
								tmpErsterMessQuerschnittImStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idErsterMessQuerschnittImStau);
						} else {
							tmpErsterMessQuerschnittImStau = factory.getModellobjekt(soErsterMessQuerschnittImStau);
						}
					}
					setErsterMessQuerschnittImStau((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
					) tmpErsterMessQuerschnittImStau);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEinfahrendeMessQuerschnitteVorStau = daten.getReferenceArray("EinfahrendeMessQuerschnitteVorStau");
					for (int i = 0; i < arrayEinfahrendeMessQuerschnitteVorStau.getLength(); ++i) {
						final long idEinfahrendeMessQuerschnitteVorStau = daten.getReferenceArray("EinfahrendeMessQuerschnitteVorStau").getReferenceValue(i).getId();
						final SystemObjekt tmpEinfahrendeMessQuerschnitteVorStau;
						if (idEinfahrendeMessQuerschnitteVorStau == 0) {
							tmpEinfahrendeMessQuerschnitteVorStau = null;
						} else {
							final SystemObject soEinfahrendeMessQuerschnitteVorStau = factory.getDav().getDataModel().getObject(idEinfahrendeMessQuerschnitteVorStau);
							if (soEinfahrendeMessQuerschnitteVorStau == null) {
									tmpEinfahrendeMessQuerschnitteVorStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idEinfahrendeMessQuerschnitteVorStau);
							} else {
								tmpEinfahrendeMessQuerschnitteVorStau = factory.getModellobjekt(soEinfahrendeMessQuerschnitteVorStau);
							}
						}
							getEinfahrendeMessQuerschnitteVorStau().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
							) tmpEinfahrendeMessQuerschnitteVorStau);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAusfahrendeMessQuerschnitteVorStau = daten.getReferenceArray("AusfahrendeMessQuerschnitteVorStau");
					for (int i = 0; i < arrayAusfahrendeMessQuerschnitteVorStau.getLength(); ++i) {
						final long idAusfahrendeMessQuerschnitteVorStau = daten.getReferenceArray("AusfahrendeMessQuerschnitteVorStau").getReferenceValue(i).getId();
						final SystemObjekt tmpAusfahrendeMessQuerschnitteVorStau;
						if (idAusfahrendeMessQuerschnitteVorStau == 0) {
							tmpAusfahrendeMessQuerschnitteVorStau = null;
						} else {
							final SystemObject soAusfahrendeMessQuerschnitteVorStau = factory.getDav().getDataModel().getObject(idAusfahrendeMessQuerschnitteVorStau);
							if (soAusfahrendeMessQuerschnitteVorStau == null) {
									tmpAusfahrendeMessQuerschnitteVorStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idAusfahrendeMessQuerschnitteVorStau);
							} else {
								tmpAusfahrendeMessQuerschnitteVorStau = factory.getModellobjekt(soAusfahrendeMessQuerschnitteVorStau);
							}
						}
							getAusfahrendeMessQuerschnitteVorStau().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
							) tmpAusfahrendeMessQuerschnitteVorStau);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaZwischenErgebnisseStauObjekteZufluss clone() {
		AtlNbaZwischenErgebnisseStauObjekteZufluss klon = new AtlNbaZwischenErgebnisseStauObjekteZufluss();
		
						klon.setMessQuerschnittVorStau(getMessQuerschnittVorStau());
						klon.setErsterMessQuerschnittImStau(getErsterMessQuerschnittImStau());
					klon._einfahrendeMessQuerschnitteVorStau = getEinfahrendeMessQuerschnitteVorStau().clone();
					klon._ausfahrendeMessQuerschnitteVorStau = getAusfahrendeMessQuerschnitteVorStau().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
