/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
mögliche Umfeldbedingungen bei der Berechnung von Fundamentaldiagrammen.
<p>
&lt;absatz&gt;
						Bei der Berechnung von Fundamentaldiagrammen wird festgelegt für welche
						Umfeldbedingung das Fundamentaldiagramm gültig ist.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Mit dem Zustand "nicht definiert" kann man die Zuordnung zu Umfeldbedingungen
						ausschalten.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttNbaUmfeldbedingungen extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_1N_NICHT_DEFINIERT = new AttNbaUmfeldbedingungen("nicht definiert", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_1_LUFTTEMPERATUR = new AttNbaUmfeldbedingungen("Lufttemperatur", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_2_FAHRBAHNOBERFLAECHENTEMPERATUR = new AttNbaUmfeldbedingungen("Fahrbahnoberflächentemperatur", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_3_FAHRBAHNFEUCHTE = new AttNbaUmfeldbedingungen("Fahrbahnfeuchte", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_4_FAHRBAHNOBERFLAECHENZUSTAND = new AttNbaUmfeldbedingungen("Fahrbahnoberflächenzustand", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_5_RESTSALZ = new AttNbaUmfeldbedingungen("Restsalz", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_6_NIEDERSCHLAGSINTENSITAET = new AttNbaUmfeldbedingungen("Niederschlagsintensität", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_7_LUFTDRUCK = new AttNbaUmfeldbedingungen("Luftdruck", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_8_LUFTFEUCHTE = new AttNbaUmfeldbedingungen("Luftfeuchte", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_9_WINDRICHTUNG = new AttNbaUmfeldbedingungen("Windrichtung", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_10_WINDGESCHWINDIGKEITMITTELWERT = new AttNbaUmfeldbedingungen("WindgeschwindigkeitMittelwert", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_11_WINDGESCHWINDIGKEITSPITZENWERT = new AttNbaUmfeldbedingungen("WindgeschwindigkeitSpitzenwert", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_12_SCHNEEHOEHE = new AttNbaUmfeldbedingungen("Schneehöhe", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_13_FAHRBAHNGLAETTE = new AttNbaUmfeldbedingungen("Fahrbahnglätte", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_14_SICHTWEITE = new AttNbaUmfeldbedingungen("Sichtweite", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_15_HELLIGKEIT = new AttNbaUmfeldbedingungen("Helligkeit", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_16_NIEDERSCHLAGSMENGE = new AttNbaUmfeldbedingungen("Niederschlagsmenge", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_17_NIEDERSCHLAGSART = new AttNbaUmfeldbedingungen("Niederschlagsart", 		Byte
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_18_GEFRIERTEMPERATUR = new AttNbaUmfeldbedingungen("Gefriertemperatur", 		Byte
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_19_TAUPUNKTTEMPERATUR = new AttNbaUmfeldbedingungen("Taupunkttemperatur", 		Byte
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_20_TEMPERATURINTIEFE1 = new AttNbaUmfeldbedingungen("TemperaturInTiefe1", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_21_TEMPERATURINTIEFE2 = new AttNbaUmfeldbedingungen("TemperaturInTiefe2", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_22_TEMPERATURINTIEFE3 = new AttNbaUmfeldbedingungen("TemperaturInTiefe3", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttNbaUmfeldbedingungen ZUSTAND_23_WASSERFILMDICKE = new AttNbaUmfeldbedingungen("Wasserfilmdicke", 		Byte
	.valueOf("23"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNbaUmfeldbedingungen getZustand(final 		Byte
	 value) {
		for (AttNbaUmfeldbedingungen e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNbaUmfeldbedingungen getZustand(final String value) {
		for (AttNbaUmfeldbedingungen e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNbaUmfeldbedingungen> getZustaende() {
		List<AttNbaUmfeldbedingungen> list = new ArrayList<AttNbaUmfeldbedingungen>();
		list.add(ZUSTAND_1N_NICHT_DEFINIERT);
		list.add(ZUSTAND_1_LUFTTEMPERATUR);
		list.add(ZUSTAND_2_FAHRBAHNOBERFLAECHENTEMPERATUR);
		list.add(ZUSTAND_3_FAHRBAHNFEUCHTE);
		list.add(ZUSTAND_4_FAHRBAHNOBERFLAECHENZUSTAND);
		list.add(ZUSTAND_5_RESTSALZ);
		list.add(ZUSTAND_6_NIEDERSCHLAGSINTENSITAET);
		list.add(ZUSTAND_7_LUFTDRUCK);
		list.add(ZUSTAND_8_LUFTFEUCHTE);
		list.add(ZUSTAND_9_WINDRICHTUNG);
		list.add(ZUSTAND_10_WINDGESCHWINDIGKEITMITTELWERT);
		list.add(ZUSTAND_11_WINDGESCHWINDIGKEITSPITZENWERT);
		list.add(ZUSTAND_12_SCHNEEHOEHE);
		list.add(ZUSTAND_13_FAHRBAHNGLAETTE);
		list.add(ZUSTAND_14_SICHTWEITE);
		list.add(ZUSTAND_15_HELLIGKEIT);
		list.add(ZUSTAND_16_NIEDERSCHLAGSMENGE);
		list.add(ZUSTAND_17_NIEDERSCHLAGSART);
		list.add(ZUSTAND_18_GEFRIERTEMPERATUR);
		list.add(ZUSTAND_19_TAUPUNKTTEMPERATUR);
		list.add(ZUSTAND_20_TEMPERATURINTIEFE1);
		list.add(ZUSTAND_21_TEMPERATURINTIEFE2);
		list.add(ZUSTAND_22_TEMPERATURINTIEFE3);
		list.add(ZUSTAND_23_WASSERFILMDICKE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut nbaUmfeldbedingungen.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNbaUmfeldbedingungen(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNbaUmfeldbedingungen(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
