/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften des Entscheidungspunktes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class KdNbaEntscheidungspunkt extends AbstractKonfigurationsDatensatz<KdNbaEntscheidungspunkt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _beschreibung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
				 _aeusseresStrassenSegmentReferenz
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktFahrtRichtung
				> _entscheidungspunktFahrtRichtungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktFahrtRichtung
				>(0, true);
		
			/**
			Weitergehende Beschreibung des Entscheidungspunktes.
			<p>
			
			</p>
			
			@return der Wert von Beschreibung.
			*/
				public String
				 getBeschreibung() {
				return _beschreibung;
			}
		
			/**
			Weitergehende Beschreibung des Entscheidungspunktes.
			<p>
			
			</p>
			
			@param _beschreibung der neue Wert von Beschreibung.
			*/
			public void setBeschreibung(String
			 _beschreibung) {
				if (_beschreibung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._beschreibung = _beschreibung;
			}
		
			/**
			Äußeres StraßenSegment, an dessen Ende der Entscheidungspunkt liegt.
			<p>
			
			</p>
			
			@return der Wert von AeusseresStrassenSegmentReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
				 getAeusseresStrassenSegmentReferenz() {
				return _aeusseresStrassenSegmentReferenz;
			}
		
			/**
			Äußeres StraßenSegment, an dessen Ende der Entscheidungspunkt liegt.
			<p>
			
			</p>
			
			@param _aeusseresStrassenSegmentReferenz der neue Wert von AeusseresStrassenSegmentReferenz.
			*/
			public void setAeusseresStrassenSegmentReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
			 _aeusseresStrassenSegmentReferenz) {
				this._aeusseresStrassenSegmentReferenz = _aeusseresStrassenSegmentReferenz;
			}
		
			/**
			Am Entscheidungspunkt vorhandene FahrtRichtungen mit folgendem NbaRoutenStück.
			<p>
			
			</p>
			
			@return der Wert von EntscheidungspunktFahrtRichtungen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktFahrtRichtung
				> getEntscheidungspunktFahrtRichtungen() {
				return _entscheidungspunktFahrtRichtungen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getBeschreibung() != null) {
						datum.getTextValue("Beschreibung").setText(getBeschreibung());
					}
					// ObjektReferenzAttributTyp
						final Object soAeusseresStrassenSegmentReferenz = getAeusseresStrassenSegmentReferenz();
						final SystemObject tmpAeusseresStrassenSegmentReferenz;
							if (soAeusseresStrassenSegmentReferenz instanceof SystemObject) {
								tmpAeusseresStrassenSegmentReferenz = (SystemObject)soAeusseresStrassenSegmentReferenz;
							} else if(soAeusseresStrassenSegmentReferenz instanceof SystemObjekt){
								tmpAeusseresStrassenSegmentReferenz = ((SystemObjekt)soAeusseresStrassenSegmentReferenz).getSystemObject();
							} else{
								tmpAeusseresStrassenSegmentReferenz = null;
							}
						datum.getReferenceValue("ÄußeresStraßenSegmentReferenz").setSystemObject(tmpAeusseresStrassenSegmentReferenz);
					// AttributListenDefinition
						final Data.Array arrayEntscheidungspunktFahrtRichtungen = datum.getArray("EntscheidungspunktFahrtRichtungen");
						arrayEntscheidungspunktFahrtRichtungen.setLength(getEntscheidungspunktFahrtRichtungen().size());
						for (int i = 0; i < arrayEntscheidungspunktFahrtRichtungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktFahrtRichtung
							 atl = getEntscheidungspunktFahrtRichtungen().get(i);
							atl.bean2Atl(arrayEntscheidungspunktFahrtRichtungen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setBeschreibung(daten.getTextValue("Beschreibung").getText());
					// ObjektReferenzAttributTyp
						final long idAeusseresStrassenSegmentReferenz = daten.getReferenceValue("ÄußeresStraßenSegmentReferenz").getId();
						final SystemObjekt tmpAeusseresStrassenSegmentReferenz;
						if (idAeusseresStrassenSegmentReferenz == 0) {
							tmpAeusseresStrassenSegmentReferenz = null;
						} else {
							final SystemObject soAeusseresStrassenSegmentReferenz = factory.getDav().getDataModel().getObject(idAeusseresStrassenSegmentReferenz);
							if (soAeusseresStrassenSegmentReferenz == null) {
									tmpAeusseresStrassenSegmentReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.AeusseresStrassenSegmentUngueltig(idAeusseresStrassenSegmentReferenz);
							} else {
								tmpAeusseresStrassenSegmentReferenz = factory.getModellobjekt(soAeusseresStrassenSegmentReferenz);
							}
						}
						setAeusseresStrassenSegmentReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
						) tmpAeusseresStrassenSegmentReferenz);
					// AttributListenDefinition
						final Data.Array arrayEntscheidungspunktFahrtRichtungen = daten.getArray("EntscheidungspunktFahrtRichtungen");
						for (int i = 0; i < arrayEntscheidungspunktFahrtRichtungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktFahrtRichtung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktFahrtRichtung
							 ();
							atl.atl2Bean(arrayEntscheidungspunktFahrtRichtungen.getItem(i), factory);
							getEntscheidungspunktFahrtRichtungen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBeschreibung(getBeschreibung());
							klon.setAeusseresStrassenSegmentReferenz(getAeusseresStrassenSegmentReferenz());
						klon._entscheidungspunktFahrtRichtungen = getEntscheidungspunktFahrtRichtungen().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaEntscheidungspunkt";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdNbaEntscheidungspunkt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
