/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stellvetreter für AnzeigeQuerschnitt im Bereich der Steuerung.
<p>
&lt;absatz&gt;
						Stellvetreter für AnzeigeQuerschnitt im Bereich der Steuerung. Er wird für Handschaltungen der Bedienoberflächen verwendet.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public interface AnzeigeQuerschnittSteuerung extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.anzeigeQuerschnittSteuerung"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parameter für die Helligkeitssteuerung.
	<p>
	&lt;absatz&gt;
							Zuordnung eines UfdsSensors zu einem AnzeigenQuerschnitt.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz HelligkeitSteuerungV1.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHelligkeitSteuerungV1 getPdHelligkeitSteuerungV1();
	
	/**
	Attributgruppe zur Speicherung der Ergebnisdaten Ursacheneinheit.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Speicherung der Ergebnisdaten pro Ursacheneinheit
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaUeSchaltbild.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeSchaltbild getPdNbaUeSchaltbild();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Zuordnung von Wechseltexten.
	<p>
	&lt;absatz&gt;
							Zuordnung von vordefinierten Wechseltexten zu Anzeigen des AQ.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz WechseltextZuordnungAnzeigen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdWechseltextZuordnungAnzeigen getPdWechseltextZuordnungAnzeigen();
	
	/**
	Attributgruppe zur Übergabe des Programm-Status.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Übergabe des Programm-Status.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz AnzeigeQuerschnittStatusProgramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusProgramm getOdAnzeigeQuerschnittStatusProgramm();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter für die Helligkeitssteuerung.
	<p>
	&lt;absatz&gt;
							Zuordnung von Helligkeitswerten (Prozent) zu Helligkeitsstufen für die Helligkeitssteuerung.
	            Helligkeitsstufe entspricht Index + 1.		
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz HelligkeitSteuerungStufe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHelligkeitSteuerungStufe getPdHelligkeitSteuerungStufe();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parameter für die Überwachung der Wechselwegweiser.
	<p>
	&lt;absatz&gt;
							Parameter für die Überwachung der Wechselwegweiser pro AQ.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaUeberwachung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUeberwachung getPdNbaUeberwachung();
	
	/**
	Attributgruppe zur Übergabe des Rückmeldung-Status.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Übergabe des Rückmeldung-Status.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz AnzeigeQuerschnittStatusRueckmeldungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusRueckmeldungen getOdAnzeigeQuerschnittStatusRueckmeldungen();
	
	/**
	Attributgruppe zur Übergabe des Befehls-Status.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Übergabe des Befehls-Status
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz AnzeigeQuerschnittStatusBefehle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusBefehle getOdAnzeigeQuerschnittStatusBefehle();
	
	/**
	Attributgruppe für die Übergabe und zur Speicherung des Handeingriff Helligkeit.
	<p>
	Attributgruppe für die Übergabe und zur Speicherung des Handeingriff Helligkeit.
	</p>
	@return der Datensatz HandeingriffHelligkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHandeingriffHelligkeit getPdHandeingriffHelligkeit();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs 'typ.anzeigeQuerschnittSteuerung'.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnittSteuerung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.konfigurationsdaten.KdAnzeigeQuerschnittSteuerung getKdAnzeigeQuerschnittSteuerung();
	
	/**
	Attributgruppe zur Übergabe des Allgemein-Status.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Übergabe des Allgemein-Status.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz AnzeigeQuerschnittStatusAllgemein.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdAnzeigeQuerschnittStatusAllgemein getOdAnzeigeQuerschnittStatusAllgemein();
	
	/**
	Strategien für den AnzeigeQuerschnitt.
	<p>
	
	</p>
	@return der Datensatz AnzeigeQuerschnittStrategien.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdAnzeigeQuerschnittStrategien getPdAnzeigeQuerschnittStrategien();
	
	/**
	Attributgruppe für die Übergabe und zur Speicherung des Handeingriff Betriebsart.
	<p>
	Attributgruppe für die Übergabe und zur Speicherung des Handeingriff Betriebsart.
	</p>
	@return der Datensatz HandeingriffBetriebsart.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdHandeingriffBetriebsart getPdHandeingriffBetriebsart();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
