/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Globaler Datentyp der NBA.
<p>
&lt;absatz&gt;
						Das Objekt nbaGlobal ist ein persistentes dynamisches Objekt, das nicht vom Benutzer konfiguriert oder parametriert werden kann.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface NbaGlobal extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.nbaGlobal"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Definition Attributgruppe nbaParameterGanglinieTyp.
	<p>
	
	</p>
	@return der Datensatz NbaParameterGanglinieTyp.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinieTyp getPdNbaParameterGanglinieTyp();
	
	/**
	Parameter für die Stauanalyse.
	<p>
	
	</p>
	@return der Datensatz NbaParameterStauanalyse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterStauanalyse getPdNbaParameterStauanalyse();
	
	/**
	Parameter für die Ganglinienauswahl.
	<p>
	
	</p>
	@return der Datensatz NbaParameterGanglinienAuswahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinienAuswahl getPdNbaParameterGanglinienAuswahl();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Definition Attributgruppe nbaParameterFundamental.
	<p>
	
	</p>
	@return der Datensatz NbaParameterFundamental.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterFundamental getPdNbaParameterFundamental();
	
	/**
	Attributgruppe zur Speicherung der Ergebnisdaten.
	<p>
	&lt;absatz&gt;
							Attributgruppe zur Speicherung der Ergebnisdaten Steuerlogik lokale Beeinflussung
	            pro Algorithmus
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaStrgDatenLokaleBeeinflussung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaStrgDatenLokaleBeeinflussung getOdNbaStrgDatenLokaleBeeinflussung();
	
	/**
	Definition Attributgruppe nbaParameterFundamentalTyp.
	<p>
	
	</p>
	@return der Datensatz NbaParameterFundamentalTyp.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterFundamentalTyp getPdNbaParameterFundamentalTyp();
	
	/**
	Definition Attributgruppe nbaParameterDifferenzGanglinieTyp.
	<p>
	
	</p>
	@return der Datensatz NbaParameterDifferenzGanglinieTyp.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterDifferenzGanglinieTyp getPdNbaParameterDifferenzGanglinieTyp();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Beinhaltet die Parameter für die EngstellenVerwaltung.
	<p>
	&lt;absatz&gt;Beinhaltet die Parameter für die EngstellenVerwaltung.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaParameterBaustellenMeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterBaustellenMeldung getPdNbaParameterBaustellenMeldung();
	
	/**
	Beinhaltet die Parameter für die Kapazitätsermittlung.
	<p>
	&lt;absatz&gt;Beinhaltet die Parameter für die Kapazitätsermittlung.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz NbaParameterKapazitaetsermittlung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterKapazitaetsermittlung getPdNbaParameterKapazitaetsermittlung();
	
	/**
	Definition Attributgruppe nbaBedingungFundamental.
	<p>
	
	</p>
	@return der Datensatz NbaBedingungFundamental.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaBedingungFundamental getPdNbaBedingungFundamental();
	
	/**
	Zwischenergebnisse der Stauprognose.
	<p>
	
	</p>
	@return der Datensatz NbaZwischenErgebnisseStau.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.onlinedaten.OdNbaZwischenErgebnisseStau getOdNbaZwischenErgebnisseStau();
	
	/**
	Parameter Überwachung der Prognoseergebnisse.
	<p>
	
	</p>
	@return der Datensatz NbaParameterUeberwachungPrognoseErgebnisse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterUeberwachungPrognoseErgebnisse getPdNbaParameterUeberwachungPrognoseErgebnisse();
	
	/**
	Parameter für die Steuerungslogik für die netzweite Beeinflussung Reisezeiten pro Route.
	<p>
	
	</p>
	@return der Datensatz NbaStrgParameterReisezeitenRoute.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaStrgParameterReisezeitenRoute getPdNbaStrgParameterReisezeitenRoute();
	
	/**
	Definition Attributgruppe nbaUmfeld.
	<p>
	
	</p>
	@return der Datensatz NbaUmfeld.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaUmfeld getPdNbaUmfeld();
	
	/**
	Parameter für die Berechnung der Stauprognose.
	<p>
	
	</p>
	@return der Datensatz NbaParameterStauPrognose.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterStauPrognose getPdNbaParameterStauPrognose();
	
	/**
	Ergebnisdaten Fundamentaldiagramm.
	<p>
	
	</p>
	@return der Datensatz NbaFundamentaldiagramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaFundamentaldiagramm getPdNbaFundamentaldiagramm();
	
	/**
	Parameter für das Objekt nbaGanglinie.
	<p>
	
	</p>
	@return der Datensatz NbaGanglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaGanglinie getPdNbaGanglinie();
	
	/**
	Definition Attributgruppe nbaParameterGanglinieGlobal.
	<p>
	
	</p>
	@return der Datensatz NbaParameterGanglinieGlobal.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterGanglinieGlobal getPdNbaParameterGanglinieGlobal();
	
	/**
	Globale Parameter für das NBA Verkehrsmodell.
	<p>
	
	</p>
	@return der Datensatz NbaParameterVerkehrsmodellGlobal.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterVerkehrsmodellGlobal getPdNbaParameterVerkehrsmodellGlobal();
	
	/**
	Parameter für die Berechnung der Prognoseganglinie.
	<p>
	
	</p>
	@return der Datensatz NbaParameterPrognoseGanglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.parameter.PdNbaParameterPrognoseGanglinie getPdNbaParameterPrognoseGanglinie();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
